/*
 * Decompiled with CFR 0.152.
 */
package com.inet.cowork.server.webapi.user;

import com.inet.cowork.api.CoWorkManager;
import com.inet.cowork.api.model.OnlineStatus;
import com.inet.cowork.api.model.UserStatus;
import com.inet.cowork.server.webapi.user.UserStatusInformationRequest;
import com.inet.cowork.server.webapi.user.UserStatusInformationResponse;
import com.inet.id.GUID;
import com.inet.plugin.webapi.api.ResponseWriter;
import com.inet.plugin.webapi.api.handler.RequestHandler;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@Tag(name="User", description="User status operations")
public class a
extends RequestHandler<UserStatusInformationRequest, UserStatusInformationResponse> {
    public a() {
        super(new String[]{"user"});
    }

    public String getHelpPageKey() {
        return "webapi.cowork.user";
    }

    @Operation(summary="Get or update user status", description="Retrieves or updates the current user's status information including online status, custom status message, and flags", responses={@ApiResponse(responseCode="200", description="User status retrieved or updated successfully", content={@Content(schema=@Schema(implementation=UserStatusInformationResponse.class))}), @ApiResponse(responseCode="404", description="User account not found")})
    public UserStatusInformationResponse a(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, @Nullable UserStatusInformationRequest userStatusInformationRequest, boolean bl) throws IOException {
        Object object;
        String string;
        CoWorkManager coWorkManager = CoWorkManager.getInstance();
        UserManager userManager = UserManager.getInstance();
        UserAccount userAccount = userManager.getCurrentUserAccount();
        if (userAccount == null) {
            ResponseWriter.notFound((HttpServletResponse)httpServletResponse, (String)"There is no user account available ");
            return null;
        }
        GUID gUID = userAccount.getID();
        UserStatus userStatus = coWorkManager.getUserStatus(gUID);
        if (userStatus == null) {
            userStatus = new UserStatus(gUID, OnlineStatus.online, "", null);
        }
        if (userStatusInformationRequest != null) {
            Set<String> set;
            string = userStatusInformationRequest.getCustomStatus();
            if (string == null) {
                string = userStatus.getCustomStatus();
            }
            if ((object = userStatusInformationRequest.getOnlineStatus()) == null) {
                object = userStatus.getStatus();
            }
            userStatus = new UserStatus(gUID, (OnlineStatus)((Object)object), string, userStatus.getFlags());
            Boolean bl2 = userStatusInformationRequest.isIdle();
            if (bl2 != null) {
                userStatus.setIdle(bl2);
            }
            if ((set = userStatusInformationRequest.getFlags()) != null) {
                userStatus.getFlags().clear();
                userStatus.getFlags().addAll(set);
            }
            if (!bl) {
                coWorkManager.saveUserStatus(userStatus);
            }
        }
        string = userAccount.getDisplayName();
        object = UserStatusInformationResponse.from(string, gUID, userStatus);
        return object;
    }

    @Operation(summary="Get or update user status", description="Retrieves or updates the current user's status information including online status, custom status message, and flags", responses={@ApiResponse(responseCode="200", description="User status retrieved or updated successfully", content={@Content(schema=@Schema(implementation=UserStatusInformationResponse.class))}), @ApiResponse(responseCode="404", description="User account not found")})
    public /* synthetic */ Object handle(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, @Nullable Object object, boolean bl) throws IOException {
        return this.a(httpServletRequest, httpServletResponse, (UserStatusInformationRequest)object, bl);
    }
}

