/*
 * Decompiled with CFR 0.152.
 */
package com.inet.cowork.api.model;

import com.inet.annotations.JsonData;
import com.inet.cowork.server.c;
import com.inet.cowork.server.d;
import com.inet.editor.HtmlConverter;
import com.inet.id.GUID;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonData
public class CoWorkMessage {
    private static final int GUID_TIMEPART_LENGTH = 10;
    private static String lastGeneratedId;
    private GUID id;
    private GUID userId;
    private GUID parentId;
    private String text;
    private transient String formattedText;
    private long created;
    private long modified;
    private List<GUID> attachmentsIds;
    private LinkedHashMap<String, Set<ReactionEntry>> reactions;

    private CoWorkMessage() {
    }

    public CoWorkMessage(@Nonnull GUID id, @Nullable GUID userId, @Nullable GUID parentId, @Nullable String text, long created, @Nullable List<GUID> attachmentsIds, @Nullable LinkedHashMap<String, Set<ReactionEntry>> reactions) {
        this.id = id;
        this.userId = userId;
        this.parentId = parentId;
        this.created = created;
        this.reactions = reactions;
        this.modified = System.currentTimeMillis();
        this.text = text;
        this.attachmentsIds = attachmentsIds;
    }

    public CoWorkMessage(@Nullable GUID userId, @Nullable String text) {
        this(CoWorkMessage.generateSortableGuid(), userId, null, text, System.currentTimeMillis(), null, null);
        this.modified = this.created;
    }

    private static GUID generateSortableGuid() {
        long l2 = System.currentTimeMillis();
        String string = Long.toString(l2, 36);
        StringBuilder stringBuilder = new StringBuilder(25);
        int n2 = 10 - string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuilder.append('0');
        }
        stringBuilder.append(string);
        stringBuilder.append(GUID.generateNew().toString().substring(10));
        String string2 = stringBuilder.toString();
        String string3 = lastGeneratedId;
        if (string3 != null) {
            while (string2.compareTo(string3) <= 0) {
                if (l2 < System.currentTimeMillis()) {
                    return CoWorkMessage.generateSortableGuid();
                }
                stringBuilder.setLength(10);
                stringBuilder.append(GUID.generateNew().toString().substring(10));
                string2 = stringBuilder.toString();
            }
        }
        GUID gUID = GUID.valueOf((String)string2);
        lastGeneratedId = string2;
        return gUID;
    }

    @Nonnull
    public GUID getId() {
        return this.id;
    }

    @Nullable
    public GUID getUserId() {
        return this.userId;
    }

    @Nullable
    public String getText() {
        return this.text;
    }

    public void setText(@Nullable String text) {
        this.text = text;
        this.formattedText = null;
    }

    public long getCreated() {
        return this.created;
    }

    public long getModified() {
        return this.modified;
    }

    @Nullable
    public GUID getParentId() {
        return this.parentId;
    }

    public void setParentId(@Nullable GUID parentId) {
        this.parentId = parentId;
    }

    public void setAttachmentsIds(@Nullable List<GUID> attachmentsIds) {
        this.attachmentsIds = attachmentsIds;
    }

    @Nullable
    public List<GUID> getAttachmentsIds() {
        return this.attachmentsIds;
    }

    public boolean toggleReaction(@Nonnull String shortName, @Nonnull GUID userId) {
        ReactionEntry reactionEntry;
        Set set;
        boolean bl = false;
        if (this.reactions == null) {
            this.reactions = new LinkedHashMap();
        }
        if (!(set = this.reactions.computeIfAbsent(shortName, k2 -> new HashSet())).remove(reactionEntry = new ReactionEntry(userId, System.currentTimeMillis()))) {
            set.add(reactionEntry);
            bl = true;
        }
        if (set.isEmpty()) {
            this.reactions.remove(shortName);
        }
        return bl;
    }

    public void setReactions(@Nullable LinkedHashMap<String, Set<ReactionEntry>> reactions) {
        this.reactions = reactions;
    }

    @Nullable
    public LinkedHashMap<String, Set<ReactionEntry>> getReactions() {
        return this.reactions;
    }

    @Nullable
    public String getFormattedText() {
        if (this.formattedText == null && this.text != null) {
            String string = c.f(this.text);
            if (string == this.text) {
                string = d.X.convert(string);
            }
            this.formattedText = string;
        }
        return this.formattedText;
    }

    @Nullable
    public String getPlainText() {
        if (this.text != null) {
            String string = c.f(this.text);
            if (string == this.text) {
                string = d.Z.convert(string);
            }
            return HtmlConverter.html2text((String)string);
        }
        return this.text;
    }

    @JsonData
    public static class ReactionEntry {
        private GUID userId;
        private long timestamp;

        private ReactionEntry() {
        }

        public ReactionEntry(GUID userId, long timestamp) {
            this.userId = userId;
            this.timestamp = timestamp;
        }

        public GUID getUserId() {
            return this.userId;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public int hashCode() {
            int n2 = 31;
            int n3 = 1;
            n3 = 31 * n3 + (this.userId == null ? 0 : this.userId.hashCode());
            return n3;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ReactionEntry reactionEntry = (ReactionEntry)obj;
            return !(this.userId == null ? reactionEntry.userId != null : !this.userId.equals((Object)reactionEntry.userId));
        }
    }
}

