/*
 * Decompiled with CFR 0.152.
 */
package com.inet.cowork.server.webapi.channels;

import com.inet.authentication.AccessForbiddenException;
import com.inet.cowork.api.CoWorkManager;
import com.inet.cowork.api.model.CoWorkChannel;
import com.inet.cowork.api.model.CoWorkTeam;
import com.inet.cowork.server.webapi.channels.ChannelCreateRequestData;
import com.inet.cowork.server.webapi.channels.ChannelListResponseData;
import com.inet.cowork.server.webapi.channels.ChannelResponseData;
import com.inet.cowork.server.webapi.channels.a;
import com.inet.cowork.server.webapi.channels.d;
import com.inet.http.ClientMessageException;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.webapi.api.ResponseWriter;
import com.inet.plugin.webapi.api.handler.RequestHandler;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@Tag(name="Admin Channels", description="Administrative channel management operations")
public class b
extends d {
    public b() {
        super("channels");
        this.setGenericRequestHandler((RequestHandler)new a());
    }

    @Override
    public String getHelpPageKey() {
        return "webapi.cowork.admin.teams.channels";
    }

    @Override
    @Operation(summary="Manage administrative channels", description="Lists all channels in a team or creates a new channel. Requires team admin permission.", requestBody=@RequestBody(description="Channel creation data", content={@Content(schema=@Schema(implementation=ChannelCreateRequestData.class))}), responses={@ApiResponse(responseCode="200", description="List of channels retrieved or new channel created successfully", content={@Content(schema=@Schema(implementation=ChannelListResponseData.class))}), @ApiResponse(responseCode="400", description="Invalid channel creation data or missing team"), @ApiResponse(responseCode="403", description="Access denied - user is not a team admin or team is predefined"), @ApiResponse(responseCode="404", description="Team not found")})
    public ChannelListResponseData b(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @Nullable ChannelCreateRequestData channelCreateRequestData, @Nullable GUID gUID, List<String> list, boolean bl) throws IOException {
        CoWorkManager coWorkManager = CoWorkManager.getInstance();
        CoWorkTeam coWorkTeam = coWorkManager.getTeam(gUID);
        if (coWorkTeam == null) {
            throw new ClientMessageException("Team could not be not found or is not available for the user.");
        }
        if (!coWorkTeam.isAdmin() || coWorkTeam.isPredefined()) {
            throw new AccessForbiddenException("User is not an admin of the given team.");
        }
        List<CoWorkChannel> list2 = null;
        CoWorkChannel coWorkChannel = this.a(httpServletRequest, coWorkTeam, channelCreateRequestData, bl);
        if (coWorkChannel != null) {
            list2 = Arrays.asList(coWorkChannel);
            ResponseWriter.json((HttpServletResponse)httpServletResponse, (Object)ChannelResponseData.from(coWorkChannel));
        } else {
            list2 = coWorkManager.getAllChannelsInTeam(gUID);
            ResponseWriter.json((HttpServletResponse)httpServletResponse, (Object)ChannelListResponseData.from(list2, false));
        }
        return ChannelListResponseData.from(list2, false);
    }

    public boolean shouldSendJsonResponse() {
        return false;
    }

    private CoWorkChannel a(HttpServletRequest httpServletRequest, @Nonnull CoWorkTeam coWorkTeam, @Nullable ChannelCreateRequestData channelCreateRequestData, boolean bl) {
        if (channelCreateRequestData == null) {
            if (this.isMethodAllowedForData(httpServletRequest)) {
                throw new ClientMessageException("Channel creation requested, but no data sent.");
            }
            return null;
        }
        if (StringFunctions.isEmpty((String)channelCreateRequestData.getDisplayName())) {
            throw new ClientMessageException("The 'displayName' of a channel has to be set.");
        }
        CoWorkChannel coWorkChannel = null;
        coWorkChannel = channelCreateRequestData.isMembersInherited() ? CoWorkChannel.create(null, coWorkTeam.getId(), channelCreateRequestData.getDisplayName(), channelCreateRequestData.getDescription()) : CoWorkChannel.create(null, coWorkTeam.getId(), channelCreateRequestData.getDisplayName(), channelCreateRequestData.getDescription(), channelCreateRequestData.getMemberUserIDs(), channelCreateRequestData.getMemberGroupIDs());
        if (!bl) {
            CoWorkManager.getInstance().saveChannel(coWorkChannel);
        }
        return coWorkChannel;
    }

    @Override
    @Operation(summary="Manage administrative channels", description="Lists all channels in a team or creates a new channel. Requires team admin permission.", requestBody=@RequestBody(description="Channel creation data", content={@Content(schema=@Schema(implementation=ChannelCreateRequestData.class))}), responses={@ApiResponse(responseCode="200", description="List of channels retrieved or new channel created successfully", content={@Content(schema=@Schema(implementation=ChannelListResponseData.class))}), @ApiResponse(responseCode="400", description="Invalid channel creation data or missing team"), @ApiResponse(responseCode="403", description="Access denied - user is not a team admin or team is predefined"), @ApiResponse(responseCode="404", description="Team not found")})
    public /* synthetic */ Object handle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @Nullable Object object, @Nullable Object object2, List list, boolean bl) throws IOException {
        return this.b(httpServletRequest, httpServletResponse, (ChannelCreateRequestData)object, (GUID)object2, list, bl);
    }
}

