/*
 * Decompiled with CFR 0.152.
 */
package com.inet.cowork.server.data;

import com.inet.annotations.JsonData;
import com.inet.cowork.server.data.AttachmentMetaDataDescription;
import com.inet.cowork.server.data.ParentMessageDescription;
import com.inet.http.servlet.ClientLocale;
import com.inet.http.servlet.ClientTimezone;
import com.inet.id.GUID;
import java.text.DateFormat;
import java.util.List;

@JsonData
public class MessageDescription {
    private GUID id;
    private GUID userId;
    private String text;
    private String formattedText;
    private long created;
    private long modified;
    private String date;
    private String time;
    private boolean mentioned;
    private List<AttachmentMetaDataDescription> attachments;
    private ParentMessageDescription parent;
    private List<ReactionEntryDescription> reactions;

    public MessageDescription(GUID id, GUID userId, String text, String formattedText, long created, long modified, boolean mentioned, List<ReactionEntryDescription> reactions) {
        this.id = id;
        this.userId = userId;
        this.text = text;
        this.formattedText = formattedText;
        this.created = created;
        this.modified = modified;
        this.mentioned = mentioned;
        this.reactions = reactions;
        DateFormat dateFormat = DateFormat.getDateInstance(2, ClientLocale.getThreadLocale());
        DateFormat dateFormat2 = DateFormat.getTimeInstance(3, ClientLocale.getThreadLocale());
        dateFormat.setTimeZone(ClientTimezone.getTimeZone());
        dateFormat2.setTimeZone(ClientTimezone.getTimeZone());
        this.date = dateFormat.format(created);
        this.time = dateFormat2.format(created);
    }

    public void setAttachments(List<AttachmentMetaDataDescription> attachments) {
        this.attachments = attachments;
    }

    public void setParent(ParentMessageDescription parent) {
        this.parent = parent;
    }

    public void setMentioned(boolean mentioned) {
        this.mentioned = mentioned;
    }

    public GUID getUserId() {
        return this.userId;
    }

    public String getText() {
        return this.text;
    }

    public ParentMessageDescription getParent() {
        return this.parent;
    }

    public List<ReactionEntryDescription> getReactions() {
        return this.reactions;
    }

    @JsonData
    public static class ReactionUserDescription {
        private GUID userId;
        private String displayName;
        private long timestamp;

        private ReactionUserDescription() {
        }

        public ReactionUserDescription(GUID userId, String displayName, long timestamp) {
            this.userId = userId;
            this.displayName = displayName;
            this.timestamp = timestamp;
        }

        public GUID getUserId() {
            return this.userId;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public long getTimestamp() {
            return this.timestamp;
        }
    }

    @JsonData
    public static class ReactionEntryDescription {
        private String reactionShortName;
        private List<ReactionUserDescription> users;
        private boolean reacted;

        private ReactionEntryDescription() {
        }

        public ReactionEntryDescription(String reactionShortName, boolean reacted, List<ReactionUserDescription> users) {
            this.reactionShortName = reactionShortName;
            this.reacted = reacted;
            this.users = users;
        }

        public String getReactionShortName() {
            return this.reactionShortName;
        }

        public boolean isReacted() {
            return this.reacted;
        }

        public List<ReactionUserDescription> getUsers() {
            return this.users;
        }
    }
}

