/*
 * Decompiled with CFR 0.152.
 */
package com.inet.cowork.api.search;

import com.inet.annotations.InternalApi;
import com.inet.cowork.api.CoWorkManager;
import com.inet.cowork.api.CoWorkPermissions;
import com.inet.cowork.api.model.CoWorkChannel;
import com.inet.cowork.api.model.CoWorkTeam;
import com.inet.cowork.server.search.e;
import com.inet.http.servlet.SessionStore;
import com.inet.id.GUID;
import com.inet.search.command.AndSearchExpression;
import com.inet.search.command.OrSearchExpression;
import com.inet.search.command.PhraseSearchExpression;
import com.inet.search.command.PrefilteredSearchExpression;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.search.command.SearchID;
import com.inet.search.command.SubtractSearchExpression;
import com.inet.search.command.TextSearchCommandBuilder;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class UserSearch {
    @Nonnull
    public static Set<GUID> getUsersOfMyChannels(@Nullable String phrase) {
        return UserSearch.getUsersOfMyChannels(phrase, 100, true);
    }

    @Nonnull
    public static Set<GUID> getUsersOfMyChannels(@Nullable String phrase, int limit, boolean ignoreEmptySearchPhrease) {
        UserGroupInfo userGroupInfo;
        SearchCommand searchCommand;
        Object object;
        SearchCommand searchCommand2 = new TextSearchCommandBuilder(e.v().w(), phrase).build();
        AndSearchExpression andSearchExpression = searchCommand2.getSearchExpression();
        UserSearch.removeFieldExpressions((List<SearchExpression>)andSearchExpression);
        if (ignoreEmptySearchPhrease && phrase != null && andSearchExpression.isEmpty()) {
            return Collections.emptySet();
        }
        CoWorkManager coWorkManager = CoWorkManager.getInstance();
        if (!UserGroupManager.getInstance().getGroup(UsersAndGroups.GROUPID_ALLUSERS).getPermissions().contains(CoWorkPermissions.PERMISSION_COWORK)) {
            object = new OrSearchExpression();
            andSearchExpression.add((SearchExpression)object);
            object.add((Object)new SearchCondition("permissions", SearchCondition.SearchTermOperator.Equals, (Object)CoWorkPermissions.PERMISSION_COWORK));
            searchCommand = new SearchCommand("permissions", SearchCondition.SearchTermOperator.Equals, (Object)CoWorkPermissions.PERMISSION_COWORK);
            Set object2 = UserGroupManager.getInstance().getSearchEngine().simpleSearch(searchCommand);
            for (CoWorkChannel coWorkChannel : object2) {
                userGroupInfo = UserGroupManager.getInstance().getGroup((GUID)coWorkChannel);
                if (userGroupInfo == null) continue;
                object.add((Object)new SearchCondition("useraccountid", SearchCondition.SearchTermOperator.IN, (Object)userGroupInfo.getMemberIDs()));
            }
        }
        object = new HashSet();
        for (CoWorkTeam coWorkTeam : coWorkManager.getTeams()) {
            if (!coWorkTeam.isAvailable()) continue;
            for (CoWorkChannel coWorkChannel : coWorkManager.getChannels(coWorkTeam.getId())) {
                userGroupInfo = coWorkChannel.getAllMemberIds();
                ((AbstractCollection)object).addAll(userGroupInfo);
            }
        }
        andSearchExpression.add((SearchExpression)new PrefilteredSearchExpression((Collection)object));
        andSearchExpression.add((SearchExpression)new SubtractSearchExpression((SearchExpression)new SearchCondition("useraccountid", SearchCondition.SearchTermOperator.Equals, (Object)UserManager.getInstance().getCurrentUserAccountID())));
        searchCommand = SessionStore.getHttpSession((boolean)false);
        if (searchCommand != null) {
            searchCommand2.setID(new SearchID((Object)searchCommand.getId()));
        }
        searchCommand2 = new SearchCommand(new SearchExpression[]{andSearchExpression});
        return UserManager.getInstance().getSearchEngine().simpleSearch(searchCommand2);
    }

    @Nonnull
    public static Set<GUID> getAllCoWorkUsers(@Nullable String phrase, int limit, boolean ignoreEmptySearchPhrease) {
        OrSearchExpression orSearchExpression;
        SearchCommand searchCommand = new TextSearchCommandBuilder(e.v().w(), phrase).build();
        AndSearchExpression andSearchExpression = searchCommand.getSearchExpression();
        UserSearch.removeFieldExpressions((List<SearchExpression>)andSearchExpression);
        if (ignoreEmptySearchPhrease && phrase != null && andSearchExpression.isEmpty()) {
            return Collections.emptySet();
        }
        if (!UserGroupManager.getInstance().getGroup(UsersAndGroups.GROUPID_ALLUSERS).getPermissions().contains(CoWorkPermissions.PERMISSION_COWORK)) {
            orSearchExpression = new OrSearchExpression();
            andSearchExpression.add((SearchExpression)orSearchExpression);
            orSearchExpression.add((Object)new SearchCondition("permissions", SearchCondition.SearchTermOperator.Equals, (Object)CoWorkPermissions.PERMISSION_COWORK));
            SearchCommand searchCommand2 = new SearchCommand("permissions", SearchCondition.SearchTermOperator.Equals, (Object)CoWorkPermissions.PERMISSION_COWORK);
            Set set = UserGroupManager.getInstance().getSearchEngine().simpleSearch(searchCommand2);
            for (GUID gUID : set) {
                UserGroupInfo userGroupInfo = UserGroupManager.getInstance().getGroup(gUID);
                if (userGroupInfo == null) continue;
                orSearchExpression.add((Object)new SearchCondition("useraccountid", SearchCondition.SearchTermOperator.IN, (Object)userGroupInfo.getMemberIDs()));
            }
        } else {
            andSearchExpression.add((SearchExpression)new SearchCondition("useraccountid", SearchCondition.SearchTermOperator.StartsWith, (Object)""));
        }
        orSearchExpression = SessionStore.getHttpSession((boolean)false);
        if (orSearchExpression != null) {
            searchCommand.setID(new SearchID((Object)orSearchExpression.getId()));
        }
        searchCommand = new SearchCommand(new SearchExpression[]{andSearchExpression});
        return UserManager.getInstance().getSearchEngine().simpleSearch(searchCommand);
    }

    public static void removeFieldExpressions(@Nonnull List<SearchExpression> expressions) {
        Iterator<SearchExpression> iterator = expressions.iterator();
        while (iterator.hasNext()) {
            SearchExpression searchExpression = iterator.next();
            switch (searchExpression.getType()) {
                case Condition: {
                    if (((SearchCondition)searchExpression).getLeftOperand() == null) break;
                    iterator.remove();
                    break;
                }
                case Or: 
                case And: {
                    List list = (List)searchExpression;
                    UserSearch.removeFieldExpressions(list);
                    if (!list.isEmpty()) break;
                    iterator.remove();
                    break;
                }
                case Phrase: {
                    if (((PhraseSearchExpression)searchExpression).getLeftOperand() == null) break;
                    iterator.remove();
                }
            }
        }
    }
}

