/*
 * Decompiled with CFR 0.152.
 */
package com.inet.cowork.server.webapi.teams;

import com.inet.cowork.api.CoWorkManager;
import com.inet.cowork.api.CoWorkPermissions;
import com.inet.cowork.api.model.CoWorkTeam;
import com.inet.cowork.server.webapi.teams.TeamCreateRequestData;
import com.inet.cowork.server.webapi.teams.TeamListResponseData;
import com.inet.cowork.server.webapi.teams.a;
import com.inet.cowork.server.webapi.teams.d;
import com.inet.http.ClientMessageException;
import com.inet.lib.util.StringFunctions;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.webapi.api.ResponseWriter;
import com.inet.plugin.webapi.api.handler.RequestHandler;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@Tag(name="Admin Teams", description="Administrative team management operations")
public class b
extends d {
    public b() {
        super("teams");
        this.setGenericRequestHandler((RequestHandler)new a());
    }

    @Override
    public String getHelpPageKey() {
        return "webapi.cowork.admin.teams";
    }

    @Override
    @Operation(summary="Manage administrative teams", description="Lists all teams with administrative access or creates a new administrative team. Requires CoWork Admin permission.", responses={@ApiResponse(responseCode="200", description="List of administrative teams retrieved or new team created successfully", content={@Content(schema=@Schema(implementation=TeamListResponseData.class))}), @ApiResponse(responseCode="400", description="Invalid team creation data"), @ApiResponse(responseCode="403", description="Access denied - user does not have CoWork Admin permission")})
    public TeamListResponseData a(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, @Nullable TeamCreateRequestData teamCreateRequestData, boolean bl) throws IOException {
        ArrayList<CoWorkTeam> arrayList = new ArrayList<CoWorkTeam>();
        CoWorkTeam coWorkTeam2 = this.b(httpServletRequest, httpServletResponse, teamCreateRequestData, bl);
        if (coWorkTeam2 != null) {
            arrayList = Arrays.asList(coWorkTeam2);
            ResponseWriter.json((HttpServletResponse)httpServletResponse, (Object)TeamListResponseData.Entry.from(coWorkTeam2));
        } else {
            arrayList.addAll(CoWorkManager.getInstance().getTeams());
            arrayList.removeIf(coWorkTeam -> !coWorkTeam.isAdmin() || coWorkTeam.isPredefined());
            ResponseWriter.json((HttpServletResponse)httpServletResponse, (Object)TeamListResponseData.from(arrayList));
        }
        return TeamListResponseData.from(arrayList);
    }

    public boolean shouldSendJsonResponse() {
        return false;
    }

    private CoWorkTeam b(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @Nullable TeamCreateRequestData teamCreateRequestData, boolean bl) {
        boolean bl2 = this.isMethodAllowedForData(httpServletRequest);
        if (bl2 && !SystemPermissionChecker.checkAccess((Permission)CoWorkPermissions.PERMISSION_COWORK_ADMIN)) {
            ResponseWriter.forbidden((HttpServletResponse)httpServletResponse, (Permission)CoWorkPermissions.PERMISSION_COWORK_ADMIN);
            return null;
        }
        if (bl2 && teamCreateRequestData == null) {
            throw new ClientMessageException("Team creation requested, but no data sent.");
        }
        if (teamCreateRequestData == null) {
            return null;
        }
        if (StringFunctions.isEmpty((String)teamCreateRequestData.getDisplayName())) {
            throw new ClientMessageException("The 'displayName' of a team has to be set.");
        }
        CoWorkTeam coWorkTeam = CoWorkTeam.create(null, teamCreateRequestData.getDisplayName(), teamCreateRequestData.getMemberUserIDs(), teamCreateRequestData.getMemberGroupIDs(), teamCreateRequestData.getAdminUserIDs(), teamCreateRequestData.getAdminGroupIDs());
        if (!bl) {
            CoWorkManager.getInstance().saveTeam(coWorkTeam);
        }
        return coWorkTeam;
    }

    @Override
    @Operation(summary="Manage administrative teams", description="Lists all teams with administrative access or creates a new administrative team. Requires CoWork Admin permission.", responses={@ApiResponse(responseCode="200", description="List of administrative teams retrieved or new team created successfully", content={@Content(schema=@Schema(implementation=TeamListResponseData.class))}), @ApiResponse(responseCode="400", description="Invalid team creation data"), @ApiResponse(responseCode="403", description="Access denied - user does not have CoWork Admin permission")})
    public /* synthetic */ Object handle(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, @Nullable Object object, boolean bl) throws IOException {
        return this.a(httpServletRequest, httpServletResponse, (TeamCreateRequestData)object, bl);
    }
}

