/*
 * Decompiled with CFR 0.152.
 */
package com.inet.cowork.server.webapi.channels;

import com.inet.annotations.JsonData;
import com.inet.cowork.api.model.CoWorkChannel;
import com.inet.id.GUID;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Set;
import javax.annotation.Nullable;

@JsonData
@Schema(description="Response data for a channel request")
public class ChannelResponseData {
    @Schema(description="Unique identifier of the channel")
    private GUID channelId;
    @Schema(description="Unique identifier of the team this channel belongs to")
    private GUID teamId;
    @Schema(description="Display name of the channel")
    private String displayName;
    @Schema(description="Description of the channel")
    private String description;

    public static ChannelResponseData from(@Nullable CoWorkChannel channel) {
        return ChannelResponseData.from(channel, false);
    }

    public static ChannelResponseData from(@Nullable CoWorkChannel channel, boolean adminContextRequested) {
        if (channel == null) {
            return null;
        }
        ChannelResponseData channelResponseData = adminContextRequested ? AdminChannelResponseData.from(channel) : new ChannelResponseData();
        channelResponseData.teamId = channel.getTeamId();
        channelResponseData.channelId = channel.getId();
        channelResponseData.displayName = channel.getDisplayName();
        channelResponseData.description = channel.getDescription();
        return channelResponseData;
    }

    @JsonData
    @Schema(description="Additional response data for administrative channel requests")
    public static class AdminChannelResponseData
    extends ChannelResponseData {
        @Schema(description="List of group IDs that are members of this channel")
        private Set<GUID> memberGroupIds;
        @Schema(description="List of user IDs that are members of this channel")
        private Set<GUID> memberUserIds;
        @Schema(description="Whether channel members are inherited from the team")
        private boolean membersInherited;

        public static AdminChannelResponseData from(CoWorkChannel channel) {
            AdminChannelResponseData adminChannelResponseData = new AdminChannelResponseData();
            adminChannelResponseData.memberGroupIds = channel.getMemberGroupIds();
            adminChannelResponseData.memberUserIds = channel.getMemberUserIds();
            adminChannelResponseData.membersInherited = channel.isMembersInherited();
            return adminChannelResponseData;
        }
    }
}

