/*
 * Decompiled with CFR 0.152.
 */
package com.inet.cowork.api;

import com.inet.annotations.InternalApi;
import com.inet.annotations.JsonData;
import com.inet.cowork.api.ChannelListener;
import com.inet.cowork.api.ChannelsTreeUpdateListener;
import com.inet.cowork.api.ClientInChannelStateScope;
import com.inet.cowork.api.ClientTreeStateScope;
import com.inet.cowork.api.CoWorkChannelListener;
import com.inet.cowork.api.CoWorkConnectedListener;
import com.inet.cowork.api.CoWorkI18n;
import com.inet.cowork.api.CoWorkMessageListener;
import com.inet.cowork.api.attachments.CoWorkAttachmentUtils;
import com.inet.cowork.api.grouping.MembersGrouping;
import com.inet.cowork.api.model.ClientInChannelState;
import com.inet.cowork.api.model.ClientTreeState;
import com.inet.cowork.api.model.CoWorkAttachment;
import com.inet.cowork.api.model.CoWorkChannel;
import com.inet.cowork.api.model.CoWorkMessage;
import com.inet.cowork.api.model.CoWorkTeam;
import com.inet.cowork.api.model.Draft;
import com.inet.cowork.api.model.MemberStatus;
import com.inet.cowork.api.model.MemberStatusGroup;
import com.inet.cowork.api.model.OnlineStatus;
import com.inet.cowork.api.model.UISettings;
import com.inet.cowork.api.model.UserMetaData;
import com.inet.cowork.api.model.UserStatus;
import com.inet.cowork.server.c;
import com.inet.cowork.server.persistence.d;
import com.inet.cowork.server.persistence.e;
import com.inet.cowork.server.persistence.f;
import com.inet.cowork.server.persistence.g;
import com.inet.cowork.server.persistence.h;
import com.inet.http.ClientMessageException;
import com.inet.http.PluginDispatcherServlet;
import com.inet.http.PluginServlet;
import com.inet.http.servlet.SessionStore;
import com.inet.http.websocket.WebSocketConnectionListener;
import com.inet.http.websocket.WebSocketEventData;
import com.inet.http.websocket.WebSocketEventHandler;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import com.inet.notification.Notification;
import com.inet.notification.NotificationManager;
import com.inet.permissions.AccessDeniedException;
import com.inet.persistence.Persistence;
import com.inet.persistence.PersistenceListener;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.plugin.ServerPluginManager;
import com.inet.remote.gui.emoji.EmojiData;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountScope;
import com.inet.usersandgroups.api.user.UserManager;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class CoWorkManager {
    public static final GUID DIRECTMESSAGE_TEAM_ID = GUID.valueOf((String)"coworkdirectmessages");
    private static CoWorkManager j;
    public static final Logger LOGGER;
    private e k = new e();
    private com.inet.cowork.server.persistence.c l = new com.inet.cowork.server.persistence.c();
    private d m = new d();
    private h n = new h();
    private com.inet.cowork.server.persistence.a o = new com.inet.cowork.server.persistence.a();
    private f p = new f();
    private g q = new g();
    private Map<GUID, CoWorkTeam> r;
    private Map<GUID, Set<String>> s = new ConcurrentHashMap<GUID, Set<String>>();
    private Map<String, ClientTreeState> t = new ConcurrentHashMap<String, ClientTreeState>();
    private Map<String, ClientInChannelState> u = new ConcurrentHashMap<String, ClientInChannelState>();
    private com.inet.cowork.server.search.g v = new com.inet.cowork.server.search.g();
    private List<CoWorkMessageListener> w;
    private List<CoWorkChannelListener> x;
    private List<CoWorkConnectedListener> y;
    private final List<MembersGrouping> z;

    private CoWorkManager() {
        WebSocketEventHandler.getInstance().addConnectionListener(new WebSocketConnectionListener(){

            public void connectionOpened(String clientId) {
            }

            public void connectionClosed(String clientId) {
                ClientInChannelState clientInChannelState = CoWorkManager.this.u.get(clientId);
                CoWorkManager.this.leaveChannel(clientId);
                CoWorkManager.this.unregisterFromChannelTreeUpdates(clientId);
                if (clientInChannelState != null) {
                    CoWorkManager.this.c(clientInChannelState.getChannelId());
                }
            }
        });
        Persistence.getInstance().registerListener((PersistenceListener)new a());
        this.z = ServerPluginManager.getInstance().get(MembersGrouping.class);
        this.z.sort(new Comparator<MembersGrouping>(){

            public int a(MembersGrouping membersGrouping, MembersGrouping membersGrouping2) {
                return Integer.compare(membersGrouping2.getPriority(), membersGrouping.getPriority());
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((MembersGrouping)object, (MembersGrouping)object2);
            }
        });
        ForkJoinPool.commonPool().execute(() -> PersistenceEvent.sendNewNode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nonnull
    public static CoWorkManager getInstance() {
        CoWorkManager coWorkManager = j;
        if (coWorkManager != null) return coWorkManager;
        Class<CoWorkManager> clazz = CoWorkManager.class;
        synchronized (CoWorkManager.class) {
            if (j != null) return j;
            j = new CoWorkManager();
            return j;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<GUID, CoWorkTeam> f() {
        if (this.r == null) {
            CoWorkManager coWorkManager = this;
            synchronized (coWorkManager) {
                if (this.r == null) {
                    this.r = ServerPluginManager.getInstance().get(CoWorkTeam.class).stream().collect(Collectors.toMap(CoWorkTeam::getId, coWorkTeam -> coWorkTeam));
                }
            }
        }
        return this.r;
    }

    public boolean hasAtLeastOneTeam() {
        List<CoWorkTeam> list = this.k.u();
        return !list.isEmpty();
    }

    public List<CoWorkTeam> getTeams() {
        List<CoWorkTeam> list = this.k.u();
        list.addAll(this.f().values());
        list.removeIf(coWorkTeam -> !coWorkTeam.isAvailable() && !coWorkTeam.isAdmin());
        return list;
    }

    public CoWorkTeam getTeam(GUID teamId) {
        return this.getTeam(teamId, UserManager.getInstance().getCurrentUserAccountID());
    }

    public CoWorkTeam getTeam(GUID teamId, GUID userId) {
        if (teamId == null) {
            return null;
        }
        CoWorkTeam coWorkTeam = this.k.getTeam(teamId);
        if (coWorkTeam == null) {
            coWorkTeam = this.f().get(teamId);
        }
        if (coWorkTeam == null || !coWorkTeam.isAvailable(userId) && !coWorkTeam.isAdmin(userId)) {
            return null;
        }
        return coWorkTeam;
    }

    public List<CoWorkChannel> getAllChannelsInTeam(GUID teamId) {
        return this.l.getAllChannelsInTeam(teamId);
    }

    public List<CoWorkChannel> getChannels(GUID teamId) {
        List<CoWorkChannel> list = this.l.getAllChannelsInTeam(teamId);
        list.removeIf(coWorkChannel -> !coWorkChannel.isAvailable());
        return list;
    }

    public CoWorkChannel getChannel(GUID channelId) {
        if (channelId == null) {
            return null;
        }
        return this.l.getChannel(channelId);
    }

    public Map<GUID, Set<String>> getConnectedUsers() {
        return Collections.unmodifiableMap(this.s);
    }

    public List<MemberStatusGroup> getUsersInChannel(GUID channelId) {
        CoWorkChannel coWorkChannel = this.getChannel(channelId);
        if (coWorkChannel != null) {
            Set<GUID> set = coWorkChannel.getAllMemberIds();
            List<MembersGrouping> list = this.z;
            HashMap hashMap = new HashMap();
            set.stream().map(gUID -> {
                UserStatus userStatus = this.n.getUserStatus((GUID)gUID);
                if (userStatus == null) {
                    userStatus = this.s.containsKey(gUID) ? new UserStatus((GUID)gUID, OnlineStatus.online, null, null) : new UserStatus((GUID)gUID, OnlineStatus.offline, null, null);
                } else if (!this.s.containsKey(gUID)) {
                    userStatus = new UserStatus((GUID)gUID, OnlineStatus.offline, userStatus.getCustomStatus(), userStatus.getFlags());
                }
                if (userStatus.getStatus() == OnlineStatus.invisible) {
                    userStatus = new UserStatus((GUID)gUID, OnlineStatus.offline, userStatus.getCustomStatus(), userStatus.getFlags());
                }
                return userStatus;
            }).forEach(userStatus -> {
                if (userStatus == null) {
                    return;
                }
                List list2 = null;
                for (Object object : list) {
                    if (!object.matchesGrouping((UserStatus)userStatus, channelId)) continue;
                    list2 = hashMap.computeIfAbsent(object.getDisplayName(), string -> new ArrayList());
                    break;
                }
                if (list2 != null) {
                    Object object;
                    UserAccount userAccount = UserManager.getInstance().getUserAccount(userStatus.getId());
                    object = userAccount == null ? userStatus.getId().toString() : userAccount.getDisplayName();
                    list2.add(new MemberStatus(userStatus.getId(), (String)object, userStatus.getStatus(), userStatus.getCustomStatus(), userStatus.isIdle(), userStatus.getFlags()));
                }
            });
            int n2 = 1000;
            ArrayList<MemberStatusGroup> arrayList = new ArrayList<MemberStatusGroup>();
            for (MembersGrouping membersGrouping : list) {
                if (hashMap.containsKey(membersGrouping.getDisplayName())) {
                    List list2 = (List)hashMap.get(membersGrouping.getDisplayName());
                    list2.sort(new Comparator<MemberStatus>(){

                        public int a(MemberStatus memberStatus, MemberStatus memberStatus2) {
                            return memberStatus.getDisplayName().compareToIgnoreCase(memberStatus2.getDisplayName());
                        }

                        @Override
                        public /* synthetic */ int compare(Object object, Object object2) {
                            return this.a((MemberStatus)object, (MemberStatus)object2);
                        }
                    });
                    if (list2.size() < n2) {
                        n2 -= list2.size();
                    } else {
                        list2.subList(0, n2);
                        n2 = 0;
                    }
                    arrayList.add(new MemberStatusGroup(membersGrouping.getExtensionName(), membersGrouping.getDisplayName(), membersGrouping.getShortDisplayName(), list2));
                }
                if (n2 > 0) continue;
                break;
            }
            return arrayList;
        }
        return Collections.emptyList();
    }

    public void registerForChannelTreeUpdates(String clientId, GUID userId, ChannelsTreeUpdateListener channelsTreeUpdateListener) {
        ClientTreeState clientTreeState = new ClientTreeState(clientId, userId, channelsTreeUpdateListener);
        this.t.put(clientId, clientTreeState);
        try (Object object = new ClientTreeStateScope(clientTreeState);){
            channelsTreeUpdateListener.onChannelsTreeChanged();
        }
        this.s.compute(userId, (gUID, keySetView) -> {
            if (keySetView == null) {
                keySetView = ConcurrentHashMap.newKeySet();
            }
            keySetView.add(clientId);
            return keySetView;
        });
        object = this.n.getUserStatus(userId);
        if (object == null) {
            this.n.saveUserStatus(new UserStatus(userId, OnlineStatus.online, null, null));
        }
        this.c((CoWorkConnectedListener coWorkConnectedListener) -> coWorkConnectedListener.userConnected(clientTreeState));
        this.b(userId);
        Persistence.getInstance().sendEvent((Object)PersistenceEvent.forChangedUserConnection(PersistenceEventType.USER_CONNECTED, clientId, userId));
    }

    public void unregisterFromChannelTreeUpdates(String clientId) {
        ClientTreeState clientTreeState = this.t.remove(clientId);
        if (clientTreeState != null) {
            this.s.computeIfPresent(clientTreeState.getUserId(), (gUID, set) -> {
                set.remove(clientId);
                if (set.isEmpty()) {
                    set = null;
                }
                return set;
            });
            this.b(clientTreeState.getUserId());
            this.c((CoWorkConnectedListener coWorkConnectedListener) -> coWorkConnectedListener.userDisconnected(clientTreeState));
            Persistence.getInstance().sendEvent((Object)PersistenceEvent.forChangedUserConnection(PersistenceEventType.USER_DISCONNECTED, clientId, clientTreeState.getUserId()));
        }
    }

    public void joinChannel(GUID channelId, GUID targetMessageId, String clientId, GUID userId, boolean focused, ChannelListener channelListener) {
        Object object;
        CoWorkChannel coWorkChannel = this.getChannel(channelId);
        if (coWorkChannel == null || !coWorkChannel.isAvailable()) {
            throw new ClientMessageException(CoWorkI18n.MSG_SERVER.getMsg("error.channel.notavailable", new Object[0]));
        }
        ClientInChannelState clientInChannelState = new ClientInChannelState(clientId, channelId, userId, channelListener);
        ClientInChannelState clientInChannelState2 = this.u.put(clientId, clientInChannelState);
        this.setClientFocused(clientId, focused);
        if (clientInChannelState2 != null) {
            this.c(clientInChannelState2.getChannelId());
            object = this.getChannelLastBlurred(userId, clientInChannelState2.getChannelId());
            if (object == null || clientInChannelState2.isFocused()) {
                this.a(clientId, clientInChannelState2.getUserId(), clientInChannelState2.getChannelId());
            }
        }
        if (targetMessageId == null) {
            object = this.q.C(clientInChannelState.getUserId());
            if (object == null) {
                object = new UserMetaData();
            }
            targetMessageId = ((UserMetaData)object).getChannelTargetMessageID(channelId);
        }
        this.a(targetMessageId, clientInChannelState, false, targetMessageId);
        channelListener.onMembersChanged(channelId);
        this.c(channelId);
        this.b((CoWorkChannelListener coWorkChannelListener) -> coWorkChannelListener.channelJoined(clientInChannelState));
        Persistence.getInstance().sendEvent((Object)PersistenceEvent.forChangedClientInChannelState(PersistenceEventType.CHANGED_CLIENTINCHANNELSTATE, channelId, clientInChannelState));
    }

    private void a(String string, GUID gUID, GUID gUID2) {
        Long l2;
        Long l3;
        UserMetaData userMetaData = this.q.C(gUID);
        if (userMetaData == null) {
            userMetaData = new UserMetaData();
        }
        if ((l3 = (l2 = userMetaData.getChannelLastSeen().get(gUID2))) == null) {
            l3 = System.currentTimeMillis();
        }
        this.updateChannelLastBlurred(gUID, gUID2, l3);
    }

    public Set<ClientInChannelState> getClientsOfUser(@Nonnull GUID userId) {
        return this.u.values().stream().filter(clientInChannelState -> clientInChannelState.getUserId().equals((Object)userId)).collect(Collectors.toSet());
    }

    public ClientInChannelState getClientInChannelState(String clientId) {
        return this.u.get(clientId);
    }

    public void setClientTargetMessage(GUID messageId, String clientId) {
        ClientInChannelState clientInChannelState = this.u.get(clientId);
        this.a(messageId, clientInChannelState, true, null);
    }

    private void a(GUID gUID, ClientInChannelState clientInChannelState, boolean bl, GUID gUID2) {
        if (clientInChannelState != null) {
            List<GUID> list;
            GUID gUID3;
            GUID gUID4;
            UserMetaData userMetaData = this.q.C(clientInChannelState.getUserId());
            if (userMetaData == null) {
                userMetaData = new UserMetaData();
            }
            if (!Objects.equals(gUID, gUID4 = clientInChannelState.getTargetMessageId())) {
                clientInChannelState.setTargetMessageId(gUID);
                if (bl) {
                    this.a(clientInChannelState, gUID == null, gUID2);
                }
            }
            if (!bl) {
                this.a(clientInChannelState, gUID == null, gUID2);
            }
            Long l2 = userMetaData.getChannelLastSeen().get(clientInChannelState.getChannelId());
            CoWorkMessage coWorkMessage = null;
            List<GUID> list2 = this.m.a(clientInChannelState.getChannelId(), gUID, 0, 1);
            if (!list2.isEmpty()) {
                coWorkMessage = this.m.getMessage(clientInChannelState.getChannelId(), list2.get(0));
            }
            if (coWorkMessage == null) {
                this.a(clientInChannelState, userMetaData, null);
                return;
            }
            if (l2 == null || coWorkMessage.getCreated() > l2) {
                userMetaData.putChannelLastSeen(clientInChannelState.getChannelId(), coWorkMessage.getCreated());
                this.q.a(clientInChannelState.getUserId(), userMetaData);
                Persistence.getInstance().sendEvent((Object)PersistenceEvent.forChangedUserMetaData(PersistenceEventType.USER_METADATA, clientInChannelState.getUserId()));
            }
            if ((gUID3 = (list = this.m.a(clientInChannelState.getChannelId(), null, 0, 1)).get(0)).equals((Object)coWorkMessage.getId())) {
                this.a(clientInChannelState, userMetaData, null);
                if (clientInChannelState.isFocused()) {
                    for (ClientInChannelState clientInChannelState2 : this.u.values()) {
                        if (!clientInChannelState2.getUserId().equals((Object)clientInChannelState.getUserId())) continue;
                        try (ClientInChannelStateScope clientInChannelStateScope = new ClientInChannelStateScope(clientInChannelState2);){
                            clientInChannelState2.getChannelListener().channelSetUnread(clientInChannelState.getChannelId(), false, 0);
                        }
                    }
                    Persistence.getInstance().sendEvent((Object)PersistenceEvent.forChannelReadForUserId(PersistenceEventType.USER_SET_CHANNEL_READ, clientInChannelState.getUserId(), clientInChannelState.getChannelId()));
                }
            } else {
                this.a(clientInChannelState, userMetaData, coWorkMessage.getId());
            }
        }
    }

    private void a(ClientInChannelState clientInChannelState, UserMetaData userMetaData, GUID gUID) {
        GUID gUID2 = userMetaData.getChannelTargetMessageID(clientInChannelState.getChannelId());
        if (!Objects.equals(gUID2, gUID)) {
            userMetaData.saveChannelTargetMessage(clientInChannelState.getChannelId(), gUID);
            this.q.a(clientInChannelState.getUserId(), userMetaData);
            Persistence.getInstance().sendEvent((Object)PersistenceEvent.forChangedUserMetaData(PersistenceEventType.USER_METADATA, clientInChannelState.getUserId()));
        }
    }

    private void a(ClientInChannelState clientInChannelState, boolean bl, GUID gUID3) {
        GUID gUID4 = clientInChannelState.getTargetMessageId();
        GUID gUID5 = clientInChannelState.getChannelId();
        List<GUID> list = this.m.a(gUID5, gUID4, -100, 102);
        if (!list.isEmpty()) {
            Set<GUID> set;
            boolean bl2;
            boolean bl3;
            List<GUID> list2 = clientInChannelState.getVisibleMessageIds();
            clientInChannelState.setVisibleMessageIds(list);
            if (gUID4 == null) {
                bl3 = true;
                boolean bl4 = bl2 = list.size() < 100;
                if (!bl2) {
                    list.remove(0);
                }
            } else {
                int n2 = list.indexOf(gUID4);
                bl3 = list.size() - n2 != 102;
                boolean bl5 = bl2 = n2 < 100;
                if (!bl2) {
                    list.remove(0);
                }
                if (!bl3) {
                    list.remove(list.size() - 1);
                }
            }
            if (!bl && list2 != null && list2.equals(list) && (set = clientInChannelState.getKnownMessages()) != null && set.containsAll(list)) {
                return;
            }
            if (gUID3 != null && !list.contains(gUID3)) {
                gUID3 = null;
                bl = true;
            }
            Set<CoWorkMessage> set2 = list.stream().filter(gUID -> list2 == null || !list2.contains(gUID) || !clientInChannelState.getKnownMessages().contains(gUID)).map(gUID2 -> this.getMessage(gUID5, (GUID)gUID2)).collect(Collectors.toSet());
            set2.forEach(coWorkMessage -> {
                if (coWorkMessage != null) {
                    clientInChannelState.getKnownMessages().add(coWorkMessage.getId());
                }
            });
            try (ClientInChannelStateScope clientInChannelStateScope = new ClientInChannelStateScope(clientInChannelState);){
                clientInChannelState.getChannelListener().onMessageListChanged(clientInChannelState.getChannelId(), list, set2, gUID3, bl2, bl3, bl);
            }
        }
        try (ClientInChannelStateScope clientInChannelStateScope = new ClientInChannelStateScope(clientInChannelState);){
            clientInChannelState.getChannelListener().onMessageListChanged(clientInChannelState.getChannelId(), Collections.emptyList(), Collections.emptySet(), null, true, true, true);
        }
    }

    public List<CoWorkMessage> getMessagesInChannel(GUID channelId, GUID targetMessageId) {
        List<GUID> list = this.m.a(channelId, targetMessageId, -99, 101);
        if (!list.isEmpty()) {
            return list.stream().map(gUID2 -> this.getMessage(channelId, (GUID)gUID2)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public void leaveChannel(String clientId) {
        ClientInChannelState clientInChannelState = this.u.remove(clientId);
        if (clientInChannelState != null) {
            this.c(clientInChannelState.getChannelId());
            Long l2 = this.getChannelLastBlurred(clientInChannelState.getUserId(), clientInChannelState.getChannelId());
            if (l2 == null || clientInChannelState.isFocused()) {
                this.a(clientId, clientInChannelState.getUserId(), clientInChannelState.getChannelId());
            }
            this.b((CoWorkChannelListener coWorkChannelListener) -> coWorkChannelListener.channelLeft(clientInChannelState));
            this.c(clientInChannelState.getChannelId());
            Persistence.getInstance().sendEvent((Object)PersistenceEvent.forChangedClientInChannelState(PersistenceEventType.DELETE_CLIENTINCHANNELSTATE, clientInChannelState.getChannelId(), clientInChannelState));
        }
    }

    public void saveUserStatus(UserStatus status) {
        UserStatus userStatus = CoWorkManager.getInstance().getUserStatus(status.getId());
        if (userStatus != null) {
            status.getFlags().addAll(userStatus.getFlags());
        }
        this.n.saveUserStatus(status);
        this.b(status.getId());
        this.a(status.getId());
        Persistence.getInstance().sendEvent((Object)PersistenceEvent.forChangedUserState(PersistenceEventType.SAVE_USERSTATUS, status.getId()));
    }

    private void a(GUID gUID) {
        Set<String> set;
        UserStatus userStatus = this.getUserStatus(gUID);
        if (userStatus == null) {
            userStatus = new UserStatus(gUID, OnlineStatus.online, null, null);
        }
        UserStatus userStatus2 = new UserStatus(gUID, userStatus.getStatus(), userStatus.getCustomStatus(), userStatus.getFlags());
        if (userStatus.isIdle()) {
            userStatus2.setIdle(true);
            if (userStatus2.getStatus() == OnlineStatus.online) {
                userStatus2.setStatus(OnlineStatus.away);
            }
        }
        if ((set = this.s.get(gUID)) != null) {
            set.forEach(string -> WebSocketEventHandler.getInstance().sendEvent(string, () -> new WebSocketEventData("cowork.currentuserstatus", (Object)userStatus2)));
        }
    }

    private void b(GUID gUID) {
        for (ClientInChannelState clientInChannelState : this.u.values()) {
            GUID gUID2 = clientInChannelState.getChannelId();
            if (!this.isMemberOfChannel(gUID2, gUID)) continue;
            try (ClientInChannelStateScope clientInChannelStateScope = new ClientInChannelStateScope(clientInChannelState);){
                clientInChannelState.getChannelListener().onMembersChanged(gUID2);
            }
        }
    }

    public void sendMembersChangedInChannel(GUID channelId) {
        for (ClientInChannelState clientInChannelState : this.u.values()) {
            if (!channelId.equals((Object)clientInChannelState.getChannelId())) continue;
            try (ClientInChannelStateScope clientInChannelStateScope = new ClientInChannelStateScope(clientInChannelState);){
                clientInChannelState.getChannelListener().onMembersChanged(channelId);
            }
        }
    }

    public boolean isMemberOfChannel(GUID channelId, GUID userId) {
        CoWorkChannel coWorkChannel = this.getChannel(channelId);
        if (coWorkChannel != null) {
            Object object;
            Set<GUID> set = coWorkChannel.getMemberGroupIds();
            Set<GUID> set2 = coWorkChannel.getMemberUserIds();
            if (coWorkChannel.isMembersInherited() && (object = this.getTeam(coWorkChannel.getTeamId(), userId)) != null) {
                set = ((CoWorkTeam)object).getMemberGroupIds();
                set2 = ((CoWorkTeam)object).getMemberUserIds();
            }
            if (set2.contains(userId)) {
                return true;
            }
            object = UserGroupManager.getInstance().getGroupsForUser(userId, false, true);
            Set set3 = object.stream().map(UserGroupInfo::getID).collect(Collectors.toSet());
            set.retainAll(set3);
            if (!set.isEmpty()) {
                return true;
            }
        }
        return false;
    }

    public UserStatus getUserStatus(@Nonnull GUID userId) {
        return this.n.getUserStatus(userId);
    }

    public void updateMessage(GUID channelId, GUID messageId, String text) {
        CoWorkMessage coWorkMessage = this.m.getMessage(channelId, messageId);
        if (coWorkMessage != null) {
            CoWorkMessage coWorkMessage2 = new CoWorkMessage(messageId, coWorkMessage.getUserId(), coWorkMessage.getParentId(), text, coWorkMessage.getCreated(), coWorkMessage.getAttachmentsIds(), coWorkMessage.getReactions());
            this.a((CoWorkMessageListener coWorkMessageListener) -> coWorkMessageListener.beforeMessageChanged(channelId, coWorkMessage2, coWorkMessage));
            this.m.updateMessage(channelId, coWorkMessage2);
            this.v.messageChanged(channelId, coWorkMessage2, coWorkMessage);
            this.b(channelId, messageId);
            this.a((CoWorkMessageListener coWorkMessageListener) -> coWorkMessageListener.messageChanged(channelId, coWorkMessage2, coWorkMessage));
            Persistence.getInstance().sendEvent((Object)PersistenceEvent.forChangedMessage(PersistenceEventType.UPDATE_MSG, channelId, coWorkMessage.getUserId(), coWorkMessage.getId()));
        }
    }

    public void updateMessage(GUID channelId, CoWorkMessage message) {
        CoWorkMessage coWorkMessage;
        if (message != null && (coWorkMessage = this.m.getMessage(channelId, message.getId())) != null) {
            this.a((CoWorkMessageListener coWorkMessageListener) -> coWorkMessageListener.beforeMessageChanged(channelId, message, coWorkMessage));
            this.m.updateMessage(channelId, message);
            this.v.messageChanged(channelId, message, coWorkMessage);
            this.b(channelId, message.getId());
            this.a((CoWorkMessageListener coWorkMessageListener) -> coWorkMessageListener.messageChanged(channelId, message, coWorkMessage));
            Persistence.getInstance().sendEvent((Object)PersistenceEvent.forChangedMessage(PersistenceEventType.UPDATE_MSG, channelId, message.getUserId(), message.getId()));
        }
    }

    public void deleteMessage(GUID channelId, GUID messageId) {
        CoWorkMessage coWorkMessage = this.m.getMessage(channelId, messageId);
        if (coWorkMessage != null) {
            this.a((CoWorkMessageListener coWorkMessageListener) -> coWorkMessageListener.beforeMessageDeleted(channelId, coWorkMessage));
            this.v.beforeMessageDeleted(channelId, coWorkMessage);
            List<GUID> list = coWorkMessage.getAttachmentsIds();
            if (list != null) {
                list.forEach(gUID2 -> this.o.f(channelId, (GUID)gUID2));
            }
            this.m.deleteMessage(channelId, messageId);
            this.b(channelId, messageId);
            this.a((CoWorkMessageListener coWorkMessageListener) -> coWorkMessageListener.messageDeleted(channelId, coWorkMessage));
            Persistence.getInstance().sendEvent((Object)PersistenceEvent.forChangedMessage(PersistenceEventType.DELETE_MSG, channelId, coWorkMessage.getUserId(), messageId));
        }
    }

    public void deleteAttachment(GUID channelId, GUID messageId, GUID attachmentId) {
        ArrayList<GUID> arrayList;
        List<GUID> list;
        CoWorkMessage coWorkMessage = this.m.getMessage(channelId, messageId);
        if (coWorkMessage != null && (list = coWorkMessage.getAttachmentsIds()) != null && (arrayList = new ArrayList<GUID>(list)).remove(attachmentId)) {
            if (arrayList.isEmpty() && StringFunctions.isEmpty((String)coWorkMessage.getText())) {
                this.a((CoWorkMessageListener coWorkMessageListener) -> coWorkMessageListener.beforeMessageDeleted(channelId, coWorkMessage));
                this.v.beforeMessageDeleted(channelId, coWorkMessage);
                this.o.f(channelId, attachmentId);
                this.m.deleteMessage(channelId, messageId);
                this.b(channelId, messageId);
                this.a((CoWorkMessageListener coWorkMessageListener) -> coWorkMessageListener.messageDeleted(channelId, coWorkMessage));
                Persistence.getInstance().sendEvent((Object)PersistenceEvent.forChangedMessage(PersistenceEventType.DELETE_MSG, channelId, coWorkMessage.getUserId(), messageId));
            } else {
                CoWorkMessage coWorkMessage2 = new CoWorkMessage(coWorkMessage.getId(), coWorkMessage.getUserId(), coWorkMessage.getParentId(), coWorkMessage.getText(), coWorkMessage.getCreated(), arrayList, coWorkMessage.getReactions());
                this.a((CoWorkMessageListener coWorkMessageListener) -> coWorkMessageListener.beforeMessageChanged(channelId, coWorkMessage2, coWorkMessage));
                this.o.f(channelId, attachmentId);
                this.m.updateMessage(channelId, coWorkMessage2);
                this.v.messageChanged(channelId, coWorkMessage2, coWorkMessage);
                this.b(channelId, coWorkMessage2.getId());
                this.a((CoWorkMessageListener coWorkMessageListener) -> coWorkMessageListener.messageChanged(channelId, coWorkMessage2, coWorkMessage));
                Persistence.getInstance().sendEvent((Object)PersistenceEvent.forChangedMessage(PersistenceEventType.UPDATE_MSG, channelId, coWorkMessage2.getUserId(), coWorkMessage2.getId()));
            }
        }
    }

    public CoWorkMessage addMessage(String clientId, GUID channelId, GUID userId, @Nullable GUID parentId, String text, List<GUID> attachmentIds) {
        ClientInChannelState clientInChannelState;
        if (StringFunctions.isEmpty((String)text) && (attachmentIds == null || attachmentIds.isEmpty())) {
            throw new ClientMessageException(CoWorkI18n.MSG_SERVER.getMsg("error.message.nocontent", new Object[0]));
        }
        CoWorkMessage coWorkMessage = new CoWorkMessage(userId, text);
        if (attachmentIds != null && !attachmentIds.isEmpty()) {
            coWorkMessage.setAttachmentsIds(attachmentIds);
        }
        coWorkMessage.setParentId(parentId);
        this.a((CoWorkMessageListener coWorkMessageListener) -> coWorkMessageListener.beforeMessageAdded(channelId, coWorkMessage));
        this.m.b(channelId, coWorkMessage);
        this.v.messageAdded(channelId, coWorkMessage);
        if (clientId != null && (clientInChannelState = this.u.get(clientId)) != null) {
            clientInChannelState.setTargetMessageId(null);
        }
        this.a(channelId, userId, clientId);
        this.a(channelId, coWorkMessage);
        this.a((CoWorkMessageListener coWorkMessageListener) -> coWorkMessageListener.messageAdded(channelId, coWorkMessage));
        Persistence.getInstance().sendEvent((Object)PersistenceEvent.forChangedMessage(PersistenceEventType.ADD_MSG, channelId, userId, coWorkMessage.getId()));
        CoWorkAttachmentUtils.createLinkPreviews(clientId, channelId, coWorkMessage);
        return coWorkMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean toggleReaction(GUID channelId, GUID messageId, GUID userId, String reactionShortName) {
        boolean bl = false;
        GUID gUID = messageId;
        synchronized (gUID) {
            CoWorkMessage coWorkMessage = this.getMessage(channelId, messageId);
            if (coWorkMessage != null) {
                bl = coWorkMessage.toggleReaction(reactionShortName, userId);
                this.m.updateMessage(channelId, coWorkMessage);
                this.b(channelId, messageId);
                Persistence.getInstance().sendEvent((Object)PersistenceEvent.forChangedMessage(PersistenceEventType.UPDATE_MSG, channelId, coWorkMessage.getUserId(), coWorkMessage.getId()));
                if (bl) {
                    this.a(userId, reactionShortName, channelId, coWorkMessage);
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(Consumer<CoWorkMessageListener> consumer) {
        List list = this.w;
        if (list == null) {
            this.w = list = DynamicExtensionManager.getInstance().get(CoWorkMessageListener.class);
        }
        CoWorkManager coWorkManager = this;
        synchronized (coWorkManager) {
            list.forEach(coWorkMessageListener -> consumer.accept((CoWorkMessageListener)coWorkMessageListener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void b(Consumer<CoWorkChannelListener> consumer) {
        List list = this.x;
        if (list == null) {
            this.x = list = DynamicExtensionManager.getInstance().get(CoWorkChannelListener.class);
        }
        CoWorkManager coWorkManager = this;
        synchronized (coWorkManager) {
            list.forEach(coWorkChannelListener -> consumer.accept((CoWorkChannelListener)coWorkChannelListener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void c(Consumer<CoWorkConnectedListener> consumer) {
        List list = this.y;
        if (list == null) {
            this.y = list = DynamicExtensionManager.getInstance().get(CoWorkConnectedListener.class);
        }
        CoWorkManager coWorkManager = this;
        synchronized (coWorkManager) {
            list.forEach(coWorkConnectedListener -> consumer.accept((CoWorkConnectedListener)coWorkConnectedListener));
        }
    }

    private void a(@Nullable GUID gUID, @Nonnull String string, @Nonnull GUID gUID2, @Nonnull CoWorkMessage coWorkMessage) {
        String string2;
        PluginServlet pluginServlet;
        if (coWorkMessage.getUserId() == null || Objects.equals(coWorkMessage.getUserId(), gUID)) {
            return;
        }
        UserStatus userStatus = this.getUserStatus(coWorkMessage.getUserId());
        if (userStatus != null && userStatus.getStatus().equals((Object)OnlineStatus.dnd)) {
            return;
        }
        boolean bl = false;
        HttpServletRequest httpServletRequest = SessionStore.getHttpServletRequest();
        if (httpServletRequest != null && (pluginServlet = PluginDispatcherServlet.getRootServlet((HttpServletRequest)httpServletRequest)) != null) {
            string2 = pluginServlet.getPathSpec();
            bl = "/cowork".equals(string2);
        }
        pluginServlet = UserAccountScope.create((GUID)coWorkMessage.getUserId());
        try {
            UserAccount userAccount;
            string2 = null;
            if (gUID != null) {
                userAccount = UserManager.getInstance().getUserAccount(gUID);
                if (userAccount != null) {
                    string2 = userAccount.getDisplayName();
                }
            } else {
                string2 = CoWorkI18n.MSG_CLIENT.getMsg("cowork.username.bot", new Object[0]);
            }
            userAccount = new Notification(CoWorkI18n.MSG_SERVER.getMsg("cowork.reaction.notification.title", new Object[]{string2}), CoWorkI18n.MSG_SERVER.getMsg("cowork.reaction.notification.message", new Object[]{string2, EmojiData.getCharacterForShortName((String)string)}));
            userAccount.setId(coWorkMessage.getId());
            String string3 = "channel/" + gUID2.toString() + "/message/" + String.valueOf(coWorkMessage.getId());
            if (!bl) {
                string3 = "cowork/" + string3;
            }
            userAccount.setTargetUrl(string3);
            userAccount.setGroupingKey("cowork.reactions");
            userAccount.setCritical(true);
            NotificationManager.getInstance().sendNotification(coWorkMessage.getUserId(), (Notification)userAccount);
        }
        finally {
            if (pluginServlet != null) {
                pluginServlet.close();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void a(GUID gUID, CoWorkMessage coWorkMessage) {
        Object object;
        Set<GUID> set;
        Object object2;
        Object object3;
        CoWorkChannel coWorkChannel = this.getChannel(gUID);
        if (coWorkChannel == null) {
            return;
        }
        boolean bl = false;
        HttpServletRequest httpServletRequest = SessionStore.getHttpServletRequest();
        if (httpServletRequest != null && (object3 = PluginDispatcherServlet.getRootServlet((HttpServletRequest)httpServletRequest)) != null) {
            object2 = object3.getPathSpec();
            bl = "/cowork".equals(object2);
        }
        object3 = coWorkMessage.getText();
        object2 = coWorkMessage.getUserId();
        Set<Object> set2 = new HashSet<Object>();
        GUID gUID2 = coWorkMessage.getParentId();
        if (gUID2 != null && (set = this.getMessage(gUID, gUID2)) != null && (object = ((CoWorkMessage)((Object)set)).getUserId()) != null && !object.equals((Object)coWorkMessage.getUserId())) {
            set2.add(object);
        }
        if (!StringFunctions.isEmpty((String)object3)) {
            Object object4;
            Object object6;
            Set<ClientInChannelState> set322;
            set = null;
            if (coWorkChannel.getTeamId().equals((Object)DIRECTMESSAGE_TEAM_ID)) {
                set = coWorkChannel.getAllMemberIds();
                set.remove(object2);
                set2.addAll(set);
            } else {
                object = null;
                try {
                    object = c.g((String)object3);
                }
                catch (Throwable throwable) {
                    LOGGER.error((Object)("Error formatting message for sending notifications: '" + (String)object3 + "'"));
                    LOGGER.error(throwable);
                }
                if (object != null && !object.isEmpty()) {
                    MemberStatusGroup memberStatusGroup;
                    if (object.containsKey("@channel:all")) {
                        set = coWorkChannel.getAllMemberIds();
                        set2 = set;
                    } else if (object.containsKey("@channel:online")) {
                        Object object7 = this.getUsersInChannel(gUID);
                        set322 = object7.iterator();
                        while (set322.hasNext()) {
                            memberStatusGroup = (MemberStatusGroup)set322.next();
                            if (!"online".equals(memberStatusGroup.getKey())) continue;
                            object6 = memberStatusGroup.getMembers();
                            Iterator<MemberStatus> object52 = object6.iterator();
                            while (object52.hasNext()) {
                                object4 = object52.next();
                                set2.add(((MemberStatus)object4).getId());
                            }
                        }
                    }
                    for (Set<ClientInChannelState> set322 : object.keySet()) {
                        if (((String)((Object)set322)).startsWith("@user:")) {
                            memberStatusGroup = GUID.valueOf((String)((String)((Object)set322)).substring(6));
                            if (set == null) {
                                set = coWorkChannel.getAllMemberIds();
                            }
                            if (set.contains(memberStatusGroup)) {
                                set2.add(memberStatusGroup);
                            }
                        }
                        if (!((String)((Object)set322)).startsWith("@group:") || (memberStatusGroup = UserGroupManager.getInstance().getGroup(GUID.valueOf((String)((String)((Object)set322)).substring(7)))) == null) continue;
                        if (set == null) {
                            set = coWorkChannel.getAllMemberIds();
                        }
                        object6 = new HashSet(memberStatusGroup.getMemberIDs());
                        object6.retainAll(set);
                        set2.addAll((Collection<Object>)object6);
                    }
                }
            }
            if (!set2.isEmpty()) {
                for (Object object7 : set2) {
                    if (object7.equals(object2)) continue;
                    set322 = this.getClientsOfUser((GUID)object7);
                    if (set322 != null && !set322.isEmpty()) {
                        boolean bl2 = false;
                        for (ClientInChannelState clientInChannelState : set322) {
                            if (!gUID.equals((Object)clientInChannelState.getChannelId()) || !clientInChannelState.isFocused() || clientInChannelState.isIdle()) continue;
                            bl2 = true;
                            break;
                        }
                        if (bl2) continue;
                    }
                    try (UserAccountScope userAccountScope = UserAccountScope.create((GUID)object7);){
                        void var16_27;
                        object6 = coWorkChannel.getDisplayName();
                        Object var16_23 = null;
                        if (object2 != null) {
                            object4 = UserManager.getInstance().getUserAccount(object2);
                            if (object4 != null) {
                                String string = object4.getDisplayName();
                            }
                        } else {
                            String string = CoWorkI18n.MSG_CLIENT.getMsg("cowork.username.bot", new Object[0]);
                        }
                        if (coWorkChannel.getTeamId().equals((Object)DIRECTMESSAGE_TEAM_ID)) {
                            if (var16_27 != null && !var16_27.trim().isEmpty() && !var16_27.equals(object6)) {
                                object6 = (String)var16_27 + " (" + (String)object6 + ")";
                            }
                        } else if (!StringFunctions.isEmpty((String)var16_27)) {
                            object6 = (String)var16_27 + " (" + object6 + ")";
                        }
                        object4 = new Notification(object6, coWorkMessage.getPlainText());
                        object4.setId(coWorkMessage.getId());
                        String string = "channel/" + gUID.toString() + "/message/" + String.valueOf(coWorkMessage.getId());
                        if (!bl) {
                            string = "cowork/" + string;
                        }
                        object4.setTargetUrl(string);
                        object4.setGroupingKey("cowork.mentions");
                        object4.setCritical(true);
                        UserStatus userStatus = this.getUserStatus((GUID)object7);
                        if (userStatus != null && userStatus.getStatus().equals((Object)OnlineStatus.dnd)) continue;
                        NotificationManager.getInstance().sendNotification((GUID)object7, (Notification)object4);
                    }
                }
            }
        }
    }

    public CoWorkMessage getMessage(@Nonnull GUID channelId, @Nonnull GUID messageId) {
        return this.m.getMessage(channelId, messageId);
    }

    public CoWorkMessage getMessage(@Nonnull GUID channelId, @Nonnull GUID messageId, boolean putToCache) {
        return this.m.getMessage(channelId, messageId, putToCache);
    }

    public void saveTeam(CoWorkTeam team) {
        if (team.isPredefined()) {
            return;
        }
        CoWorkTeam coWorkTeam = this.k.getTeam(team.getId());
        if (coWorkTeam != null && coWorkTeam.equals(team)) {
            return;
        }
        team.setLastModified(System.currentTimeMillis());
        this.k.saveTeam(team);
        this.d(team.getId());
        Persistence.getInstance().sendEvent((Object)PersistenceEvent.forChangedTeam(PersistenceEventType.SAVE_TEAM, team.getId()));
    }

    public void deleteTeam(GUID teamId) {
        if (this.f().containsKey(teamId)) {
            return;
        }
        List<CoWorkChannel> list = this.getAllChannelsInTeam(teamId);
        if (list != null) {
            for (CoWorkChannel coWorkChannel : list) {
                this.deleteChannel(teamId, coWorkChannel.getId());
            }
        }
        this.k.deleteTeam(teamId);
        this.g();
        Persistence.getInstance().sendEvent((Object)PersistenceEvent.forChangedTeam(PersistenceEventType.DELETE_TEAM, teamId));
    }

    public void saveChannel(CoWorkChannel channel) {
        CoWorkChannel coWorkChannel = this.l.getChannel(channel.getId());
        if (coWorkChannel != null && coWorkChannel.equals(channel)) {
            return;
        }
        channel.setLastModified(System.currentTimeMillis());
        this.l.saveChannel(channel);
        this.b((CoWorkChannelListener coWorkChannelListener) -> coWorkChannelListener.channelCreatedOrUpdated(channel));
        this.e(channel.getId());
        Persistence.getInstance().sendEvent((Object)PersistenceEvent.forChangedChannel(PersistenceEventType.SAVE_CHANNEL, channel.getId()));
    }

    public void deleteChannel(GUID teamId, GUID channelId) {
        try {
            this.b((CoWorkChannelListener coWorkChannelListener) -> coWorkChannelListener.channelBeforeRemove(channelId));
            this.o.x(channelId);
            this.m.z(channelId);
            this.l.deleteChannel(teamId, channelId);
            this.b((CoWorkChannelListener coWorkChannelListener) -> coWorkChannelListener.channelRemoved(channelId));
        }
        finally {
            this.h();
            Persistence.getInstance().sendEvent((Object)PersistenceEvent.forChangedChannel(PersistenceEventType.DELETE_CHANNEL, channelId));
        }
        com.inet.cowork.server.search.e.v().K(channelId);
    }

    public CoWorkChannel getDirectMessageChannel(GUID userId, boolean createIfNotExisting) {
        CoWorkChannel coWorkChannel2;
        GUID gUID = UserManager.getInstance().getCurrentUserAccountID();
        if (gUID == null) {
            throw new AccessDeniedException();
        }
        List<CoWorkChannel> list = this.getChannels(DIRECTMESSAGE_TEAM_ID);
        for (CoWorkChannel coWorkChannel2 : list) {
            Set<GUID> set = coWorkChannel2.getMemberUserIds();
            if (set.size() != 2 || !set.contains(gUID) || !set.contains(userId)) continue;
            return coWorkChannel2;
        }
        if (!createIfNotExisting) {
            return null;
        }
        HashSet hashSet = new HashSet();
        hashSet.add(gUID);
        hashSet.add(userId);
        coWorkChannel2 = CoWorkChannel.create(GUID.generateNew(), DIRECTMESSAGE_TEAM_ID, null, null, hashSet, null);
        this.saveChannel(coWorkChannel2);
        return coWorkChannel2;
    }

    public void leaveDirectMessageChannel(GUID channelId, GUID userId) {
        CoWorkChannel coWorkChannel = this.getChannel(channelId);
        if (coWorkChannel != null && DIRECTMESSAGE_TEAM_ID.equals((Object)coWorkChannel.getTeamId())) {
            Set<GUID> set = coWorkChannel.getMemberUserIds();
            set.remove(userId);
            coWorkChannel.setMemberUserIds(set);
            if (set.isEmpty() || !this.hasMessagesInChannel(channelId)) {
                this.deleteChannel(DIRECTMESSAGE_TEAM_ID, channelId);
            } else {
                this.saveChannel(coWorkChannel);
            }
        }
    }

    public void saveAttachment(GUID channelId, CoWorkAttachment attachment, InputStream inputStream) {
        this.o.saveAttachment(channelId, attachment, inputStream);
        try {
            CoWorkAttachmentUtils.updateMetaDataForPreview(channelId, attachment);
        }
        catch (IOException iOException) {
            LOGGER.error((Throwable)iOException);
        }
    }

    public void updateAttachmentMetaData(GUID channelId, CoWorkAttachment attachment) {
        this.o.updateAttachmentMetaData(channelId, attachment);
    }

    public void saveAttachmentPreview(GUID channelId, CoWorkAttachment attachment, InputStream inputStream) {
        this.o.saveAttachmentPreview(channelId, attachment, inputStream);
    }

    public CoWorkAttachment getAttachmentMetaData(GUID channelId, GUID attachmentId) {
        return this.o.getAttachmentMetaData(channelId, attachmentId);
    }

    public InputStream getAttachmentStream(GUID channelId, GUID attachmentId, boolean preview) {
        return this.o.getAttachmentStream(channelId, attachmentId, preview);
    }

    public UISettings getUISettings(GUID userId) {
        return this.p.getUISettings(userId);
    }

    public void saveUISettings(GUID userId, UISettings settings) {
        this.p.saveUISettings(userId, settings);
    }

    public boolean hasUnreadMessageInChannel(GUID channelId, GUID userId) {
        Object object;
        List<GUID> list = this.m.a(channelId, null, 0, 1);
        if (list.isEmpty()) {
            return false;
        }
        long l2 = 0L;
        GUID gUID = list.get(0);
        if (gUID != null) {
            object = this.getMessage(channelId, gUID);
            if (object == null) {
                return false;
            }
        } else {
            return false;
        }
        l2 = ((CoWorkMessage)object).getCreated();
        object = this.q.C(userId);
        long l3 = 0L;
        long l4 = 0L;
        if (object != null) {
            Long l5;
            Map<GUID, Long> map;
            Long l6 = ((UserMetaData)object).getChannelLastBlurred().get(channelId);
            if (l6 != null) {
                l4 = l6;
            }
            if ((map = ((UserMetaData)object).getChannelLastSeen()) != null && (l5 = map.get(channelId)) != null) {
                l3 = l5;
            }
        }
        return l2 > l3 || l4 > 0L && l2 > l4;
    }

    public int getUnreadMentionsInChannel(GUID channelId, GUID userId) {
        Object object;
        UserMetaData userMetaData = this.q.C(userId);
        long l2 = 0L;
        long l3 = 0L;
        if (userMetaData != null) {
            Long l4;
            Map<GUID, Long> map;
            object = userMetaData.getChannelLastBlurred().get(channelId);
            if (object != null) {
                l3 = (Long)object;
            }
            if ((map = userMetaData.getChannelLastSeen()) != null && (l4 = map.get(channelId)) != null) {
                l2 = l4;
            }
        }
        object = com.inet.cowork.server.search.e.v().a(channelId, userId, Math.max(l2, l3), 100);
        return object.size();
    }

    public boolean hasMessagesInChannel(GUID channelId) {
        List<GUID> list = this.m.a(channelId, null, 0, 1);
        return !list.isEmpty();
    }

    public void setClientBackToVisible(String clientId) {
        ClientInChannelState clientInChannelState = this.u.get(clientId);
        if (clientInChannelState != null) {
            clientInChannelState.setLastVisible(System.currentTimeMillis());
            clientInChannelState.setIdle(false);
            Persistence.getInstance().sendEvent((Object)PersistenceEvent.forChangedClientInChannelState(PersistenceEventType.CHANGED_CLIENTINCHANNELSTATE, clientInChannelState.getChannelId(), clientInChannelState));
        }
    }

    public void setClientIdle(String clientId, boolean idle) {
        ClientInChannelState clientInChannelState = this.u.get(clientId);
        if (clientInChannelState != null) {
            clientInChannelState.setIdle(idle);
            Persistence.getInstance().sendEvent((Object)PersistenceEvent.forChangedClientInChannelState(PersistenceEventType.CHANGED_CLIENTINCHANNELSTATE, clientInChannelState.getChannelId(), clientInChannelState));
        }
    }

    public void setClientFocused(String clientId, boolean focused) {
        ClientInChannelState clientInChannelState = this.u.get(clientId);
        if (clientInChannelState != null && clientInChannelState.isFocused() != focused) {
            clientInChannelState.setFocused(focused);
            Persistence.getInstance().sendEvent((Object)PersistenceEvent.forChangedClientInChannelState(PersistenceEventType.CHANGED_CLIENTINCHANNELSTATE, clientInChannelState.getChannelId(), clientInChannelState));
            if (!focused) {
                this.a(clientId, clientInChannelState.getUserId(), clientInChannelState.getChannelId());
            } else {
                Long l2 = this.getChannelLastBlurred(clientInChannelState.getUserId(), clientInChannelState.getChannelId());
                if (l2 != null) {
                    GUID gUID = clientInChannelState.getTargetMessageId();
                    List<GUID> list = this.m.a(clientInChannelState.getChannelId(), gUID, 0, 1);
                    if (list.isEmpty()) {
                        this.updateChannelLastBlurred(clientInChannelState.getUserId(), clientInChannelState.getChannelId(), null);
                    } else {
                        CoWorkMessage coWorkMessage = this.getMessage(clientInChannelState.getChannelId(), list.get(0));
                        if (coWorkMessage != null && coWorkMessage.getCreated() <= l2) {
                            this.updateChannelLastBlurred(clientInChannelState.getUserId(), clientInChannelState.getChannelId(), null);
                        }
                    }
                }
            }
        }
    }

    public void saveDraft(String clientId, GUID userId, GUID channelId, Draft draft) {
        UserMetaData userMetaData = this.q.C(userId);
        if (userMetaData == null) {
            userMetaData = new UserMetaData();
        }
        userMetaData.saveDraft(channelId, draft);
        this.q.a(userId, userMetaData);
        this.a(userId, clientId);
        Persistence.getInstance().sendEvent((Object)PersistenceEvent.forChangedUserDrafts(PersistenceEventType.USER_DRAFTS, userId));
    }

    public Map<GUID, Draft> getDrafts(GUID userId) {
        UserMetaData userMetaData;
        UserMetaData userMetaData2 = userMetaData = userId == null ? null : this.q.C(userId);
        if (userMetaData == null) {
            userMetaData = new UserMetaData();
        }
        return userMetaData.getDrafts();
    }

    private void a(GUID gUID, String string) {
        Set<String> set = this.s.get(gUID);
        if (set != null) {
            Map<GUID, Draft> map = this.getDrafts(gUID);
            set.forEach(string2 -> {
                if (string != null && string.equals(string2)) {
                    return;
                }
                WebSocketEventHandler.getInstance().sendEvent(string2, () -> new WebSocketEventData("cowork.drafts", (Object)map));
            });
        }
    }

    public void updateChannelLastBlurred(@Nonnull GUID userId, @Nonnull GUID channelId, Long timestamp) {
        UserMetaData userMetaData = this.q.C(userId);
        if (userMetaData == null) {
            userMetaData = new UserMetaData();
        }
        userMetaData.putChannelLastBlurred(channelId, timestamp);
        this.q.a(userId, userMetaData);
        this.a(userId, channelId);
        Persistence.getInstance().sendEvent((Object)PersistenceEvent.forChangedUserMetaDataLastBlurred(PersistenceEventType.USER_METADATA_LAST_BLURRED, userId, channelId));
    }

    public Long getChannelLastBlurred(GUID userId, GUID channelId) {
        UserMetaData userMetaData = this.q.C(userId);
        if (userMetaData == null) {
            userMetaData = new UserMetaData();
        }
        return userMetaData.getChannelLastBlurred().get(channelId);
    }

    private void a(GUID gUID, GUID gUID2) {
        Long l2 = this.getChannelLastBlurred(gUID, gUID2);
        this.forEachClientInChannel(gUID2, clientInChannelState -> {
            if (clientInChannelState.getUserId().equals((Object)gUID)) {
                WebSocketEventHandler.getInstance().sendEvent(clientInChannelState.getClientId(), () -> new WebSocketEventData("cowork.channellastblurred", (Object)l2));
            }
        });
    }

    public void setClientWritingInChannel(String clientId, boolean writing) {
        ClientInChannelState clientInChannelState = this.u.get(clientId);
        if (clientInChannelState != null) {
            UserStatus userStatus;
            if (writing && (userStatus = this.getUserStatus(clientInChannelState.getUserId())) != null && (userStatus.getStatus() == OnlineStatus.offline || userStatus.getStatus() == OnlineStatus.invisible)) {
                return;
            }
            clientInChannelState.setWriting(writing);
            this.c(clientInChannelState.getChannelId());
            Persistence.getInstance().sendEvent((Object)PersistenceEvent.forChangedClientInChannelState(PersistenceEventType.CHANGED_CLIENTINCHANNELSTATE, clientInChannelState.getChannelId(), clientInChannelState));
        }
    }

    private void c(GUID gUID) {
        HashSet<GUID> hashSet = new HashSet<GUID>();
        for (ClientInChannelState clientInChannelState : this.u.values()) {
            if (!gUID.equals((Object)clientInChannelState.getChannelId()) || !clientInChannelState.isWriting()) continue;
            hashSet.add(clientInChannelState.getUserId());
        }
        for (ClientInChannelState clientInChannelState : this.u.values()) {
            if (!gUID.equals((Object)clientInChannelState.getChannelId())) continue;
            try (ClientInChannelStateScope clientInChannelStateScope = new ClientInChannelStateScope(clientInChannelState);){
                clientInChannelState.getChannelListener().onUsersWriting(new HashSet<GUID>(hashSet));
            }
        }
    }

    public void forEachClientInChannel(GUID channelId, Consumer<ClientInChannelState> consumer) {
        for (ClientInChannelState clientInChannelState : this.u.values()) {
            if (!channelId.equals((Object)clientInChannelState.getChannelId())) continue;
            try (ClientInChannelStateScope clientInChannelStateScope = new ClientInChannelStateScope(clientInChannelState);){
                consumer.accept(clientInChannelState);
            }
        }
    }

    private void a(GUID gUID, GUID gUID2, String string) {
        this.u.values().stream().filter(clientInChannelState -> clientInChannelState.getChannelId().equals((Object)gUID)).forEach(clientInChannelState -> this.a((ClientInChannelState)clientInChannelState, string != null && clientInChannelState.getClientId().equals(string), null));
        this.u.values().stream().forEach(clientInChannelState -> {
            List<GUID> list;
            Object object;
            if (clientInChannelState.getChannelId().equals((Object)gUID)) {
                object = clientInChannelState.getTargetMessageId();
                if (clientInChannelState.isFocused()) {
                    if (object == null) {
                        return;
                    }
                    list = this.m.a(gUID, null, -2, 0);
                    if (list.isEmpty()) {
                        return;
                    }
                    GUID gUID3 = (GUID)list.get(0);
                    if (gUID3.equals(object)) {
                        return;
                    }
                    if (list.size() > 1 && (gUID3 = (GUID)list.get(1)).equals(object)) {
                        return;
                    }
                }
            }
            if ((object = this.getChannel(gUID)) == null || !((CoWorkChannel)object).isAvailable(clientInChannelState.getUserId())) {
                return;
            }
            list = new ClientInChannelStateScope((ClientInChannelState)clientInChannelState);
            try {
                boolean bl = true;
                if (string != null && clientInChannelState.getClientId().equals(string)) {
                    bl = false;
                } else if (clientInChannelState.getUserId().equals((Object)gUID2) && string != null) {
                    bl = false;
                }
                int n2 = 0;
                if (bl) {
                    n2 = this.getUnreadMentionsInChannel(gUID, clientInChannelState.getUserId());
                }
                clientInChannelState.getChannelListener().channelSetUnread(gUID, bl, n2);
            }
            finally {
                ((ClientInChannelStateScope)((Object)list)).close();
            }
        });
    }

    private void b(GUID gUID, GUID gUID2) {
        this.u.values().stream().filter(clientInChannelState -> clientInChannelState.getChannelId().equals((Object)gUID)).forEach(clientInChannelState -> {
            List<GUID> list;
            Set<GUID> set = clientInChannelState.getKnownMessages();
            if (set != null) {
                set.remove(gUID2);
            }
            if ((list = clientInChannelState.getVisibleMessageIds()) != null && list.contains(gUID2)) {
                this.a((ClientInChannelState)clientInChannelState, false, null);
            }
        });
        this.u.values().stream().forEach(clientInChannelState -> {
            try (ClientInChannelStateScope clientInChannelStateScope = new ClientInChannelStateScope((ClientInChannelState)clientInChannelState);){
                boolean bl = this.hasUnreadMessageInChannel(gUID, clientInChannelState.getUserId());
                int n2 = 0;
                if (bl) {
                    n2 = this.getUnreadMentionsInChannel(gUID, clientInChannelState.getUserId());
                }
                clientInChannelState.getChannelListener().channelSetUnread(gUID, bl, n2);
            }
        });
    }

    private void d(GUID gUID) {
        this.t.forEach((string, clientTreeState) -> clientTreeState.getChannelsTreeUpdateListener().onChannelsTreeChanged());
        for (ClientInChannelState clientInChannelState : this.u.values()) {
            CoWorkChannel coWorkChannel = this.getChannel(clientInChannelState.getChannelId());
            if (coWorkChannel == null || !coWorkChannel.getTeamId().equals((Object)gUID)) continue;
            try (ClientInChannelStateScope clientInChannelStateScope = new ClientInChannelStateScope(clientInChannelState);){
                clientInChannelState.getChannelListener().onMembersChanged(clientInChannelState.getChannelId());
            }
        }
    }

    private void g() {
        this.t.forEach((string, clientTreeState) -> clientTreeState.getChannelsTreeUpdateListener().onChannelsTreeChanged());
    }

    private void e(GUID gUID) {
        this.t.forEach((string, clientTreeState) -> clientTreeState.getChannelsTreeUpdateListener().onChannelsTreeChanged());
        for (ClientInChannelState clientInChannelState : this.u.values()) {
            if (!gUID.equals((Object)clientInChannelState.getChannelId())) continue;
            try (ClientInChannelStateScope clientInChannelStateScope = new ClientInChannelStateScope(clientInChannelState);){
                clientInChannelState.getChannelListener().onMembersChanged(gUID);
            }
        }
    }

    private void h() {
        this.t.forEach((string, clientTreeState) -> clientTreeState.getChannelsTreeUpdateListener().onChannelsTreeChanged());
    }

    public void cleanUpDeletedUser(UserAccount userAccount) {
        GUID gUID = userAccount.getID();
        Set<ClientInChannelState> set = this.getClientsOfUser(gUID);
        for (ClientInChannelState object2 : set) {
            this.leaveChannel(object2.getClientId());
            this.unregisterFromChannelTreeUpdates(object2.getClientId());
            this.c(object2.getChannelId());
        }
        List<CoWorkTeam> list = this.k.u();
        list.addAll(this.f().values());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            HashSet<GUID> hashSet;
            CoWorkTeam coWorkTeam = (CoWorkTeam)iterator.next();
            boolean bl = false;
            HashSet<GUID> hashSet2 = coWorkTeam.getAdminUserIds();
            if (hashSet2.remove(gUID)) {
                coWorkTeam.setAdminUserIds(hashSet2);
                bl = true;
            }
            if ((hashSet = coWorkTeam.getMemberUserIds()).remove(gUID)) {
                coWorkTeam.setMemberUserIds(hashSet);
                bl = true;
            }
            if (bl) {
                this.saveTeam(coWorkTeam);
            }
            List<CoWorkChannel> list2 = this.l.getAllChannelsInTeam(coWorkTeam.getId());
            for (CoWorkChannel coWorkChannel : list2) {
                Set<GUID> set2 = coWorkChannel.getMemberUserIds();
                if (DIRECTMESSAGE_TEAM_ID.equals((Object)coWorkChannel.getTeamId())) {
                    if (!set2.contains(gUID)) continue;
                    this.leaveDirectMessageChannel(coWorkChannel.getId(), gUID);
                    continue;
                }
                if (!set2.remove(gUID)) continue;
                coWorkChannel.setMemberUserIds(set2);
                this.saveChannel(coWorkChannel);
            }
        }
        this.n.G(gUID);
        this.q.D(gUID);
        this.p.B(gUID);
    }

    public void cleanUpMembers() {
        this.k.t();
        this.l.r();
        List<CoWorkTeam> list = this.k.u();
        list.addAll(this.f().values());
        for (CoWorkTeam coWorkTeam : list) {
            Object object;
            Object object2;
            Object object32;
            Object object4;
            boolean bl = false;
            HashSet<GUID> hashSet = coWorkTeam.getMemberUserIds();
            for (GUID gUID : hashSet) {
                if (this.g(gUID)) continue;
                object4 = coWorkTeam.getMemberUserIds();
                ((HashSet)object4).remove(gUID);
                coWorkTeam.setMemberUserIds((HashSet<GUID>)object4);
                this.n.G(gUID);
                this.q.D(gUID);
                this.p.B(gUID);
                bl = true;
            }
            HashSet<GUID> hashSet2 = coWorkTeam.getMemberGroupIds();
            Iterator iterator = hashSet2.iterator();
            while (iterator.hasNext()) {
                object4 = (GUID)iterator.next();
                if (this.f((GUID)object4)) continue;
                object32 = coWorkTeam.getMemberGroupIds();
                ((HashSet)object32).remove(object4);
                coWorkTeam.setMemberGroupIds((HashSet<GUID>)object32);
                bl = true;
            }
            HashSet<GUID> object52 = coWorkTeam.getAdminUserIds();
            for (Object object32 : object52) {
                if (this.g((GUID)object32)) continue;
                object2 = coWorkTeam.getAdminUserIds();
                ((HashSet)object2).remove(object32);
                coWorkTeam.setAdminUserIds((HashSet<GUID>)object2);
                this.n.G((GUID)object32);
                this.q.D((GUID)object32);
                this.p.B((GUID)object32);
                bl = true;
            }
            object4 = coWorkTeam.getAdminGroupIds();
            object32 = ((HashSet)object4).iterator();
            while (object32.hasNext()) {
                object2 = (GUID)object32.next();
                if (this.f((GUID)object2)) continue;
                object = coWorkTeam.getAdminGroupIds();
                ((HashSet)object).remove(object2);
                coWorkTeam.setAdminGroupIds((HashSet<GUID>)object);
                bl = true;
            }
            if (bl) {
                this.saveTeam(coWorkTeam);
            }
            object32 = this.l.getAllChannelsInTeam(coWorkTeam.getId());
            object2 = object32.iterator();
            while (object2.hasNext()) {
                Object object5;
                object = (CoWorkChannel)object2.next();
                boolean bl2 = false;
                Set<GUID> set = ((CoWorkChannel)object).getMemberUserIds();
                for (GUID gUID : set) {
                    if (this.g(gUID)) continue;
                    if (DIRECTMESSAGE_TEAM_ID.equals((Object)((CoWorkChannel)object).getTeamId())) {
                        if (!set.contains(gUID)) continue;
                        this.leaveDirectMessageChannel(((CoWorkChannel)object).getId(), gUID);
                        this.n.G(gUID);
                        this.q.D(gUID);
                        this.p.B(gUID);
                        continue;
                    }
                    object5 = coWorkTeam.getMemberUserIds();
                    ((HashSet)object5).remove(gUID);
                    ((CoWorkChannel)object).setMemberUserIds((Set<GUID>)object5);
                    this.n.G(gUID);
                    this.q.D(gUID);
                    this.p.B(gUID);
                    bl2 = true;
                }
                Set<GUID> set2 = ((CoWorkChannel)object).getMemberGroupIds();
                Iterator iterator2 = set2.iterator();
                while (iterator2.hasNext()) {
                    object5 = (GUID)iterator2.next();
                    if (this.f((GUID)object5)) continue;
                    HashSet<GUID> hashSet3 = coWorkTeam.getMemberGroupIds();
                    hashSet3.remove(object5);
                    ((CoWorkChannel)object).setMemberGroupIds(hashSet3);
                    bl2 = true;
                }
                if (!bl2) continue;
                this.saveChannel((CoWorkChannel)object);
            }
        }
    }

    private boolean f(GUID gUID) {
        UserGroupInfo userGroupInfo = UserGroupManager.getInstance().getGroup(gUID);
        return userGroupInfo != null;
    }

    private boolean g(GUID gUID) {
        UserAccount userAccount = UserManager.getInstance().getUserAccount(gUID);
        return userAccount != null;
    }

    @Nonnull
    public Iterator<com.inet.cowork.api.model.a> getAllMessageIDs() {
        return this.m.getAllMessageIDs();
    }

    @Nonnull
    public Set<GUID> getChildMessageIds(@Nonnull GUID messageId) {
        return com.inet.cowork.server.search.e.v().J(messageId);
    }

    static {
        LOGGER = LogManager.getLogger((String)"CoWork");
    }

    private class a
    implements PersistenceListener<PersistenceEvent> {
        private a() {
        }

        public void a(@Nonnull PersistenceEvent persistenceEvent) {
            String string = persistenceEvent.clientId;
            GUID gUID2 = persistenceEvent.userId;
            GUID gUID3 = persistenceEvent.teamId;
            GUID gUID4 = persistenceEvent.channelId;
            GUID gUID5 = persistenceEvent.messageId;
            ClientInChannelState clientInChannelState = persistenceEvent.clientInChannelState;
            switch (persistenceEvent.type) {
                case ADD_MSG: {
                    CoWorkManager.this.m.getMessage(gUID4, gUID5);
                    CoWorkManager.this.a(gUID4, gUID2, null);
                    break;
                }
                case UPDATE_MSG: {
                    CoWorkManager.this.m.g(gUID4, gUID5);
                    CoWorkManager.this.b(gUID4, gUID5);
                    break;
                }
                case DELETE_MSG: {
                    CoWorkManager.this.m.g(gUID4, gUID5);
                    CoWorkManager.this.b(gUID4, gUID5);
                    break;
                }
                case SAVE_TEAM: {
                    CoWorkManager.this.k.A(gUID3);
                    CoWorkManager.this.d(gUID3);
                    break;
                }
                case DELETE_TEAM: {
                    CoWorkManager.this.k.deleteTeam(gUID3);
                    CoWorkManager.this.g();
                    break;
                }
                case SAVE_CHANNEL: {
                    CoWorkManager.this.l.y(gUID4);
                    CoWorkManager.this.e(gUID4);
                    break;
                }
                case DELETE_CHANNEL: {
                    CoWorkManager.this.l.y(gUID4);
                    CoWorkManager.this.h();
                    break;
                }
                case CHANGED_CLIENTINCHANNELSTATE: {
                    clientInChannelState.setChannelListener(new ChannelListener(){

                        @Override
                        public void onUsersWriting(Set<GUID> writingUsers) {
                        }

                        @Override
                        public void onMessageListChanged(GUID channelId, List<GUID> visibleMessageIds, Set<CoWorkMessage> changedMessages, GUID targetMessageId, boolean returnedFirstMessage, boolean returnedLastMessage, boolean scrollToEnd) {
                        }

                        @Override
                        public void onMembersChanged(GUID channelId) {
                        }

                        @Override
                        public void channelSetUnread(GUID channelId, boolean unread, int mentionCount) {
                        }
                    });
                    ClientInChannelState clientInChannelState2 = CoWorkManager.this.u.put(clientInChannelState.getClientId(), clientInChannelState);
                    if (clientInChannelState2 != null) {
                        CoWorkManager.this.c(clientInChannelState2.getChannelId());
                    }
                    CoWorkManager.this.c(clientInChannelState.getChannelId());
                    break;
                }
                case DELETE_CLIENTINCHANNELSTATE: {
                    CoWorkManager.this.u.remove(clientInChannelState.getClientId());
                    CoWorkManager.this.c(clientInChannelState.getChannelId());
                    break;
                }
                case USER_CONNECTED: {
                    CoWorkManager.this.s.compute(gUID2, (gUID, keySetView) -> {
                        if (keySetView == null) {
                            keySetView = ConcurrentHashMap.newKeySet();
                        }
                        keySetView.add(string);
                        return keySetView;
                    });
                    break;
                }
                case USER_DISCONNECTED: {
                    CoWorkManager.this.s.computeIfPresent(gUID2, (gUID, set) -> {
                        set.remove(string);
                        if (set.isEmpty()) {
                            set = null;
                        }
                        return set;
                    });
                    CoWorkManager.this.b(gUID2);
                    break;
                }
                case SAVE_USERSTATUS: {
                    CoWorkManager.this.n.F(gUID2);
                    CoWorkManager.this.b(gUID2);
                    CoWorkManager.this.a(gUID2);
                    break;
                }
                case USER_METADATA: {
                    CoWorkManager.this.q.E(gUID2);
                    break;
                }
                case USER_METADATA_LAST_BLURRED: {
                    CoWorkManager.this.q.E(gUID2);
                    CoWorkManager.this.a(gUID2, gUID4);
                    break;
                }
                case USER_DRAFTS: {
                    CoWorkManager.this.q.E(gUID2);
                    CoWorkManager.this.a(gUID2, (String)null);
                    break;
                }
                case USER_SET_CHANNEL_READ: {
                    for (ClientInChannelState clientInChannelState3 : CoWorkManager.this.u.values()) {
                        if (!clientInChannelState3.getUserId().equals((Object)gUID2)) continue;
                        try (ClientInChannelStateScope clientInChannelStateScope = new ClientInChannelStateScope(clientInChannelState3);){
                            clientInChannelState3.getChannelListener().channelSetUnread(gUID4, false, 0);
                        }
                    }
                    break;
                }
                case NEW_NODE: {
                    for (Map.Entry<GUID, Set<String>> entry : CoWorkManager.this.s.entrySet()) {
                        gUID2 = entry.getKey();
                        for (String string2 : entry.getValue()) {
                            Persistence.getInstance().sendEvent((Object)PersistenceEvent.forChangedUserConnection(PersistenceEventType.USER_CONNECTED, string2, gUID2));
                        }
                    }
                    break;
                }
            }
        }

        public /* synthetic */ void eventReceived(@Nonnull Object object) {
            this.a((PersistenceEvent)object);
        }
    }

    @JsonData
    private static enum PersistenceEventType {
        ADD_MSG,
        UPDATE_MSG,
        DELETE_MSG,
        SAVE_TEAM,
        DELETE_TEAM,
        SAVE_CHANNEL,
        DELETE_CHANNEL,
        CHANGED_CLIENTINCHANNELSTATE,
        DELETE_CLIENTINCHANNELSTATE,
        USER_SET_CHANNEL_READ,
        USER_CONNECTED,
        USER_DISCONNECTED,
        USER_METADATA,
        USER_METADATA_LAST_BLURRED,
        USER_DRAFTS,
        SAVE_USERSTATUS,
        NEW_NODE;

    }

    @JsonData
    private static class PersistenceEvent {
        private PersistenceEventType type;
        private String clientId;
        private GUID userId;
        private GUID teamId;
        private GUID channelId;
        private GUID messageId;
        private ClientInChannelState clientInChannelState;

        PersistenceEvent() {
        }

        public static PersistenceEvent forChangedUserState(PersistenceEventType type, GUID userId) {
            PersistenceEvent persistenceEvent = new PersistenceEvent();
            persistenceEvent.type = type;
            persistenceEvent.userId = userId;
            return persistenceEvent;
        }

        public static PersistenceEvent forChangedUserMetaData(PersistenceEventType type, GUID userId) {
            PersistenceEvent persistenceEvent = new PersistenceEvent();
            persistenceEvent.type = type;
            persistenceEvent.userId = userId;
            return persistenceEvent;
        }

        public static PersistenceEvent forChangedUserMetaDataLastBlurred(PersistenceEventType type, GUID userId, GUID channelId) {
            PersistenceEvent persistenceEvent = new PersistenceEvent();
            persistenceEvent.type = type;
            persistenceEvent.userId = userId;
            persistenceEvent.channelId = channelId;
            return persistenceEvent;
        }

        public static PersistenceEvent forChannelReadForUserId(PersistenceEventType type, GUID userId, GUID channelId) {
            PersistenceEvent persistenceEvent = new PersistenceEvent();
            persistenceEvent.type = type;
            persistenceEvent.userId = userId;
            persistenceEvent.channelId = channelId;
            return persistenceEvent;
        }

        public static PersistenceEvent forChangedUserDrafts(PersistenceEventType type, GUID userId) {
            PersistenceEvent persistenceEvent = new PersistenceEvent();
            persistenceEvent.type = type;
            persistenceEvent.userId = userId;
            return persistenceEvent;
        }

        public static PersistenceEvent forChangedUserConnection(PersistenceEventType type, String clientId, GUID userId) {
            PersistenceEvent persistenceEvent = new PersistenceEvent();
            persistenceEvent.type = type;
            persistenceEvent.clientId = clientId;
            persistenceEvent.userId = userId;
            return persistenceEvent;
        }

        public static PersistenceEvent forChangedClientInChannelState(PersistenceEventType type, GUID channelId, ClientInChannelState clientInChannelState) {
            PersistenceEvent persistenceEvent = new PersistenceEvent();
            persistenceEvent.type = type;
            persistenceEvent.channelId = channelId;
            persistenceEvent.clientInChannelState = clientInChannelState;
            return persistenceEvent;
        }

        private static PersistenceEvent forChangedMessage(PersistenceEventType type, GUID channelId, GUID userId, GUID messageId) {
            PersistenceEvent persistenceEvent = new PersistenceEvent();
            persistenceEvent.type = type;
            persistenceEvent.channelId = channelId;
            persistenceEvent.userId = userId;
            persistenceEvent.messageId = messageId;
            return persistenceEvent;
        }

        private static PersistenceEvent forChangedTeam(PersistenceEventType type, GUID teamId) {
            PersistenceEvent persistenceEvent = new PersistenceEvent();
            persistenceEvent.type = type;
            persistenceEvent.teamId = teamId;
            return persistenceEvent;
        }

        private static PersistenceEvent forChangedChannel(PersistenceEventType type, GUID channelId) {
            PersistenceEvent persistenceEvent = new PersistenceEvent();
            persistenceEvent.type = type;
            persistenceEvent.channelId = channelId;
            return persistenceEvent;
        }

        private static void sendNewNode() {
            PersistenceEvent persistenceEvent = new PersistenceEvent();
            persistenceEvent.type = PersistenceEventType.NEW_NODE;
            Persistence.getInstance().sendEvent((Object)persistenceEvent);
        }
    }
}

