/*
 * Decompiled with CFR 0.152.
 */
package com.inet.cowork.server.webapi.teams;

import com.inet.annotations.JsonData;
import com.inet.cowork.api.model.CoWorkTeam;
import com.inet.id.GUID;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Set;

@JsonData
@Schema(description="Response data for a specific team request")
public class TeamGUIDResponseData {
    @Schema(description="Unique identifier of the team")
    private GUID id;
    @Schema(description="Display name of the team", example="Development Team")
    private String displayName;

    public static TeamGUIDResponseData from(CoWorkTeam team, boolean adminContextRequested) {
        TeamGUIDResponseData teamGUIDResponseData = adminContextRequested ? AdminTeamGUIDResponseData.from(team) : new TeamGUIDResponseData();
        teamGUIDResponseData.displayName = team.getDisplayName();
        teamGUIDResponseData.id = team.getId();
        return teamGUIDResponseData;
    }

    @JsonData
    @Schema(description="Additional response data for administrative team requests")
    public static class AdminTeamGUIDResponseData
    extends TeamGUIDResponseData {
        @Schema(description="List of group IDs that have admin permissions for this team")
        private Set<GUID> adminGroupIds;
        @Schema(description="List of user IDs that have admin permissions for this team")
        private Set<GUID> adminUserIds;
        @Schema(description="List of group IDs that are members of this team")
        private Set<GUID> memberGroupIds;
        @Schema(description="List of user IDs that are members of this team")
        private Set<GUID> memberUserIds;

        public static AdminTeamGUIDResponseData from(CoWorkTeam team) {
            AdminTeamGUIDResponseData adminTeamGUIDResponseData = new AdminTeamGUIDResponseData();
            adminTeamGUIDResponseData.adminGroupIds = team.getAdminGroupIds();
            adminTeamGUIDResponseData.adminUserIds = team.getAdminUserIds();
            adminTeamGUIDResponseData.memberGroupIds = team.getMemberGroupIds();
            adminTeamGUIDResponseData.memberUserIds = team.getMemberUserIds();
            return adminTeamGUIDResponseData;
        }
    }
}

