/*
 * Decompiled with CFR 0.152.
 */
package com.inet.cowork.server.search;

import com.inet.cowork.api.CoWorkI18n;
import com.inet.cowork.api.CoWorkManager;
import com.inet.cowork.api.model.CoWorkChannel;
import com.inet.cowork.api.model.CoWorkTeam;
import com.inet.id.GUID;
import com.inet.search.command.FilterTokenMatcher;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.index.IndexSearchEngine;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class i
implements FilterTokenMatcher<GUID> {
    private IndexSearchEngine<GUID> be;

    i(@Nonnull IndexSearchEngine<GUID> indexSearchEngine) {
        this.be = indexSearchEngine;
    }

    public boolean isSuggestedTag() {
        return true;
    }

    @Nullable
    public Predicate<GUID> createSearchFilter(@Nonnull String value) {
        HashSet<GUID> hashSet = new HashSet<GUID>();
        CoWorkManager coWorkManager = CoWorkManager.getInstance();
        for (CoWorkTeam coWorkTeam : coWorkManager.getTeams()) {
            String string;
            if (!coWorkTeam.isAvailable() || !(string = coWorkTeam.getDisplayName().toLowerCase()).startsWith(value)) continue;
            for (CoWorkChannel coWorkChannel : coWorkManager.getAllChannelsInTeam(coWorkTeam.getId())) {
                hashSet.add(coWorkChannel.getId());
            }
        }
        return gUID -> {
            SearchCommand searchCommand = new SearchCommand("msgid", SearchCondition.SearchTermOperator.Equals, gUID);
            Set set = this.be.simpleSearch(searchCommand);
            if (set.isEmpty()) {
                return false;
            }
            GUID gUID2 = (GUID)set.iterator().next();
            return hashSet.contains(gUID2);
        };
    }

    @Nonnull
    public Iterator<String> createDisplayValuesIterator(String startsWith, Predicate<GUID> filter) {
        String string = startsWith instanceof String ? startsWith : null;
        ArrayList<String> arrayList = new ArrayList<String>();
        CoWorkManager coWorkManager = CoWorkManager.getInstance();
        for (CoWorkTeam coWorkTeam : coWorkManager.getTeams()) {
            if (!coWorkTeam.isAvailable()) continue;
            String string2 = coWorkTeam.getDisplayName();
            if (string != null && !string2.toLowerCase().startsWith(string)) continue;
            arrayList.add(string2);
        }
        arrayList.sort(String.CASE_INSENSITIVE_ORDER);
        return arrayList.iterator();
    }

    @Nonnull
    public String getTag() {
        return "team";
    }

    @Nonnull
    public String getDisplayName() {
        return CoWorkI18n.MSG_SERVER.getMsg("search.team", new Object[0]);
    }
}

