/*
 * Decompiled with CFR 0.152.
 */
package com.inet.cowork.server.event;

import com.inet.cowork.api.CoWorkI18n;
import com.inet.cowork.api.CoWorkManager;
import com.inet.cowork.api.CoWorkPermissions;
import com.inet.cowork.api.model.CoWorkChannel;
import com.inet.cowork.api.model.CoWorkTeam;
import com.inet.cowork.api.model.OnlineStatus;
import com.inet.cowork.api.model.UISettings;
import com.inet.cowork.api.model.UserStatus;
import com.inet.cowork.server.data.ChannelDescription;
import com.inet.cowork.server.data.TeamDescription;
import com.inet.cowork.server.data.TeamsAndChannels;
import com.inet.cowork.server.event.f;
import com.inet.http.websocket.WebSocketEventData;
import com.inet.http.websocket.WebSocketEventHandler;
import com.inet.http.websocket.WebsocketConnection;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.usersandgroups.api.user.UserManager;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public class g
extends f<Void> {
    @Override
    public void a(WebSocketEventHandler webSocketEventHandler, WebsocketConnection websocketConnection, Void void_) throws IOException {
        GUID gUID = UserManager.getInstance().getCurrentUserAccountID();
        webSocketEventHandler.sendEvent(websocketConnection.getPollingID(), () -> new WebSocketEventData("cowork.drafts", CoWorkManager.getInstance().getDrafts(gUID)));
        webSocketEventHandler.sendEvent(websocketConnection.getPollingID(), () -> {
            CoWorkChannel coWorkChannel;
            String string;
            UISettings uISettings = CoWorkManager.getInstance().getUISettings(gUID);
            if (uISettings == null) {
                uISettings = new UISettings();
            }
            if (!(StringFunctions.isEmpty((String)(string = (String)uISettings.get("selectedChannel"))) || (coWorkChannel = CoWorkManager.getInstance().getChannel(GUID.valueOf((String)string))) != null && coWorkChannel.isAvailable())) {
                uISettings.remove("selectedChannel");
                CoWorkManager.getInstance().saveUISettings(gUID, uISettings);
            }
            return new WebSocketEventData("cowork.uisettings", (Object)uISettings);
        });
        webSocketEventHandler.sendEvent(websocketConnection.getPollingID(), () -> {
            UserStatus userStatus = CoWorkManager.getInstance().getUserStatus(gUID);
            if (userStatus == null) {
                userStatus = new UserStatus(gUID, OnlineStatus.online, null, null);
            }
            return new WebSocketEventData("cowork.currentuserstatus", (Object)userStatus);
        });
        CoWorkManager.getInstance().registerForChannelTreeUpdates(websocketConnection.getPollingID(), gUID, () -> webSocketEventHandler.sendEvent(websocketConnection.getPollingID(), () -> {
            List<CoWorkTeam> list = CoWorkManager.getInstance().getTeams();
            AtomicBoolean atomicBoolean = new AtomicBoolean(SystemPermissionChecker.checkAccess((Permission)CoWorkPermissions.PERMISSION_COWORK_ADMIN));
            AtomicInteger atomicInteger = new AtomicInteger(0);
            List<TeamDescription> list2 = list.stream().sorted((coWorkTeam, coWorkTeam2) -> {
                int n2;
                if (CoWorkManager.DIRECTMESSAGE_TEAM_ID.equals((Object)coWorkTeam.getId()) && !CoWorkManager.DIRECTMESSAGE_TEAM_ID.equals((Object)coWorkTeam2.getId())) {
                    return 1;
                }
                if (CoWorkManager.DIRECTMESSAGE_TEAM_ID.equals((Object)coWorkTeam2.getId()) && !CoWorkManager.DIRECTMESSAGE_TEAM_ID.equals((Object)coWorkTeam.getId())) {
                    return -1;
                }
                boolean bl = coWorkTeam.isPredefined();
                boolean bl2 = coWorkTeam2.isPredefined();
                if (bl) {
                    if (!bl2) {
                        return -1;
                    }
                } else if (bl2) {
                    return 1;
                }
                String string = coWorkTeam.getDisplayName();
                String string2 = coWorkTeam2.getDisplayName();
                if (string == null) {
                    string = "";
                }
                if (string2 == null) {
                    string2 = "";
                }
                if ((n2 = string.compareToIgnoreCase(string2)) == 0) {
                    n2 = coWorkTeam.getId().toString().compareToIgnoreCase(coWorkTeam2.getId().toString());
                }
                return n2;
            }).map(coWorkTeam -> {
                if (!atomicBoolean.get() && coWorkTeam.isAdmin()) {
                    atomicBoolean.set(true);
                }
                if (!coWorkTeam.isAvailable()) {
                    return null;
                }
                List<ChannelDescription> list = CoWorkManager.getInstance().getChannels(coWorkTeam.getId()).stream().sorted((coWorkChannel, coWorkChannel2) -> {
                    int n2 = coWorkChannel.getDisplayName().compareToIgnoreCase(coWorkChannel2.getDisplayName());
                    if (n2 == 0) {
                        n2 = coWorkChannel.getId().toString().compareToIgnoreCase(coWorkChannel2.getId().toString());
                    }
                    return n2;
                }).map(coWorkChannel -> {
                    Set<GUID> set;
                    boolean bl = CoWorkManager.getInstance().hasUnreadMessageInChannel(coWorkChannel.getId(), UserManager.getInstance().getCurrentUserAccountID());
                    int n2 = 0;
                    if (bl) {
                        n2 = CoWorkManager.getInstance().getUnreadMentionsInChannel(coWorkChannel.getId(), UserManager.getInstance().getCurrentUserAccountID());
                    }
                    boolean bl2 = CoWorkManager.DIRECTMESSAGE_TEAM_ID.equals((Object)coWorkTeam.getId());
                    String string = coWorkChannel.getDescription();
                    if (bl2 && StringFunctions.isEmpty((String)string)) {
                        string = CoWorkI18n.MSG_CLIENT.getMsg("cowork.messages.welcome.dm.private", new Object[0]);
                    }
                    boolean bl3 = false;
                    if (bl2 && (set = coWorkChannel.getMemberUserIds()).size() <= 1) {
                        bl3 = true;
                    }
                    return new ChannelDescription(coWorkChannel.getId(), coWorkChannel.getTeamId(), coWorkChannel.getDisplayName(), string, coWorkChannel.getLastModified(), n2, bl2, bl3, bl, bl2 || coWorkChannel.getIcon() != null);
                }).collect(Collectors.toList());
                if (list.isEmpty()) {
                    return null;
                }
                if (!coWorkTeam.isPredefined()) {
                    atomicInteger.incrementAndGet();
                }
                return new TeamDescription(coWorkTeam.getId(), coWorkTeam.getDisplayName(), coWorkTeam.getLastModified(), list, coWorkTeam.isAdmin(), coWorkTeam.isPredefined());
            }).filter(teamDescription -> teamDescription != null).collect(Collectors.toList());
            return new WebSocketEventData("cowork.teamsandchannels", (Object)new TeamsAndChannels(list2, atomicInteger.get() > 0, atomicBoolean.get(), SystemPermissionChecker.checkAccess((Permission)CoWorkPermissions.PERMISSION_COWORK_ADMIN)));
        }));
    }

    public String getEventName() {
        return "cowork.getteamsandchannels";
    }
}

