/*
 * Decompiled with CFR 0.152.
 */
package com.inet.cowork.api.attachments;

import com.inet.annotations.InternalApi;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.cowork.api.CoWorkI18n;
import com.inet.cowork.api.CoWorkManager;
import com.inet.cowork.api.attachments.CardAttachment;
import com.inet.cowork.api.attachments.LinkPreviewAttachment;
import com.inet.cowork.api.model.CoWorkAttachment;
import com.inet.cowork.api.model.CoWorkMessage;
import com.inet.cowork.server.c;
import com.inet.cowork.server.d;
import com.inet.cowork.server.data.CoWorkAttachmentDescription;
import com.inet.cowork.server.i;
import com.inet.http.ClientMessageException;
import com.inet.http.utils.MimeTypes;
import com.inet.id.GUID;
import com.inet.lib.io.FastByteArrayInputStream;
import com.inet.lib.io.FastByteArrayOutputStream;
import com.inet.lib.json.Json;
import com.inet.lib.markdown.MarkDown2Html;
import com.inet.lib.markdown.MarkDownExtension;
import com.inet.lib.markdown.MarkDownParserOptions;
import com.inet.lib.markdown.MarkDownToken;
import com.inet.lib.markdown.MarkDownTokenType;
import com.inet.lib.markdown.parser.MarkDownParser;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.image.PreviewGenerator;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.Part;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@InternalApi
public class CoWorkAttachmentUtils {
    public static final String TYPE_FILE = "file";
    public static final String TYPE_TEXT = "text";
    public static final String TYPE_IMAGE = "image";
    public static final String TYPE_GIF = "gif";
    public static final String TYPE_VIDEO = "video";
    public static final String TYPE_CARD = "card";
    public static final String TYPE_LINKPREVIEW = "linkpreview";

    public static String getPreviewHtml(GUID channelId, CoWorkAttachment coWorkAttachment, MarkDown2Html markdwonFormatter) throws IOException {
        switch (coWorkAttachment.getType()) {
            case "card": {
                try (InputStream inputStream = CoWorkManager.getInstance().getAttachmentStream(channelId, coWorkAttachment.getId(), false);){
                    if (inputStream == null) {
                        String string = null;
                        return string;
                    }
                    CardAttachment cardAttachment = (CardAttachment)new Json().fromJson(inputStream, CardAttachment.class);
                    String string = cardAttachment.getUrl();
                    String string2 = cardAttachment.getTitle();
                    List<LocalizedKey> list = cardAttachment.getFields();
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("<div class=\"coworkattachmentcard\">");
                    stringBuilder.append("<div class=\"cardtitle\">");
                    if (!StringFunctions.isEmpty((String)string)) {
                        stringBuilder.append(markdwonFormatter.convert("[" + string2 + "](" + string + ")"));
                    } else {
                        stringBuilder.append(markdwonFormatter.convert(string2));
                    }
                    stringBuilder.append("</div>");
                    if (list != null && !list.isEmpty()) {
                        stringBuilder.append("<table class=\"cardfields\">\n");
                        for (LocalizedKey localizedKey : list) {
                            stringBuilder.append("<tr class=\"cardfield\">\n");
                            stringBuilder.append("<td class=\"cardfieldlabel\">");
                            String string3 = localizedKey.getKey();
                            String string4 = c.f(string3);
                            if (string4 == string3) {
                                try {
                                    string4 = markdwonFormatter.convert(string3);
                                }
                                catch (Throwable throwable) {
                                    CoWorkManager.LOGGER.error((Object)("Error formatting card attachment label: '" + string3 + "'"));
                                    CoWorkManager.LOGGER.error(throwable);
                                }
                            }
                            stringBuilder.append(string4);
                            stringBuilder.append("</td>\n");
                            stringBuilder.append("<td class=\"cardfieldvalue\">");
                            String string5 = localizedKey.getDisplayName();
                            String string6 = c.f(string5);
                            if (string6 == string5) {
                                try {
                                    string6 = markdwonFormatter.convert(string5);
                                }
                                catch (Throwable throwable) {
                                    CoWorkManager.LOGGER.error((Object)("Error formatting card attachment description: '" + string5 + "'"));
                                    CoWorkManager.LOGGER.error(throwable);
                                }
                            }
                            stringBuilder.append(string6);
                            stringBuilder.append("</td>\n");
                            stringBuilder.append("</tr>\n");
                        }
                        stringBuilder.append("</table>");
                    }
                    stringBuilder.append("</div>");
                    String string7 = stringBuilder.toString();
                    return string7;
                }
            }
            case "linkpreview": {
                try (InputStream inputStream = CoWorkManager.getInstance().getAttachmentStream(channelId, coWorkAttachment.getId(), false);){
                    if (inputStream == null) {
                        String string = null;
                        return string;
                    }
                    LinkPreviewAttachment linkPreviewAttachment = (LinkPreviewAttachment)new Json().fromJson(inputStream, LinkPreviewAttachment.class);
                    String string = linkPreviewAttachment.getUrl();
                    String string8 = linkPreviewAttachment.getTitle();
                    String string9 = linkPreviewAttachment.getSiteName();
                    String string10 = linkPreviewAttachment.getDescription();
                    String string11 = linkPreviewAttachment.getImageUrl();
                    int n2 = linkPreviewAttachment.getImageWidth();
                    int n3 = linkPreviewAttachment.getImageHeight();
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("<div class=\"coworkattachmentlinkpreview\">");
                    if (!StringFunctions.isEmpty((String)string11)) {
                        stringBuilder.append("<div class=\"linkpreviewimage\">");
                        if (n2 <= 0 || n3 <= 0) {
                            stringBuilder.append("<img src=\"").append(string11).append("\">");
                        } else {
                            stringBuilder.append("<img width=\"").append(n2).append("\" height=\"").append(n3).append("\" src=\"?method=cowork.linkpreviewimage&channel=").append(channelId.toString()).append("&id=").append(coWorkAttachment.getId()).append("\">");
                        }
                        stringBuilder.append("</div>");
                    }
                    stringBuilder.append("<div class=\"linkpreviewdetails\">");
                    if (!StringFunctions.isEmpty((String)string9)) {
                        stringBuilder.append("<div class=\"sitename\">").append(string9).append("</div>");
                    }
                    stringBuilder.append("<div class=\"linktitle\">");
                    if (!StringFunctions.isEmpty((String)string)) {
                        stringBuilder.append("<a href=\"").append(string).append("\" target=\"_blank\">").append(StringFunctions.encodeHTML((String)string8)).append("</a>");
                    } else {
                        stringBuilder.append(StringFunctions.encodeHTML((String)string8));
                    }
                    stringBuilder.append("</div>");
                    if (!StringFunctions.isEmpty((String)string10)) {
                        stringBuilder.append("<div class=\"linkdescription\">");
                        stringBuilder.append(StringFunctions.encodeHTML((String)string10));
                        stringBuilder.append("</div>");
                    }
                    stringBuilder.append("</div>");
                    stringBuilder.append("</div>");
                    String string12 = stringBuilder.toString();
                    return string12;
                }
            }
        }
        return null;
    }

    public static String getPreviewHtml(GUID channelId, CoWorkAttachment coWorkAttachment) throws IOException {
        return CoWorkAttachmentUtils.getPreviewHtml(channelId, coWorkAttachment, d.X);
    }

    public static List<GUID> saveAttachmentsForRequest(GUID channelId, List<CoWorkAttachmentDescription> attachments, HttpServletRequest request) {
        ArrayList<GUID> arrayList = null;
        if (attachments != null && !attachments.isEmpty()) {
            arrayList = new ArrayList<GUID>();
            int n2 = 0;
            CoWorkManager coWorkManager = CoWorkManager.getInstance();
            for (CoWorkAttachmentDescription coWorkAttachmentDescription : attachments) {
                Object object;
                try {
                    Part part = request.getPart("attachment" + n2++);
                    if (part == null) {
                        throw new ClientMessageException("Attachment with the message part name 'attachment" + (n2 - 1) + "' could not be found.");
                    }
                    object = part.getInputStream();
                    try {
                        CoWorkAttachment coWorkAttachment = CoWorkAttachment.create(null, coWorkAttachmentDescription.getName(), part.getSize());
                        String string = MimeTypes.getMimeType((String)coWorkAttachment.getName());
                        if (coWorkAttachmentDescription.getPreviewWidth() > 0 && coWorkAttachmentDescription.getPreviewHeight() > 0) {
                            int n3 = coWorkAttachmentDescription.getPreviewWidth();
                            int n4 = coWorkAttachmentDescription.getPreviewHeight();
                            float f2 = (float)n3 / (float)n4;
                            if (n3 > 500) {
                                n3 = 500;
                                n4 = (int)Math.floor(500.0f / f2);
                            }
                            if (n4 > 500) {
                                n4 = 500;
                                n3 = (int)Math.floor(500.0f * f2);
                            }
                            if (string.startsWith("image/")) {
                                coWorkAttachment.setType(TYPE_IMAGE);
                            }
                            if (string.startsWith("video/")) {
                                coWorkAttachment.setType(TYPE_VIDEO);
                            }
                            coWorkAttachment.addProperty("previewWidth", String.valueOf(n3));
                            coWorkAttachment.addProperty("previewHeight", String.valueOf(n4));
                        } else {
                            String string2 = coWorkAttachment.getName().toLowerCase();
                            if (coWorkAttachment.getSize() > 0L && (string.startsWith("text/") || string.startsWith("application/json") || string2.endsWith(".log"))) {
                                coWorkAttachment.setType(TYPE_TEXT);
                                BufferedInputStream bufferedInputStream = new BufferedInputStream((InputStream)object);
                                try {
                                    bufferedInputStream.mark(Integer.MAX_VALUE);
                                    int n5 = 51200;
                                    byte[] byArray = new byte[1024];
                                    try (FastByteArrayOutputStream fastByteArrayOutputStream = new FastByteArrayOutputStream(n5);){
                                        int n6;
                                        while ((n6 = bufferedInputStream.read(byArray)) != -1) {
                                            fastByteArrayOutputStream.write(byArray, 0, n6);
                                            if (fastByteArrayOutputStream.size() < n5) continue;
                                        }
                                        Object object2 = new String(Arrays.copyOf(fastByteArrayOutputStream.toByteArray(), fastByteArrayOutputStream.size()));
                                        if (fastByteArrayOutputStream.size() >= n5) {
                                            object2 = (String)object2 + "\n...\n";
                                            object2 = (String)object2 + CoWorkI18n.MSG_SERVER.getMsg("cowork.attachment.textpreview.cutted", new Object[0]);
                                        }
                                        coWorkAttachment.addProperty("previewText", (String)object2);
                                        coWorkAttachment.addProperty("previewTextLineCount", String.valueOf(((String)object2).split("\n").length));
                                    }
                                    bufferedInputStream.reset();
                                    coWorkManager.saveAttachment(channelId, coWorkAttachment, bufferedInputStream);
                                    arrayList.add(coWorkAttachment.getId());
                                    continue;
                                }
                                finally {
                                    bufferedInputStream.close();
                                    continue;
                                }
                            }
                        }
                        coWorkManager.saveAttachment(channelId, coWorkAttachment, (InputStream)object);
                        arrayList.add(coWorkAttachment.getId());
                    }
                    finally {
                        if (object == null) continue;
                        ((InputStream)object).close();
                    }
                }
                catch (ClientMessageException clientMessageException) {
                    throw clientMessageException;
                }
                catch (Throwable throwable) {
                    CoWorkManager.LOGGER.error(throwable);
                    object = throwable.getMessage() != null ? " " + throwable.getMessage() : "";
                    throw new ClientMessageException("Attachment with the message part name 'attachment" + (n2 - 1) + "' could not be added." + (String)object);
                }
            }
        }
        return arrayList;
    }

    public static void updateMetaDataForPreview(GUID channelId, CoWorkAttachment coWorkAttachment) throws IOException {
        CoWorkManager coWorkManager;
        PreviewGenerator.ImagePreview imagePreview;
        String string = MimeTypes.getMimeType((String)coWorkAttachment.getName());
        if (string.startsWith("image/") && (imagePreview = PreviewGenerator.generatePreviewImage(() -> CoWorkAttachmentUtils.a(coWorkManager = CoWorkManager.getInstance(), channelId, coWorkAttachment), (String)string.substring("image/".length()), (int)500)) != null) {
            coWorkAttachment.setType("image/gif".equals(string) ? TYPE_GIF : TYPE_IMAGE);
            coWorkAttachment.addProperty("previewWidth", String.valueOf(imagePreview.getWidth()));
            coWorkAttachment.addProperty("previewHeight", String.valueOf(imagePreview.getHeight()));
            coWorkManager.updateAttachmentMetaData(channelId, coWorkAttachment);
            if (imagePreview.hasPreviewImage()) {
                coWorkManager.saveAttachmentPreview(channelId, coWorkAttachment, new ByteArrayInputStream(imagePreview.getData()));
            }
        }
    }

    public static void createLinkPreviews(String clientId, GUID channelId, CoWorkMessage message) {
        String string = message.getText();
        if (string == null || string.isBlank()) {
            return;
        }
        MarkDownParserOptions markDownParserOptions = new MarkDownParserOptions();
        markDownParserOptions.setExtension((MarkDownExtension)d.T);
        List list = new MarkDownParser(string, markDownParserOptions).tokenize();
        for (MarkDownToken markDownToken : list) {
            LinkPreviewAttachment linkPreviewAttachment;
            String string2;
            if (markDownToken.getType() != MarkDownTokenType.Hyperlink || StringFunctions.isEmpty((String)(string2 = markDownToken.toString())) || !string2.toLowerCase().startsWith("http://") && !string2.toLowerCase().startsWith("https://") || (linkPreviewAttachment = i.h(string2)) == null) continue;
            String string3 = new Json().toJson((Object)linkPreviewAttachment);
            byte[] byArray = string3.getBytes(StandardCharsets.UTF_8);
            CoWorkAttachment coWorkAttachment = CoWorkAttachment.create(null, "linkpreview.json", byArray.length);
            coWorkAttachment.setType(TYPE_LINKPREVIEW);
            CoWorkManager.getInstance().saveAttachment(channelId, coWorkAttachment, (InputStream)new FastByteArrayInputStream(byArray));
            ArrayList<GUID> arrayList = new ArrayList<GUID>();
            arrayList.add(coWorkAttachment.getId());
            CoWorkManager.getInstance().addMessage(clientId, channelId, message.getUserId(), null, null, arrayList);
        }
    }

    private static /* synthetic */ InputStream a(CoWorkManager coWorkManager, GUID gUID, CoWorkAttachment coWorkAttachment) {
        return coWorkManager.getAttachmentStream(gUID, coWorkAttachment.getId(), false);
    }
}

