/*
 * Decompiled with CFR 0.152.
 */
package com.inet.cowork.waitingqueue.server.data;

import com.inet.annotations.JsonData;
import com.inet.id.GUID;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonData
public class WaitingUsers {
    private List<@Nonnull ConsultationRequest> requests = new ArrayList<ConsultationRequest>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public @Nonnull List<@Nonnull ConsultationRequest> getRequests() {
        List<ConsultationRequest> list = this.requests;
        synchronized (list) {
            return new ArrayList<ConsultationRequest>(this.requests);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRequest(@Nonnull GUID userID, GUID channelId, GUID messageId, String topic) {
        ConsultationRequest consultationRequest = new ConsultationRequest(userID, channelId, messageId, topic);
        if (!this.requests.contains(consultationRequest)) {
            List<ConsultationRequest> list = this.requests;
            synchronized (list) {
                if (!this.requests.contains(consultationRequest)) {
                    this.requests.add(consultationRequest);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ConsultationRequest getRequest(@Nonnull GUID userID) {
        ConsultationRequest consultationRequest = new ConsultationRequest(userID, null, null, null);
        if (this.requests.contains(consultationRequest)) {
            List<ConsultationRequest> list = this.requests;
            synchronized (list) {
                int n = this.requests.indexOf(consultationRequest);
                if (n >= 0) {
                    return this.requests.get(n);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUser(@Nonnull GUID userID) {
        ConsultationRequest consultationRequest = new ConsultationRequest(userID, null, null, null);
        if (this.requests.contains(consultationRequest)) {
            List<ConsultationRequest> list = this.requests;
            synchronized (list) {
                this.requests.remove(consultationRequest);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changePosition(@Nonnull GUID userID, boolean up) {
        ConsultationRequest consultationRequest = new ConsultationRequest(userID, null, null, null);
        if (this.requests.contains(consultationRequest)) {
            List<ConsultationRequest> list = this.requests;
            synchronized (list) {
                int n = this.requests.indexOf(consultationRequest);
                if (n >= 0) {
                    consultationRequest = this.requests.remove(n);
                    n = up ? Math.max(0, n - 1) : Math.min(this.requests.size(), n + 1);
                    this.requests.add(n, consultationRequest);
                }
            }
        }
    }

    @JsonData
    public static class ConsultationRequest {
        @Nonnull
        private GUID userId;
        @Nullable
        private GUID channelId;
        @Nullable
        private GUID messageId;
        @Nullable
        private String topic;

        private ConsultationRequest() {
        }

        public ConsultationRequest(@Nonnull GUID userId, @Nullable GUID channelId, @Nullable GUID messageId, @Nullable String topic) {
            this.userId = userId;
            this.channelId = channelId;
            this.messageId = messageId;
            this.topic = topic;
        }

        public GUID getUserId() {
            return this.userId;
        }

        public GUID getChannelId() {
            return this.channelId;
        }

        public GUID getMessageId() {
            return this.messageId;
        }

        public String getTopic() {
            return this.topic;
        }

        public int hashCode() {
            int n = 31;
            int n2 = 1;
            n2 = 31 * n2 + (this.userId == null ? 0 : this.userId.hashCode());
            return n2;
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ConsultationRequest consultationRequest = (ConsultationRequest)obj;
            return this.userId.equals((Object)consultationRequest.userId);
        }
    }
}

