/*
 * Decompiled with CFR 0.152.
 */
package com.inet.cowork.integration.ticketlist;

import com.inet.classloader.I18nMessages;
import com.inet.cowork.api.CoWorkManager;
import com.inet.cowork.api.CoWorkPermissions;
import com.inet.cowork.integration.ticketlist.ticketpageextension.CoWorkChatExtension;
import com.inet.file.CombinedFileDescription;
import com.inet.file.FileCombiner;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketPageExtension;
import com.inet.http.servlet.ClientLocale;
import com.inet.lib.io.FastByteArrayInputStream;
import com.inet.permissions.Permission;
import com.inet.plugin.HelpProviderContainer;
import com.inet.plugin.PluginInfo;
import com.inet.plugin.ServerPlugin;
import com.inet.plugin.ServerPluginManager;
import com.inet.plugin.help.HelpProvider;
import com.inet.plugin.help.HelpProviderImpl;
import com.inet.remote.gui.angular.AngularContentService;
import com.inet.theme.server.ThemeResource;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

@PluginInfo(id="cowork.tickets", dependencies="helpdesk;cowork;remotegui;ticketlist", optionalDependencies="theme", packages="", group="tickets;communication;integration", version="25.10.219", icon="com/inet/cowork/integration/ticketlist/images/tickets_cowork_48.png", internal="", flags="")
public class CoWorkInTicketsServerPlugin
implements ServerPlugin {
    public static final I18nMessages MSG = new I18nMessages("com.inet.cowork.integration.ticketlist.i18n.LanguageResources", CoWorkInTicketsServerPlugin.class);

    public void registerHelp(HelpProviderContainer container) {
        container.add((HelpProvider)new HelpProviderImpl("ticketlist", 9912, new Permission[]{CoWorkPermissions.PERMISSION_COWORK}){}, new String[0]);
    }

    public void registerExtension(ServerPluginManager spm) {
        spm.register(TicketPageExtension.class, (Object)new CoWorkChatExtension());
        FileCombiner.CombinedFile integrationJavaScript = new FileCombiner.CombinedFile("application/x-javascript; charset=utf-8", new URL[0]);
        integrationJavaScript.add(this.getClass(), "ticketpageextension/coworkchatextension.js");
        integrationJavaScript.addMessages(MSG);
        integrationJavaScript.addRuntimeData(new FileCombiner.RuntimeData(){

            public InputStream getDataStream() {
                byte[] data = new byte[]{};
                try {
                    FileCombiner.CombinedFile combinedFileCoWork = AngularContentService.getCombinedFile((String)"cowork.js");
                    byte[] dataCoWork = combinedFileCoWork.getData(ClientLocale.getThreadLocale());
                    FileCombiner.CombinedFile combinedFileCoWorkExtensions = AngularContentService.getCombinedFile((String)"cowork.extensions.js");
                    byte[] dataCoWorkExtension = combinedFileCoWorkExtensions.getData(ClientLocale.getThreadLocale());
                    FileCombiner.CombinedFile combinedFileEmojiData = AngularContentService.getCombinedFile((String)"emojidata.js");
                    byte[] dataEmojiData = combinedFileEmojiData.getData(ClientLocale.getThreadLocale());
                    data = new byte[dataCoWork.length + dataCoWorkExtension.length + dataEmojiData.length];
                    System.arraycopy(dataCoWork, 0, data, 0, dataCoWork.length);
                    System.arraycopy(dataCoWorkExtension, 0, data, dataCoWork.length, dataCoWorkExtension.length);
                    System.arraycopy(dataEmojiData, 0, data, dataCoWork.length + dataCoWorkExtension.length, dataEmojiData.length);
                }
                catch (IOException e) {
                    CoWorkManager.LOGGER.error((Throwable)e);
                }
                return new FastByteArrayInputStream(data);
            }
        });
        spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", 222, "helpdesk.ticket.extensions.js", integrationJavaScript));
        FileCombiner.CombinedFile defaultCss = new FileCombiner.CombinedFile("text/css", new URL[0]);
        defaultCss.add(this.getClass(), "css/cowork.css");
        defaultCss.add(this.getClass(), "css/cowork-sprites.css");
        spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", 107, "defaulttheme.css", defaultCss));
        if (spm.isPluginLoaded("theme")) {
            spm.register(ThemeResource.class, (Object)new ThemeResource("remotegui", this.getClass().getResource("css/cowork.less")));
            spm.register(ThemeResource.class, (Object)new ThemeResource("remotegui", this.getClass().getResource("css/cowork-sprites.less")));
        }
    }

    public void init(ServerPluginManager spm) {
    }

    public void reset() {
    }

    public void restart() {
    }
}

