/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.plugins.config.server.handler;

import com.inet.config.Configuration;
import com.inet.config.ConfigurationManager;
import com.inet.http.ClientMessageException;
import com.inet.lib.io.FastByteArrayOutputStream;
import com.inet.permissions.AccessDeniedException;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.remote.gui.angular.DownloadServiceMethod;
import com.inet.report.plugins.config.server.ConfigServerPlugin;
import com.inet.report.plugins.config.server.data.ExportConfigurationRequestData;
import com.inet.shared.servlet.ServletUtils;
import com.inet.usersandgroups.api.user.UserManager;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;

public class h
extends DownloadServiceMethod<ExportConfigurationRequestData> {
    public byte[] a(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ExportConfigurationRequestData exportConfigurationRequestData) throws IOException {
        if (UserManager.getInstance().getCurrentUserAccount() == null) {
            throw new AccessDeniedException();
        }
        if (!SystemPermissionChecker.checkAccess((Permission)Permission.CONFIGURATION)) {
            throw new AccessDeniedException(Permission.CONFIGURATION);
        }
        ConfigurationManager configurationManager = ConfigurationManager.getInstance();
        Configuration configuration = configurationManager.get(exportConfigurationRequestData.getConfigScope(), exportConfigurationRequestData.getConfigName());
        if (configuration == null) {
            throw new ClientMessageException(ConfigServerPlugin.MSG.getMsg("config.error.configurationDoesNotExists", new Object[0]));
        }
        try {
            Object object = configuration.getName() + ".properties";
            object = ((String)object).replace("\"", "");
            ServletUtils.setContentDisposition((HttpServletResponse)httpServletResponse, (String)object, (boolean)false);
            FastByteArrayOutputStream fastByteArrayOutputStream = new FastByteArrayOutputStream();
            configurationManager.exportToStream(exportConfigurationRequestData.getConfigScope(), exportConfigurationRequestData.getConfigName(), (OutputStream)fastByteArrayOutputStream);
            return fastByteArrayOutputStream.toByteArray();
        }
        catch (Throwable throwable) {
            throw new ClientMessageException(ConfigServerPlugin.MSG.getMsg("config.error.configurationCouldNotBeExported", new Object[]{throwable.getMessage()}));
        }
    }

    public String getMimeType() {
        return "text/plain; charset=utf-8";
    }

    public String getMethodName() {
        return "config_exportaction";
    }

    public short getMethodType() {
        return 1;
    }

    public /* synthetic */ byte[] invokeDownload(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object object) throws IOException {
        return this.a(httpServletRequest, httpServletResponse, (ExportConfigurationRequestData)object);
    }
}

