/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.webgui.server.drive;

import com.inet.drive.api.DriveEntry;
import com.inet.drive.api.DriveFileTypeHandler;
import com.inet.drive.api.feature.Content;
import com.inet.drive.api.feature.MetaData;
import com.inet.drive.api.feature.MetaKey;
import com.inet.drive.api.feature.RandomAccess;
import com.inet.drive.api.feature.Thumbnail;
import com.inet.pdfc.PDFCCore;
import com.inet.pdfc.config.DefaultProfile;
import com.inet.pdfc.config.IProfile;
import com.inet.pdfc.config.PdfSource;
import com.inet.pdfc.config.PersistencePdfSource;
import com.inet.pdfc.error.PdfcException;
import com.inet.pdfc.generator.filter.ConvertFilter;
import com.inet.pdfc.model.Document;
import com.inet.pdfc.model.ElementType;
import com.inet.pdfc.model.EnumerationProgress;
import com.inet.pdfc.model.Page;
import com.inet.pdfc.plugin.DocumentReader;
import com.inet.pdfc.plugin.interfaces.DocumentFactory;
import com.inet.pdfc.util.TextExtractor;
import com.inet.pdfc.webgui.PDFCWebGuiServerPlugin;
import com.inet.persistence.PersistenceEntry;
import com.inet.persistence.RandomAccessRead;
import com.inet.plugin.image.PreviewGenerator;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.imageio.ImageIO;

public class b
implements DriveFileTypeHandler {
    private static final Set<String> O = new HashSet<String>(Arrays.asList("pdf", "docx", "txt", "jpeg", "jpg", "png"));

    public String getExtensionName() {
        return "pdfc.drive.documenthandler";
    }

    public boolean acceptFileTyp(@Nonnull DriveEntry entry) {
        @Nonnull String string = entry.getName();
        int n2 = string.lastIndexOf(46);
        if (n2 < 0) {
            return false;
        }
        String string2 = string.substring(n2 + 1).toLowerCase();
        Set set = DocumentReader.getInstance().getSupportedFileExtensions();
        set.remove("zip");
        return set.contains(string2);
    }

    public String getFileTypeName(DriveEntry entry) {
        if (entry == null) {
            return null;
        }
        String string = entry.getName();
        int n2 = string.lastIndexOf(46);
        if (n2 < 0) {
            return null;
        }
        String string2 = string.substring(n2 + 1).toLowerCase();
        if (O.contains(string2)) {
            return PDFCWebGuiServerPlugin.MSG_SERVER.getMsg("filetype." + string2, new Object[0]);
        }
        return null;
    }

    public DriveFileTypeHandler.FileTypeDriveEntryHandler getFileTypeHandler(PersistenceEntry pEntry, DriveEntry entry) {
        return new a(pEntry, entry);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PreviewGenerator.ImagePreview getThumbnail(DriveEntry entry, Thumbnail.Size size, boolean requireExactSize) throws IOException {
        if (!entry.hasFeature(RandomAccess.class)) {
            return null;
        }
        b b2 = new b(entry);
        try (Document document = DocumentReader.getInstance().readDocument((PdfSource)b2);){
            Page page = document.getPages(null, 0, -1).nextElement();
            if (page == null) {
                PreviewGenerator.ImagePreview imagePreview2 = null;
                return imagePreview2;
            }
            float f2 = page.getWidth();
            float f3 = page.getHeight();
            int n2 = size.getSize();
            int n3 = (int)f2;
            int n4 = (int)f3;
            if (f2 > (float)n2 || f3 > (float)n2) {
                double d2 = f2 > f3 ? (double)((float)n2 / f2) : (double)((float)n2 / f3);
                n3 = (int)((double)f2 * d2);
                n4 = (int)((double)f3 * d2);
            }
            final BufferedImage bufferedImage = page.getImage(n3 * 2, n4 * 2, null, true, true);
            PreviewGenerator.ImagePreview imagePreview = new PreviewGenerator.ImagePreview(bufferedImage.getWidth(), bufferedImage.getHeight(), "png", new ByteArrayOutputStream()){

                public byte[] getData() {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    try {
                        ImageIO.write((RenderedImage)bufferedImage, "png", byteArrayOutputStream);
                    }
                    catch (IOException iOException) {
                        return null;
                    }
                    return byteArrayOutputStream.toByteArray();
                }

                public void writeTo(OutputStream out) throws IOException {
                    ImageIO.write((RenderedImage)bufferedImage, "png", out);
                }
            };
            return imagePreview;
        }
        catch (DocumentFactory.PasswordException passwordException) {
            return null;
        }
        catch (PdfcException pdfcException) {
            throw new IOException(pdfcException);
        }
    }

    public Object getFileSpecificDiff(DriveEntry previous, DriveEntry after) {
        return null;
    }

    private static class a
    implements DriveFileTypeHandler.FileTypeDriveEntryHandler {
        private String type = "pdf";
        private String content;
        private Map<String, String> R;

        public a(@Nonnull PersistenceEntry persistenceEntry, @Nonnull DriveEntry driveEntry) {
            String string = driveEntry.getName();
            int n2 = string.lastIndexOf(46);
            if (n2 >= 0) {
                this.type = string.substring(n2 + 1).toLowerCase();
            }
            if (persistenceEntry.size() == 0L) {
                this.content = "";
                return;
            }
            try (Document document = DocumentReader.getInstance().readDocumentReduced((PdfSource)new PersistencePdfSource(persistenceEntry, driveEntry.getName()), new DocumentFactory.FEATURE[]{DocumentFactory.FEATURE.text});){
                this.R = document.getMetaData();
                EnumerationProgress enumerationProgress = document.getPages(null, 0, -1);
                StringBuilder stringBuilder = new StringBuilder();
                ConvertFilter convertFilter = new ConvertFilter((IProfile)new DefaultProfile(), null);
                TextExtractor textExtractor = new TextExtractor((IProfile)new DefaultProfile());
                while (enumerationProgress.hasMoreElements()) {
                    Page page = enumerationProgress.nextElement();
                    List list = page.getElementList().getList().stream().filter(drawableElement -> drawableElement.getType() == ElementType.Text).collect(Collectors.toList());
                    List list2 = convertFilter.sortOrFilterPage(page.getPageIndex(), list, true, null);
                    TextExtractor.PageDescription pageDescription = textExtractor.createPageDescription(list2);
                    stringBuilder.append(pageDescription.getContent());
                    if (stringBuilder.length() <= 1000000) continue;
                    break;
                }
                this.content = stringBuilder.toString();
            }
            catch (DocumentFactory.PasswordException passwordException) {
            }
            catch (Exception exception) {
                PDFCCore.LOGGER_CORE.debug("Cannot read meta data for document '" + string + "' because of an error:", (Object)exception);
            }
        }

        public String getTextForSearch() {
            return this.content;
        }

        public Map<MetaKey<?>, Object> getMetaData() {
            HashMap hashMap = new HashMap();
            hashMap.put(MetaData.FILETYPE, this.type);
            if (this.R != null) {
                if (this.R.get("title") != null) {
                    hashMap.put(MetaData.TITLE, this.R.get("title"));
                }
                if (this.R.get("author") != null) {
                    hashMap.put(MetaData.AUTHOR, this.R.get("author"));
                }
                if (this.R.get("producer") != null) {
                    hashMap.put(MetaData.PRODUCER, this.R.get("producer"));
                }
                if (this.R.get("creationDate") != null) {
                    try {
                        hashMap.put(MetaData.CREATE, Long.valueOf(this.R.get("creationDate")));
                    }
                    catch (Exception exception) {
                        PDFCCore.LOGGER_CORE.debug((Object)exception);
                    }
                }
                if (this.R.get("modifiedDate") != null) {
                    try {
                        hashMap.put(MetaData.MODIFIED, Long.valueOf(this.R.get("modifiedDate")));
                    }
                    catch (Exception exception) {
                        PDFCCore.LOGGER_CORE.debug((Object)exception);
                    }
                }
            }
            return hashMap;
        }
    }

    private static class b
    extends PdfSource {
        private DriveEntry S;

        public b(DriveEntry driveEntry) {
            super(driveEntry.getName(), driveEntry.getPath(), driveEntry.getLastModified(), ((Content)driveEntry.getFeature(Content.class)).getSize());
            this.S = driveEntry;
        }

        public RandomAccessRead getContent() throws IOException {
            return ((RandomAccess)this.S.getFeature(RandomAccess.class)).getRandomAccess();
        }
    }
}

