/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.webgui.server.model;

import com.inet.annotations.JsonData;
import com.inet.id.GUID;
import com.inet.pdfc.generator.message.State;
import com.inet.pdfc.plugin.persistence.ComparePersistence;
import java.util.Properties;

@JsonData
public class Comparison {
    private GUID guid;
    private GUID owner;
    private String publishing;
    private String publishingLabel;
    private Properties metaData;
    private String firstDocumentName;
    private String secondDocumentName;
    private String previewID;
    private long size;
    private long differences;
    private String configuration;
    private State state;
    private transient long created = -1L;
    private transient long modified = -1L;
    private transient String title = null;

    public Comparison(GUID guid, GUID ownerID, State state, ComparePersistence.PUBLICATION_MODE publishing, String publishingLabel, Properties metaData, String firstDocumentName, String secondDocumentName, String previewID, String configuration, long size, long differences) {
        this.guid = guid;
        this.owner = ownerID;
        this.state = state;
        switch (publishing) {
            case persistent_hidden: {
                this.publishing = "public";
                break;
            }
            case persistent_public: {
                this.publishing = "custom";
                break;
            }
            default: {
                this.publishing = "private";
            }
        }
        this.publishingLabel = publishingLabel;
        this.metaData = metaData;
        this.firstDocumentName = firstDocumentName;
        this.secondDocumentName = secondDocumentName;
        this.previewID = previewID;
        this.configuration = configuration;
        this.size = size;
        this.differences = differences;
    }

    public GUID getID() {
        return this.guid;
    }

    public String getFirstDocumentName() {
        return this.firstDocumentName;
    }

    public String getSecondDocumentName() {
        return this.secondDocumentName;
    }

    public long getSize() {
        return this.size;
    }

    public long getDifferences() {
        return this.differences;
    }

    public String getProfile() {
        return this.configuration;
    }

    public State getState() {
        return this.state;
    }

    public long getCreated() {
        if (this.created >= 0L) {
            return this.created;
        }
        this.created = 0L;
        if (this.metaData != null) {
            try {
                this.created = Long.parseLong(this.metaData.getProperty("created", "0"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.created;
    }

    public long getModified() {
        if (this.modified >= 0L) {
            return this.modified;
        }
        this.modified = 0L;
        if (this.metaData != null) {
            try {
                this.modified = Long.parseLong(this.metaData.getProperty("modified", "0"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.modified != -1L ? this.modified : this.created;
    }

    public String getTitle() {
        if (this.title != null) {
            return this.title;
        }
        this.title = this.metaData.getProperty("title", "");
        return this.title;
    }
}

