/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.webgui.server.events.data;

import com.inet.annotations.JsonData;
import com.inet.id.GUID;
import com.inet.pdfc.plugin.persistence.ComparePersistence;
import com.inet.pdfc.plugin.persistence.UserSession;
import com.inet.pdfc.webgui.server.events.data.AbstractData;
import com.inet.pdfc.webgui.server.events.data.CompareProfile;
import com.inet.pdfc.webgui.server.events.data.Contingent;
import com.inet.pdfc.webgui.server.events.data.DocumentData;
import com.inet.pdfc.webgui.server.events.data.OwnerData;
import com.inet.pdfc.webgui.server.events.data.Page;
import com.inet.pdfc.webgui.server.events.data.PageDiffs;
import com.inet.pdfc.webgui.server.events.data.Progress;
import com.inet.pdfc.webgui.server.events.data.TotalSize;
import com.inet.pdfc.webgui.server.model.ViewOptionsData;
import com.inet.pdfc.webgui.server.model.VisibilitySetting;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;

@JsonData
public class InitialData
extends AbstractData {
    private List<UserSession> viewers;
    private Properties metaData;
    private ComparePersistence.PUBLICATION_MODE publishing;
    private String publishingLabel;
    private OwnerData ownerData;
    private DocumentData firstDocument;
    private DocumentData secondDocument;
    private ArrayList<Page> firstPages;
    private ArrayList<Page> secondPages;
    private Progress progress;
    private String error;
    private String configurationid;
    private PageDiffs pageDiffs;
    private ViewOptionsData viewOptions;
    private ArrayList<CompareProfile> compareProfiles;
    private Set<String> supportedExtensions;
    private Contingent contingent;
    private ArrayList<VisibilitySetting> differenceVisibilities;
    private ArrayList<String> grantedPermissions = new ArrayList();
    private boolean configurationDefined;
    private TotalSize totalSize;
    private Properties settings;

    private InitialData() {
        super(null);
    }

    public InitialData(GUID guid) {
        super(guid);
    }

    public void setViewers(List<UserSession> viewers) {
        this.viewers = viewers;
    }

    public void setMetaData(Properties metaData) {
        this.metaData = metaData;
    }

    public void setPublishing(ComparePersistence.PUBLICATION_MODE publishing) {
        this.publishing = publishing;
    }

    public void setOwner(OwnerData ownerData) {
        this.ownerData = ownerData;
    }

    public void setFirstDocument(DocumentData firstDocument) {
        this.firstDocument = firstDocument;
    }

    public void setSecondDocument(DocumentData secondDocument) {
        this.secondDocument = secondDocument;
    }

    public void setFirstPages(ArrayList<Page> firstPages) {
        this.firstPages = firstPages;
    }

    public void setSecondPages(ArrayList<Page> secondPages) {
        this.secondPages = secondPages;
    }

    public void setProgress(Progress progress) {
        this.progress = progress;
    }

    public void setError(String error) {
        this.error = error;
    }

    public void setPageDiffs(PageDiffs pageDiffs) {
        this.pageDiffs = pageDiffs;
    }

    public void setCompareProfiles(ArrayList<CompareProfile> compareProfiles) {
        this.compareProfiles = compareProfiles;
    }

    public void setViewOptions(ViewOptionsData viewOptions) {
        this.viewOptions = viewOptions;
    }

    public void setSupportedExtensions(Set<String> supportedExtensions) {
        this.supportedExtensions = supportedExtensions;
    }

    public void setContingent(Contingent contingent) {
        this.contingent = contingent;
    }

    public void setConfigurationid(String configurationid) {
        this.configurationid = configurationid;
    }

    public void addPermission(Permission permission) {
        if (SystemPermissionChecker.checkAccess((Permission)permission)) {
            this.grantedPermissions.add(permission.getKey());
        }
    }

    public void setConfigurationDefined(boolean configurationDefined) {
        this.configurationDefined = configurationDefined;
    }

    public void setTotalSize(TotalSize totalSize) {
        this.totalSize = totalSize;
    }

    public void setSettings(Properties settings) {
        this.settings = settings;
    }

    public void setDifferenceVisibilities(ArrayList<VisibilitySetting> differenceVisibilities) {
        this.differenceVisibilities = differenceVisibilities;
    }

    public PageDiffs getPageDiffs() {
        return this.pageDiffs;
    }

    public void setPublishingLabel(String publishingLabel) {
        this.publishingLabel = publishingLabel;
    }
}

