/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.webgui.server.drive;

import com.inet.annotations.JsonData;
import com.inet.drive.api.Drive;
import com.inet.drive.api.DriveEntry;
import com.inet.drive.api.DriveIOException;
import com.inet.drive.api.feature.Content;
import com.inet.http.ClientMessageException;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonException;
import com.inet.lib.util.StringFunctions;
import com.inet.pdfc.PDFCCore;
import com.inet.pdfc.config.DefaultProfile;
import com.inet.pdfc.config.SourceProfile;
import com.inet.pdfc.plugin.interfaces.CompareRunnerFactory;
import com.inet.pdfc.plugin.persistence.ComparePersistence;
import com.inet.pdfc.plugin.persistence.PersistenceFactory;
import com.inet.pdfc.plugin.persistence.PersistenceObserver;
import com.inet.pdfc.plugin.persistence.ProfilePersistence;
import com.inet.pdfc.plugin.persistence.ProfilePersistenceManager;
import com.inet.pdfc.plugin.persistence.QuotaExceededException;
import com.inet.pdfc.plugin.persistence.UserSession;
import com.inet.pdfc.plugin.persistence.UserState;
import com.inet.pdfc.webgui.PDFCWebGuiServerPlugin;
import com.inet.pdfc.webgui.server.drive.CreateComparisonResponse;
import com.inet.pdfc.webgui.server.model.ViewOptionsData;
import com.inet.permissions.AccessDeniedException;
import com.inet.plugin.ServerPluginManager;
import com.inet.remote.gui.angular.ServiceMethod;
import com.inet.shared.servlet.ProxyHttpServletRequest;
import com.inet.thread.timer.DefaultTimer;
import com.inet.thread.timer.DefaultTimerTask;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CreateComparisonHandler
extends ServiceMethod<NewComparisonData, CreateComparisonResponse> {
    public String getMethodName() {
        return "drive.compare";
    }

    public short getMethodType() {
        return 1;
    }

    public CreateComparisonResponse a(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, NewComparisonData newComparisonData) throws IOException {
        ViewOptionsData viewOptionsData;
        String string;
        UserAccount userAccount;
        Drive drive = this.h();
        DriveEntry driveEntry = drive.resolve(newComparisonData.document1);
        if (driveEntry == null || !driveEntry.exists()) {
            throw new ClientMessageException(PDFCWebGuiServerPlugin.MSG_SERVER.getMsg("pdfc.drive.error.first", new Object[0]));
        }
        DriveEntry driveEntry2 = drive.resolve(newComparisonData.document2);
        if (driveEntry2 == null || !driveEntry2.exists()) {
            throw new ClientMessageException(PDFCWebGuiServerPlugin.MSG_SERVER.getMsg("pdfc.drive.error.second", new Object[0]));
        }
        DriveEntry driveEntry3 = null;
        if (!(newComparisonData.profile == null || (driveEntry3 = drive.resolve(newComparisonData.profile)) != null && driveEntry3.exists())) {
            throw new ClientMessageException("Profile XML not found");
        }
        GUID gUID = null;
        if (driveEntry3 != null) {
            gUID = CreateComparisonHandler.a(driveEntry3);
        } else {
            String string2;
            userAccount = UserManager.getInstance().getCurrentUserAccount();
            string = (String)userAccount.getValue(PDFCWebGuiServerPlugin.USERFIELD_PDFCWEBGUIVIEWOPTIONS);
            try {
                if (string != null && (string2 = (String)(viewOptionsData = (ViewOptionsData)new Json().fromJson(string, ViewOptionsData.class)).get("configuration")) != null) {
                    gUID = new GUID(string2);
                }
            }
            catch (JsonException jsonException) {
                PDFCWebGuiServerPlugin.LOGGER.error((Throwable)jsonException);
            }
            if (gUID == null) {
                List list;
                viewOptionsData = (ProfilePersistenceManager)ServerPluginManager.getInstance().getSingleInstance(ProfilePersistenceManager.class);
                string2 = viewOptionsData.getProfile(UserManager.getInstance().getCurrentUserAccountID(), new GUID("textonly"));
                if (string2 != null) {
                    gUID = string2.getGUID();
                }
                if (!(list = viewOptionsData.getAllProfiles(UserManager.getInstance().getCurrentUserAccountID())).isEmpty()) {
                    gUID = ((ProfilePersistence)list.get(0)).getGUID();
                }
            }
        }
        userAccount = (PersistenceFactory)ServerPluginManager.getInstance().getSingleInstance(PersistenceFactory.class);
        string = new UserSession(UserManager.getInstance().getCurrentUserAccountID(), newComparisonData.pollingID);
        try {
            viewOptionsData = userAccount.createPersistence(GUID.generateNew(), (UserSession)string, null);
        }
        catch (QuotaExceededException quotaExceededException) {
            throw new ClientMessageException("Cannot create the comparison. " + quotaExceededException.getMessage());
        }
        catch (AccessDeniedException | IOException | IllegalArgumentException throwable) {
            PDFCCore.LOGGER_CORE.error(throwable);
            throw new ClientMessageException(StringFunctions.getUserFriendlyErrorMessage((Throwable)throwable));
        }
        try {
            viewOptionsData.notifyUserAccess((UserSession)string, UserState.IDLE);
            viewOptionsData.addObserver(new b((UserSession)string, (ComparePersistence)viewOptionsData));
            DefaultTimer.getInstance().schedule((DefaultTimerTask)new a((ComparePersistence)viewOptionsData, (UserSession)string), 10000L);
            viewOptionsData.setDocument(new URI("drive:" + driveEntry.getID()).toURL(), true, true);
            viewOptionsData.setDocument(new URI("drive:" + driveEntry2.getID()).toURL(), false, true);
        }
        catch (QuotaExceededException | IOException | URISyntaxException throwable) {
            throw new ClientMessageException("Cannot create the comparison. " + throwable.getMessage());
        }
        if (gUID != null) {
            viewOptionsData.setProfile(gUID);
        }
        if (newComparisonData.startComparison) {
            try {
                viewOptionsData.comparePersistence(CompareRunnerFactory.createRunner());
            }
            catch (QuotaExceededException | IOException | IllegalStateException throwable) {
                PDFCCore.LOGGER_CORE.error(throwable);
                throw new ClientMessageException(StringFunctions.getUserFriendlyErrorMessage((Throwable)throwable));
            }
        }
        return new CreateComparisonResponse(ProxyHttpServletRequest.getContextPath((HttpServletRequest)httpServletRequest) + "/comparison/" + String.valueOf(viewOptionsData.getGUID()));
    }

    @Nonnull
    protected Drive h() {
        return Drive.getInstance();
    }

    public static GUID a(DriveEntry driveEntry) throws IllegalArgumentException, DriveIOException, IOException {
        Object object;
        SourceProfile sourceProfile;
        if (!driveEntry.hasFeature(Content.class)) {
            throw new IllegalArgumentException(driveEntry.getName() + " is not a file");
        }
        @Nullable GUID gUID = UserManager.getInstance().getCurrentUserAccountID();
        if (gUID == null) {
            throw new IllegalArgumentException("Cannot import profile '" + driveEntry.getName() + "' as there is no user to import for.");
        }
        String string = driveEntry.getName();
        if (string.toLowerCase().endsWith(".xml")) {
            string = string.substring(0, string.length() - 4);
        }
        try (InputStream inputStream = ((Content)driveEntry.getFeature(Content.class)).getInputStream();){
            sourceProfile = new SourceProfile(inputStream, string);
        }
        inputStream = (ProfilePersistenceManager)ServerPluginManager.getInstance().getSingleInstance(ProfilePersistenceManager.class);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)sourceProfile.getProperties());
        properties.remove("PROFIL_NAME");
        properties.remove("PROFIL_DESCRIPTION");
        List list = inputStream.getAllProfiles(gUID);
        for (ProfilePersistence profilePersistence : list) {
            if (profilePersistence.getScope() != ProfilePersistence.SCOPE.USER) continue;
            object = new Properties();
            ((Properties)object).putAll((Map<?, ?>)profilePersistence.getProfile().getProperties());
            ((Properties)object).remove("PROFIL_NAME");
            ((Properties)object).remove("PROFIL_DESCRIPTION");
            if (!((Properties)object).equals(properties)) continue;
            return profilePersistence.getGUID();
        }
        String string2 = sourceProfile.getString("PROFIL_NAME");
        if (string2 != null && !inputStream.checkProfileName(gUID, string2)) {
            int n2 = 2;
            object = (String)string2 + " (" + n2 + ")";
            while (!inputStream.checkProfileName(gUID, (String)object) && n2 < 10000) {
                object = (String)string2 + " (" + ++n2 + ")";
            }
            sourceProfile.putValue("PROFIL_NAME", (String)object);
        }
        ProfilePersistence profilePersistence = inputStream.create(gUID, (DefaultProfile)sourceProfile);
        return profilePersistence.getGUID();
    }

    public /* synthetic */ Object invoke(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object object) throws IOException {
        return this.a(httpServletRequest, httpServletResponse, (NewComparisonData)object);
    }

    @JsonData
    public static class NewComparisonData {
        private String document1;
        private String document2;
        private String profile;
        private String pollingID;
        private boolean startComparison;
    }

    private static class b
    implements PersistenceObserver {
        private UserSession N;
        private ComparePersistence M;

        public b(UserSession userSession, ComparePersistence comparePersistence) {
            this.N = userSession;
            this.M = comparePersistence;
        }

        public boolean isValid() {
            return true;
        }

        public <T> void changed(PersistenceObserver.EventType<T> type, T eventData, boolean isPassive) {
            if (type == PersistenceObserver.EventType.VIEWERS_CHANGED) {
                List list = (List)eventData;
                for (UserSession userSession : list) {
                    if (userSession.getSessionID().equals(this.N.getSessionID()) || !this.M.getObservers().contains(this)) continue;
                    this.M.removeObserver((PersistenceObserver)this);
                    try {
                        this.M.notifyUserAccess(this.N, UserState.DISCONNECTED);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return;
                }
            }
        }
    }

    private static class a
    extends DefaultTimerTask {
        private ComparePersistence M;
        private UserSession N;

        public a(ComparePersistence comparePersistence, UserSession userSession) {
            this.M = comparePersistence;
            this.N = userSession;
        }

        public void runImpl() throws Throwable {
            this.M.notifyUserAccess(this.N, UserState.DISCONNECTED);
        }
    }
}

