/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.webgui.server.handler;

import com.inet.annotations.JsonData;
import com.inet.drive.api.DrivePermission;
import com.inet.pdfc.config.Settings;
import com.inet.pdfc.persistence.UserSettingsImpl;
import com.inet.pdfc.plugin.persistence.ComparePersistence;
import com.inet.pdfc.server.model.ExportSetting;
import com.inet.pdfc.webgui.server.handler.ExportBase;
import com.inet.permissions.AccessDeniedException;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.Base64;

public class ReportToDrive
extends ExportBase<ReportData> {
    public String getMethodName() {
        return "report.drive";
    }

    public short getMethodType() {
        return 1;
    }

    public ExportBase.ResponseData a(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ReportData reportData) throws IOException {
        if (!SystemPermissionChecker.checkAccess((Permission)DrivePermission.DRIVE_PERMISSION)) {
            throw new AccessDeniedException(DrivePermission.DRIVE_PERMISSION);
        }
        ComparePersistence comparePersistence = this.g(reportData.getGuid());
        UserAccount userAccount = UserManager.getInstance().getCurrentUserAccount();
        UserSettingsImpl userSettingsImpl = new UserSettingsImpl(userAccount != null ? userAccount.getID() : null);
        ExportSetting exportSetting = new ExportSetting();
        ExportSetting.ExportFormat exportFormat = ExportSetting.ExportFormat.getReportFormat((String)reportData.reportformat);
        exportSetting.setReportDetailed(reportData.adddetails);
        exportSetting.setReportAppendSetting(reportData.addprofile);
        exportSetting.setExportFormat(exportFormat);
        httpServletResponse.setContentType(exportFormat.getMimeType());
        if (exportFormat == ExportSetting.ExportFormat.REPORTPDF) {
            String string = reportData.password;
            String string2 = new String(Base64.getDecoder().decode(string));
            String string3 = URLDecoder.decode(string2, "UTF-8");
            exportSetting.setOwnerPass(string3);
        }
        return this.a(reportData, comparePersistence, (Settings)userSettingsImpl, exportSetting);
    }

    public /* synthetic */ Object invoke(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object object) throws IOException {
        return this.a(httpServletRequest, httpServletResponse, (ReportData)object);
    }

    @JsonData
    public static class ReportData
    extends ExportBase.ExportBaseData {
        private String reportformat;
        private String password;
        private boolean adddetails;
        private boolean addprofile;
    }
}

