/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.webgui;

import com.inet.classloader.I18nMessages;
import com.inet.classloader.translations.TranslationKey;
import com.inet.drive.api.DriveFileTypeHandler;
import com.inet.drive.webgui.pluginapi.ContextMenuExtension;
import com.inet.field.Field;
import com.inet.field.SelectOption;
import com.inet.field.SelectOptionResult;
import com.inet.file.CombinedFileDescription;
import com.inet.file.FileCombiner;
import com.inet.http.ClientMessageException;
import com.inet.http.PluginServlet;
import com.inet.http.websocket.WebSocketConnectionListener;
import com.inet.http.websocket.WebSocketEvent;
import com.inet.http.websocket.WebSocketEventHandler;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.util.StringFunctions;
import com.inet.logging.CoreLoggers;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import com.inet.pdfc.config.Settings;
import com.inet.pdfc.plugin.persistence.ComparePersistence;
import com.inet.pdfc.plugin.persistence.PersistenceFactory;
import com.inet.pdfc.plugin.persistence.UserObserver;
import com.inet.pdfc.plugin.persistence.UserPersistenceManager;
import com.inet.pdfc.plugin.persistence.UserSession;
import com.inet.pdfc.plugin.persistence.UserState;
import com.inet.pdfc.results.ResultModel;
import com.inet.pdfc.results.ResultModelUpdater;
import com.inet.pdfc.server.persistence.ContingentManager;
import com.inet.pdfc.webgui.server.drive.CreateComparisonHandler;
import com.inet.pdfc.webgui.server.events.f;
import com.inet.pdfc.webgui.server.events.g;
import com.inet.pdfc.webgui.server.events.h;
import com.inet.pdfc.webgui.server.events.i;
import com.inet.pdfc.webgui.server.events.j;
import com.inet.pdfc.webgui.server.events.l;
import com.inet.pdfc.webgui.server.events.m;
import com.inet.pdfc.webgui.server.events.n;
import com.inet.pdfc.webgui.server.events.o;
import com.inet.pdfc.webgui.server.events.p;
import com.inet.pdfc.webgui.server.events.q;
import com.inet.pdfc.webgui.server.events.r;
import com.inet.pdfc.webgui.server.handler.ImportProfileDrive;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionManager;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.plugin.HelpProviderContainer;
import com.inet.plugin.PluginInfo;
import com.inet.plugin.ServerPlugin;
import com.inet.plugin.ServerPluginManager;
import com.inet.plugin.help.HelpPage;
import com.inet.plugin.help.HelpProvider;
import com.inet.plugin.help.HelpProviderImpl;
import com.inet.remote.gui.IModule;
import com.inet.remote.gui.angular.ServiceMethod;
import com.inet.theme.server.ThemeResource;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.ui.Type;
import com.inet.usersandgroups.api.ui.fieldgroups.FieldPanelDefinition;
import com.inet.usersandgroups.api.ui.fields.FieldDefinition;
import com.inet.usersandgroups.api.ui.fields.SelectFieldValue;
import com.inet.usersandgroups.api.ui.fields.group.HintGroupFieldDefinition;
import com.inet.usersandgroups.api.ui.fields.group.SelectGroupFieldDefinition;
import com.inet.usersandgroups.api.ui.fields.user.HintUserFieldDefinition;
import com.inet.usersandgroups.api.ui.fields.user.SelectUserFieldDefinition;
import com.inet.usersandgroups.api.ui.fields.user.UF_Editability;
import com.inet.usersandgroups.api.ui.fields.user.UF_Visibility;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountType;
import com.inet.usersandgroups.api.user.UserEventAdapter;
import com.inet.usersandgroups.api.user.UserEventListener;
import com.inet.usersandgroups.api.user.UserManager;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

@PluginInfo(id="comparison.webgui", version="25.10.219", dependencies="remotegui;pdfc;pdfcserver;configuration", optionalDependencies="help;theme;setupwizard;drive", packages="com.inet.pdfc.webgui", group="applications;comparisons", icon="com/inet/pdfc/webgui/structure/pdfc_html_client_48.png")
public class PDFCWebGuiServerPlugin
implements ServerPlugin {
    public static final String PLUGIN_ID = "comparison.webgui";
    public static final String PDFC_APP_JS = "pdfc.app.js";
    public static final Logger LOGGER = LogManager.getLogger((String)"Comparison Web GUI");
    public static final Permission PERMISSION_COMAPREGUI = SystemPermissionManager.add((String)"comparisongui", (String)"comparison", null, (int)4100, (boolean)false, PDFCWebGuiServerPlugin.class);
    public static final UserField<String> USERFIELD_PDFCWEBGUIVIEWOPTIONS = new UserField<String>("pdfcwebgui.viewoptions"){

        public boolean isValueChangeLoggable() {
            return false;
        }
    };
    public static final UserField<Integer> USERFIELD_LIMIT_DIFFS = new UserField<Integer>("pdfcwebgui.difflimit", Integer.valueOf(1000)){};
    private static final I18nMessages a = new I18nMessages("com.inet.pdfc.webgui.structure.i18n.ConfigStructure", PDFCWebGuiServerPlugin.class);
    private static final I18nMessages b = new I18nMessages("com.inet.pdfc.webgui.client.i18n.LanguageResources", PDFCWebGuiServerPlugin.class);
    public static final I18nMessages MSG_SERVER = new I18nMessages("com.inet.pdfc.webgui.i18n.pdfc", PDFCWebGuiServerPlugin.class);
    private static final List<String> c = Arrays.asList("usersandgroups.pdfcwebgui.group.comparison");
    private com.inet.pdfc.webgui.server.websocket.c d;

    public void registerHelp(HelpProviderContainer container) {
        container.add((HelpProvider)new HelpProviderImpl(PLUGIN_ID, 2050, new Permission[]{PERMISSION_COMAPREGUI}){}, new String[0]);
        container.add((HelpProvider)new HelpProviderImpl("drive", 2051, new Permission[]{PERMISSION_COMAPREGUI}){}, new String[]{"drive"});
        container.add((HelpProvider)new HelpProviderImpl("usersandgroups", 9260, new Permission[]{UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER_ADMIN}){

            public boolean isVisible(@Nonnull HelpPage helpPage) {
                if (!super.isVisible(helpPage)) {
                    return c.contains(helpPage.getKey());
                }
                return true;
            }
        }, new String[]{"usersandgroupsmanager"});
    }

    public void registerExtension(ServerPluginManager spm) {
        CoreLoggers.addLoggers((String[])new String[]{"Comparison Web GUI"});
        DynamicExtensionManager dynamicExtensionManager = DynamicExtensionManager.getInstance();
        spm.register(UserField.class, USERFIELD_PDFCWEBGUIVIEWOPTIONS);
        spm.register(UserField.class, USERFIELD_LIMIT_DIFFS);
        spm.register(FieldPanelDefinition.class, (Object)new a(UserAccountType.Standard));
        spm.register(FieldPanelDefinition.class, (Object)new a(UserAccountType.Guest));
        dynamicExtensionManager.register(FieldDefinition.class, (Object)new c("pdfcwebgui.group.comparison", USERFIELD_LIMIT_DIFFS, 1, USERFIELD_LIMIT_DIFFS.getKey(), false, false, 100, 200, 500, 1000, 2000));
        spm.register(FieldPanelDefinition.class, (Object)new d(UsersAndGroups.GROUPTYPE_AUTH.getName()));
        spm.register(FieldPanelDefinition.class, (Object)new d(UsersAndGroups.GROUPTYPE_STANDARD.getName()));
        dynamicExtensionManager.register(FieldDefinition.class, (Object)new HintGroupFieldDefinition("pdfcwebgui.group.quota.group", 90){

            public String getHint() {
                return a.getMsg("pdfcwebgui.group.quota.hint", new Object[0]);
            }

            public boolean showHintLabel() {
                return true;
            }
        });
        dynamicExtensionManager.register(FieldDefinition.class, (Object)new b("pdfcwebgui.group.quota.group", (Field<? extends Number>)ContingentManager.GROUP_QUOTA_COMPARISONS, 100, () -> a.getMsg("pdfcwebgui.user.quota.comparisons", new Object[0]), true, true, 3, 10, 50, 100));
        dynamicExtensionManager.register(FieldDefinition.class, (Object)new b("pdfcwebgui.group.quota.group", (Field<? extends Number>)ContingentManager.GROUP_QUOTA_HDD, 110, () -> a.getMsg("pdfcwebgui.user.quota.hdd", new Object[0]), true, true, 10, 50, 100, 1000));
        dynamicExtensionManager.register(FieldDefinition.class, (Object)new b("pdfcwebgui.group.quota.group", (Field<? extends Number>)ContingentManager.GROUP_QUOTA_PAGES, 120, () -> a.getMsg("pdfcwebgui.user.quota.pages", new Object[0]), true, true, 10, 50, 100, 500));
        final c c2 = new c("pdfcwebgui.group.comparison", (UserField<Integer>)ContingentManager.USER_QUOTA_COMPARISONS, 100, "pdfcwebgui.user.quota.comparisons", true, true, 3, 10, 50, 100);
        dynamicExtensionManager.register(FieldDefinition.class, (Object)c2);
        final c c3 = new c("pdfcwebgui.group.comparison", (UserField<Integer>)ContingentManager.USER_QUOTA_HDD, 110, "pdfcwebgui.user.quota.hdd", true, true, 10, 50, 100, 1000);
        dynamicExtensionManager.register(FieldDefinition.class, (Object)c3);
        final c c4 = new c("pdfcwebgui.group.comparison", (UserField<Integer>)ContingentManager.USER_QUOTA_PAGES, 120, "pdfcwebgui.user.quota.pages", true, true, 10, 50, 100, 500);
        dynamicExtensionManager.register(FieldDefinition.class, (Object)c4);
        dynamicExtensionManager.register(FieldDefinition.class, (Object)new HintUserFieldDefinition("pdfcwebgui.group.comparison", -10){

            public String getHint() {
                return a.getMsg("pdfcwebgui.user.quota.hint", new Object[0]);
            }

            public boolean showHintLabel() {
                return true;
            }

            public boolean isAvailable(UserAccount userAccount) {
                return c2.isAvailable(userAccount) || c3.isAvailable(userAccount) || c4.isAvailable(userAccount);
            }

            public int getPriority() {
                int n2 = Math.min(c2.getPriority(), c3.getPriority());
                n2 = Math.min(n2, c4.getPriority());
                return n2 - 1;
            }
        });
        this.d = new com.inet.pdfc.webgui.server.websocket.c();
        spm.register(WebSocketEvent.class, (Object)new q(this.d));
        spm.register(WebSocketEvent.class, (Object)new com.inet.pdfc.webgui.server.events.b(this.d));
        spm.register(WebSocketEvent.class, (Object)new g(this.d));
        spm.register(WebSocketEvent.class, (Object)new com.inet.pdfc.webgui.server.events.d(this.d));
        spm.register(WebSocketEvent.class, (Object)new o());
        spm.register(WebSocketEvent.class, (Object)new m());
        spm.register(WebSocketEvent.class, (Object)new n());
        spm.register(WebSocketEvent.class, (Object)new r());
        spm.register(WebSocketEvent.class, (Object)new j());
        spm.register(WebSocketEvent.class, (Object)new h());
        spm.register(WebSocketEvent.class, (Object)new i());
        spm.register(WebSocketEvent.class, (Object)new l());
        WebSocketEventHandler.getInstance().addConnectionListener(new WebSocketConnectionListener(){

            public void connectionOpened(String pollingID) {
            }

            public void connectionClosed(String pollingID) {
                f f2 = PDFCWebGuiServerPlugin.this.d.j(pollingID);
                if (f2 == null) {
                    return;
                }
                GUID gUID = f2.t();
                PersistenceFactory persistenceFactory = (PersistenceFactory)ServerPluginManager.getInstance().getSingleInstance(PersistenceFactory.class);
                try {
                    ComparePersistence comparePersistence = persistenceFactory.getPersistenceSystemAccess(gUID);
                    if (comparePersistence != null) {
                        Object object;
                        PDFCWebGuiServerPlugin.this.d.c(pollingID, comparePersistence);
                        p p2 = PDFCWebGuiServerPlugin.this.d.k(pollingID);
                        if (p2 != null) {
                            object = (UserPersistenceManager)ServerPluginManager.getInstance().getSingleInstance(UserPersistenceManager.class);
                            object.removeObserver(p2.E(), (UserObserver)p2);
                        }
                        if ((object = PDFCWebGuiServerPlugin.this.d.k(pollingID)) != null) {
                            comparePersistence.notifyUserAccess(new UserSession(((p)object).E(), pollingID), UserState.DISCONNECTED);
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                PDFCWebGuiServerPlugin.this.d.l(pollingID);
                com.inet.pdfc.webgui.server.websocket.b.J().i(pollingID);
            }
        });
        spm.register(IModule.class, (Object)new com.inet.pdfc.webgui.b());
        spm.register(PluginServlet.class, (Object)new com.inet.pdfc.webgui.a(this.d));
        FileCombiner.CombinedFile combinedFile = new FileCombiner.CombinedFile("application/x-javascript; charset=utf-8", new URL[0]);
        combinedFile.add(PDFCWebGuiServerPlugin.class, "client/js/app.js");
        combinedFile.add(PDFCWebGuiServerPlugin.class, "client/js/controller.js");
        combinedFile.add(PDFCWebGuiServerPlugin.class, "client/js/scroller.js");
        combinedFile.add(PDFCWebGuiServerPlugin.class, "client/js/publishdialog.js");
        combinedFile.add(PDFCWebGuiServerPlugin.class, "client/js/visibilitysettings.js");
        combinedFile.add(PDFCWebGuiServerPlugin.class, "client/js/compare.js");
        combinedFile.add(PDFCWebGuiServerPlugin.class, "client/js/factory.js");
        combinedFile.add(PDFCWebGuiServerPlugin.class, "client/js/model.js");
        combinedFile.add(PDFCWebGuiServerPlugin.class, "client/js/pdfcconfig.js");
        combinedFile.add(PDFCWebGuiServerPlugin.class, "client/js/export.js");
        combinedFile.add(PDFCWebGuiServerPlugin.class, "client/js/report.js");
        combinedFile.add(PDFCWebGuiServerPlugin.class, "client/js/profil.js");
        combinedFile.add(PDFCWebGuiServerPlugin.class, "client/js/mycomparisons.js");
        combinedFile.add(PDFCWebGuiServerPlugin.class, "client/js/directives/dropzone.js");
        combinedFile.add(PDFCWebGuiServerPlugin.class, "client/js/directives/descriptionarea.js");
        combinedFile.add(PDFCWebGuiServerPlugin.class, "client/js/directives/passwordpanel.js");
        combinedFile.add(PDFCWebGuiServerPlugin.class, "client/js/directives/multipasswordpanel.js");
        combinedFile.add(PDFCWebGuiServerPlugin.class, "client/js/directives/userlist.js");
        combinedFile.add(PDFCWebGuiServerPlugin.class, "client/js/directives/zoomer.js");
        combinedFile.add(PDFCWebGuiServerPlugin.class, "client/js/directives/contingent.js");
        combinedFile.add(PDFCWebGuiServerPlugin.class, "client/js/directives/searchcomponent.js");
        combinedFile.add(PDFCWebGuiServerPlugin.class, "client/js/directives/profileentry.js");
        combinedFile.add(PDFCWebGuiServerPlugin.class, "client/js/directives/publishprofiledialog.js");
        combinedFile.addMessages(b);
        spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", PDFC_APP_JS, combinedFile));
        if (spm.isPluginLoaded("theme")) {
            spm.register(ThemeResource.class, (Object)new ThemeResource(100, "remotegui", this.getClass().getResource("client/css/pdfc.less")));
            spm.register(ThemeResource.class, (Object)new ThemeResource(100, "remotegui", this.getClass().getResource("client/css/sprites.less")));
        }
        FileCombiner.CombinedFile combinedFile2 = new FileCombiner.CombinedFile("text/css; charset=utf-8", new URL[0]);
        combinedFile2.add(PDFCWebGuiServerPlugin.class, "client/css/pdfc.css");
        spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", 100, "defaulttheme.css", combinedFile2));
        spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", 201, "publishdialog.html", new FileCombiner.CombinedFile("text/html; charset=utf-8", new URL[]{this.getClass().getResource("client/publishdialog.html")})));
        spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", 203, "export.html", new FileCombiner.CombinedFile("text/html; charset=utf-8", new URL[]{this.getClass().getResource("client/export.html")})));
        spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", 204, "report.html", new FileCombiner.CombinedFile("text/html; charset=utf-8", new URL[]{this.getClass().getResource("client/report.html")})));
        spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", 205, "visibilitysettings.html", new FileCombiner.CombinedFile("text/html; charset=utf-8", new URL[]{this.getClass().getResource("client/visibilitysettings.html")})));
        spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", 206, "profil.html", new FileCombiner.CombinedFile("text/html; charset=utf-8", new URL[]{this.getClass().getResource("client/profil.html")})));
        spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", 207, "mycomparisons.html", new FileCombiner.CombinedFile("text/html; charset=utf-8", new URL[]{this.getClass().getResource("client/mycomparisons.html")})));
        if (spm.isPluginLoaded("drive")) {
            this.a(spm);
        }
    }

    private void a(ServerPluginManager serverPluginManager) {
        FileCombiner.CombinedFile combinedFile = new FileCombiner.CombinedFile("application/x-javascript; charset=utf-8", new URL[0]);
        combinedFile.add(this.getClass(), "client/drive/contextmenuextension.js");
        combinedFile.addMessages(new I18nMessages("com.inet.pdfc.webgui.client.drive.i18n.LanguageResources", PDFCWebGuiServerPlugin.class));
        serverPluginManager.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", "drive.js", combinedFile));
        serverPluginManager.register(ServiceMethod.class, (Object)new CreateComparisonHandler());
        serverPluginManager.register(ServiceMethod.class, (Object)new ImportProfileDrive());
        serverPluginManager.register(ContextMenuExtension.class, (Object)new com.inet.pdfc.webgui.server.drive.a());
        serverPluginManager.register(ContextMenuExtension.class, (Object)new com.inet.pdfc.webgui.server.drive.c());
        serverPluginManager.register(DriveFileTypeHandler.class, (Object)new com.inet.pdfc.webgui.server.drive.b());
        serverPluginManager.register(DriveFileTypeHandler.class, (Object)new com.inet.pdfc.webgui.server.drive.d());
    }

    public void init(ServerPluginManager spm) {
        ForkJoinPool.commonPool().execute(() -> {
            UserManager.getRecoveryEnabledInstance().registerListener((UserEventListener)new UserEventAdapter(){

                public void userAccountUpdated(@Nonnull UserAccount userAccountBefore, @Nonnull UserAccount userAccountAfter) {
                    Integer n2;
                    GUID gUID = userAccountAfter.getID();
                    if (!PDFCWebGuiServerPlugin.this.d.i(gUID)) {
                        return;
                    }
                    Integer n3 = (Integer)userAccountBefore.getValue(USERFIELD_LIMIT_DIFFS);
                    if (Objects.equals(n3, n2 = (Integer)userAccountAfter.getValue(USERFIELD_LIMIT_DIFFS))) {
                        return;
                    }
                    Map<String, GUID> map = PDFCWebGuiServerPlugin.this.d.j(gUID);
                    if (map.size() > 0) {
                        PersistenceFactory persistenceFactory = (PersistenceFactory)ServerPluginManager.getInstance().getSingleInstance(PersistenceFactory.class);
                        for (Map.Entry<String, GUID> entry : map.entrySet()) {
                            try {
                                ComparePersistence comparePersistence = persistenceFactory.getPersistenceSystemAccess(entry.getValue());
                                ResultModel resultModel = comparePersistence.getResult();
                                if (resultModel == null || !Objects.equals(gUID, comparePersistence.getOwnerID())) continue;
                                Settings settings = resultModel.getSettings();
                                settings.setSetting((Object)n2, ResultModelUpdater.DIFF_LIMIT.name());
                                resultModel.setSetting(settings);
                            }
                            catch (IOException iOException) {
                                LOGGER.error((Throwable)iOException);
                            }
                        }
                    }
                }
            });
            ((PersistenceFactory)ServerPluginManager.getInstance().getSingleInstance(PersistenceFactory.class)).addGlobalObserver((PersistenceFactory.GlobalPersistenceObsever)com.inet.pdfc.webgui.server.websocket.b.J());
        });
    }

    public void reset() {
    }

    public void restart() {
    }

    private static SelectOptionResult a(String string, int[] nArray, boolean bl) {
        List<Object> list = new ArrayList<SelectOption>();
        if (bl) {
            list.add(new SelectOption("", a.getMsg("pdfcwebgui.difflimit.undefined", new Object[0])));
        }
        for (int n2 : nArray) {
            list.add(new SelectOption(Integer.toString(n2), Integer.toString(n2)));
        }
        list.add(new SelectOption("-1", a.getMsg("pdfcwebgui.difflimit.unlimited", new Object[0])));
        boolean bl2 = list.stream().filter(selectOption -> selectOption.getLabel().equals(string) || selectOption.getValue().equals(string)).findFirst().isPresent();
        if (!bl2) {
            try {
                int n3 = Integer.parseInt(string);
                if (n3 < 0) {
                    list.clear();
                    list.add(new SelectOption(string, a.getMsg("pdfcwebgui.difflimit.unlimited", new Object[0])));
                    return new SelectOptionResult(list.size(), list);
                }
            }
            catch (NumberFormatException numberFormatException) {
                return new SelectOptionResult(list.size(), list);
            }
            list.add(0, new SelectOption(string, string));
        }
        if (!string.isEmpty()) {
            list = list.stream().filter(selectOption -> selectOption.getLabel().startsWith(string) || selectOption.getValue().startsWith(string)).collect(Collectors.toList());
        }
        return new SelectOptionResult(list.size(), list);
    }

    private static Integer a(String string, String string2) {
        if (StringFunctions.isEmpty((String)string)) {
            return null;
        }
        SelectOption selectOption = (SelectOption)new Json().fromJson(string, SelectOption.class);
        try {
            if (StringFunctions.isEmpty((String)selectOption.getValue())) {
                return null;
            }
            Integer n2 = Integer.valueOf(selectOption.getValue());
            return n2 >= 0 ? n2 : Integer.valueOf(-1);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                new BigDecimal(selectOption.getValue());
                throw new ClientMessageException(a.getMsg("pdfcwebgui.difflimit.toolarge", new Object[]{string2, selectOption.getValue()}));
            }
            catch (NumberFormatException numberFormatException2) {
                throw new ClientMessageException(a.getMsg("pdfcwebgui.difflimit.formaterror", new Object[]{string2, selectOption.getValue()}));
            }
        }
    }

    static class a
    extends FieldPanelDefinition {
        public a(UserAccountType userAccountType) {
            super(Type.user, userAccountType.name(), "pdfcwebgui.group.comparison", 150, true, false);
        }

        public String getDisplayName() {
            return a.getMsg("pdfcwebgui.group.comparison", new Object[0]);
        }

        public String getEmptyHint() {
            return a.getMsg("pdfcwebgui.group.comparison.empty", new Object[0]);
        }

        public boolean isVisibleInPreview() {
            return true;
        }
    }

    static class c
    extends SelectUserFieldDefinition<Integer> {
        private int[] i;
        private String m;
        private boolean l;

        private c(String string, UserField<Integer> userField, int n2, String string2, boolean bl, boolean bl2, int ... nArray) {
            super(string, userField, n2);
            this.m = string2;
            this.l = bl2;
            Arrays.sort(nArray);
            this.i = nArray;
            if (bl) {
                this.setVisibility(UF_Visibility.VISIBLE_ONLY_FOR_USER_MANAGER_ADMIN);
                this.setEditability(UF_Editability.ONLY_USER_MANAGER_CAN_CHANGE);
            }
        }

        public boolean allowsCustomValue() {
            return true;
        }

        public SelectFieldValue getFieldValue(UserAccount userAccount) {
            SelectFieldValue selectFieldValue = super.getFieldValue(userAccount);
            String string = selectFieldValue.getValue();
            if (string != null) {
                try {
                    string = ((SelectOption)new Json().fromJson(string, SelectOption.class)).getValue();
                }
                catch (RuntimeException runtimeException) {
                    LOGGER.error((Throwable)runtimeException);
                }
            }
            boolean bl = false;
            if (string != null) {
                bl = this.l ? !string.isEmpty() : !string.startsWith("-");
            }
            selectFieldValue.setVisibleInPreview(bl);
            selectFieldValue.setEnabled(this.isEnabled());
            return selectFieldValue;
        }

        public SelectOption getValue(UserAccount userAccount) {
            Integer n2 = null;
            UserField userField = UserManager.getRecoveryEnabledInstance().getField(this.getFieldKey());
            if (userAccount != null) {
                n2 = (Integer)userAccount.getValue(userField);
            }
            if (n2 == null) {
                if (this.l) {
                    return new SelectOption("", a.getMsg("pdfcwebgui.difflimit.undefined", new Object[0]));
                }
                n2 = (Integer)userField.getDefaultValue();
                if (n2 != null) {
                    return new SelectOption(n2.toString(), n2.toString());
                }
                return new SelectOption("-1", a.getMsg("pdfcwebgui.difflimit.unlimited", new Object[0]));
            }
            if (n2 < 0) {
                return new SelectOption("-1", a.getMsg("pdfcwebgui.difflimit.unlimited", new Object[0]));
            }
            return new SelectOption(n2.toString(), n2.toString());
        }

        public SelectOptionResult getOptions(UserAccount userAccount, String searchTerm, int currentSize, int chunkSize) {
            return PDFCWebGuiServerPlugin.a(searchTerm, this.i, this.l);
        }

        public Integer a(String string) {
            return PDFCWebGuiServerPlugin.a(string, this.getLabel());
        }

        public String getLabel() {
            return a.getMsg(this.m, new Object[0]);
        }

        public String getDescription() {
            return a.getMsgAllowMissing(this.m + ".description", new Object[0]);
        }

        public TranslationKey getLabelTranslationKey() {
            return new TranslationKey(PDFCWebGuiServerPlugin.PLUGIN_ID, a.getBundle().getBaseBundleName(), "en", this.m);
        }

        public /* synthetic */ Object convertFromString(String string) {
            return this.a(string);
        }
    }

    static class d
    extends FieldPanelDefinition {
        public d(String string) {
            super(Type.group, string, "pdfcwebgui.group.quota.group", 150, true, true);
        }

        public String getDisplayName() {
            return a.getMsg("pdfcwebgui.group.quota", new Object[0]);
        }

        public String getEmptyHint() {
            return a.getMsg("pdfcwebgui.group.quota.empty", new Object[0]);
        }

        public boolean isVisibleInPreview() {
            return true;
        }
    }

    static class b
    extends SelectGroupFieldDefinition<Integer> {
        private int[] i;
        private Supplier<String> j;
        private boolean k;
        private boolean l;

        private b(String string, Field<? extends Number> field, int n2, Supplier<String> supplier, boolean bl, boolean bl2, int ... nArray) {
            super(string, field.getKey(), n2);
            this.j = supplier;
            this.k = bl;
            this.l = bl2;
            Arrays.sort(nArray);
            this.i = nArray;
        }

        public boolean allowsCustomValue() {
            return true;
        }

        public SelectFieldValue getFieldValue(UserGroupInfo userGroup) {
            SelectFieldValue selectFieldValue = super.getFieldValue(userGroup);
            String string = selectFieldValue.getValue();
            if (string != null) {
                try {
                    string = ((SelectOption)new Json().fromJson(string, SelectOption.class)).getValue();
                }
                catch (RuntimeException runtimeException) {
                    LOGGER.error((Throwable)runtimeException);
                }
            }
            selectFieldValue.setVisibleInPreview(this.k && string != null && !string.isEmpty());
            return selectFieldValue;
        }

        public SelectOption getValue(UserGroupInfo userGroup) {
            Integer n2 = null;
            if (userGroup != null) {
                n2 = (Integer)userGroup.getValue(UserGroupManager.getRecoveryEnabledInstance().getField(this.getFieldKey()));
            }
            if (n2 == null && this.l) {
                return new SelectOption("", a.getMsg("pdfcwebgui.difflimit.undefined", new Object[0]));
            }
            if (n2 == null || n2 < 0) {
                return new SelectOption("-1", a.getMsg("pdfcwebgui.difflimit.unlimited", new Object[0]));
            }
            return new SelectOption(n2.toString(), n2.toString());
        }

        public SelectOptionResult getOptions(UserGroupInfo userGroup, String searchTerm, int currentSize, int chunkSize) {
            return PDFCWebGuiServerPlugin.a(searchTerm, this.i, this.l);
        }

        public Integer a(String string) {
            return PDFCWebGuiServerPlugin.a(string, this.getLabel());
        }

        public String getLabel() {
            return this.j.get();
        }

        public /* synthetic */ Object convertFromString(String string) {
            return this.a(string);
        }
    }
}

