/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.webgui.server.handler;

import com.inet.annotations.JsonData;
import com.inet.drive.api.DataEntry;
import com.inet.drive.api.Drive;
import com.inet.drive.api.DriveEntry;
import com.inet.drive.api.DriveUtils;
import com.inet.drive.api.feature.Content;
import com.inet.error.ErrorCode;
import com.inet.id.GUID;
import com.inet.pdfc.config.Settings;
import com.inet.pdfc.plugin.persistence.ComparePersistence;
import com.inet.pdfc.plugin.persistence.PersistenceFactory;
import com.inet.pdfc.results.ResultModel;
import com.inet.pdfc.server.ServerUtil;
import com.inet.pdfc.server.model.ExportSetting;
import com.inet.pdfc.webgui.server.a;
import com.inet.plugin.ServerPluginManager;
import com.inet.remote.gui.angular.ServiceMethod;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class ExportBase<T extends ExportBaseData>
extends ServiceMethod<T, ResponseData> {
    protected boolean a(@Nonnull String string, boolean bl, @Nonnull Consumer<OutputStream> consumer) throws IOException {
        Object object;
        DriveEntry driveEntry;
        if (string.toLowerCase().startsWith("drive:")) {
            string = string.substring(6);
            string = URLDecoder.decode(string, StandardCharsets.UTF_8);
        }
        if ((driveEntry = Drive.getInstance().resolve(string)) == null || !driveEntry.exists()) {
            int n2 = string.lastIndexOf(47);
            if (n2 < 0) {
                object = string;
                string = "/";
            } else {
                object = string.substring(n2 + 1);
                string = string.substring(0, n2);
            }
            driveEntry = DriveUtils.getOrCreateChild((Drive)Drive.getInstance(), (String)string, (DataEntry)new DataEntry((String)object, new byte[0]));
        } else if (!bl) {
            return true;
        }
        if (!Drive.getInstance().getPermissionChecker().hasPermission(driveEntry.getID(), false, new String[]{"EDITOR"})) {
            throw new a(com.inet.pdfc.webgui.i18n.a.G, string);
        }
        Content content = (Content)driveEntry.getFeature(Content.class);
        if (content == null) {
            throw new a(com.inet.pdfc.webgui.i18n.a.F, string);
        }
        object = content.getOutputStream();
        try {
            consumer.accept((OutputStream)object);
        }
        finally {
            if (object != null) {
                ((OutputStream)object).close();
            }
        }
        return false;
    }

    @Nonnull
    protected ComparePersistence g(@Nonnull String string) throws IOException {
        GUID gUID;
        try {
            gUID = GUID.valueOf((String)string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new a(com.inet.pdfc.webgui.i18n.a.n, new Object[0]);
        }
        if (gUID == null) {
            throw new a(com.inet.pdfc.webgui.i18n.a.o, "<none>");
        }
        PersistenceFactory persistenceFactory = (PersistenceFactory)ServerPluginManager.getInstance().getSingleInstance(PersistenceFactory.class);
        ComparePersistence comparePersistence = persistenceFactory.getPersistence(gUID);
        if (comparePersistence == null) {
            throw new a(com.inet.pdfc.webgui.i18n.a.o, gUID);
        }
        ResultModel resultModel = comparePersistence.getResult();
        if (resultModel == null) {
            throw new a(com.inet.pdfc.webgui.i18n.a.p, gUID);
        }
        return comparePersistence;
    }

    @Nullable
    protected ResponseData a(@Nonnull ExportBaseData exportBaseData, @Nonnull ComparePersistence comparePersistence, @Nonnull Settings settings, @Nonnull ExportSetting exportSetting) throws IOException {
        boolean bl = this.a(exportBaseData.getDrivePath(), exportBaseData.isOverwrite(), outputStream -> {
            try {
                ServerUtil.exportComparePersistence((ComparePersistence)comparePersistence, (OutputStream)outputStream, (ExportSetting)exportSetting, (Settings)settings);
            }
            catch (IOException iOException) {
                ErrorCode.throwAny((Throwable)iOException);
            }
        });
        return bl ? new ResponseData() : null;
    }

    @JsonData
    public static class ExportBaseData {
        private String drivePath;
        private String guid;
        private boolean overwrite = false;

        String getGuid() {
            return this.guid;
        }

        String getDrivePath() {
            return this.drivePath;
        }

        boolean isOverwrite() {
            return this.overwrite;
        }
    }

    @JsonData
    public static class ResponseData {
        private boolean alreadyExists = true;
    }
}

