/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.webgui.server.handler;

import com.inet.annotations.JsonData;
import com.inet.drive.api.Drive;
import com.inet.drive.api.DriveEntry;
import com.inet.drive.api.feature.Content;
import com.inet.drive.webgui.pluginapi.ResolveRenameHandler;
import com.inet.id.GUID;
import com.inet.pdfc.config.DefaultProfile;
import com.inet.pdfc.config.SourceProfile;
import com.inet.pdfc.plugin.PluginManager;
import com.inet.pdfc.plugin.persistence.ProfilePersistenceManager;
import com.inet.pdfc.webgui.PDFCWebGuiServerPlugin;
import com.inet.pdfc.webgui.server.a;
import com.inet.pdfc.webgui.server.model.ImportProfileDriveRequest;
import com.inet.remote.gui.angular.ServiceMethod;
import com.inet.usersandgroups.api.user.UserManager;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ImportProfileDrive
extends ServiceMethod<ImportProfileDriveRequest, Response> {
    public String getMethodName() {
        return "import.profile.drive";
    }

    public short getMethodType() {
        return 1;
    }

    public Response a(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, ImportProfileDriveRequest importProfileDriveRequest) throws IOException {
        DriveEntry driveEntry;
        GUID gUID = importProfileDriveRequest.getGuid();
        String string = importProfileDriveRequest.getDrivePath();
        if (string == null) {
            throw new a(com.inet.pdfc.webgui.i18n.a.A, new Object[0]);
        }
        if (string.toLowerCase().startsWith("drive:")) {
            string = string.substring(6);
            string = URLDecoder.decode(string, StandardCharsets.UTF_8);
        }
        if ((driveEntry = Drive.getInstance().resolve(string)) == null || !driveEntry.exists()) {
            throw new a(com.inet.pdfc.webgui.i18n.a.H, string);
        }
        @Nullable GUID gUID2 = UserManager.getInstance().getCurrentUserAccountID();
        @Nullable Content content = (Content)driveEntry.getFeature(Content.class);
        if (content == null || gUID2 == null) {
            throw new a(com.inet.pdfc.webgui.i18n.a.A, string);
        }
        String string2 = importProfileDriveRequest.getName();
        @Nonnull ProfilePersistenceManager profilePersistenceManager = (ProfilePersistenceManager)PluginManager.getSingleInstance(ProfilePersistenceManager.class);
        try (InputStream inputStream = content.getInputStream();){
            if (gUID == null) {
                if (string2 == null || string2.isBlank()) {
                    string2 = driveEntry.getName();
                }
                HashSet<String> hashSet = new HashSet<String>();
                while (!profilePersistenceManager.checkProfileName(gUID2, string2)) {
                    hashSet.add(string2);
                    string2 = ResolveRenameHandler.getRenameName((String)string2, hashSet);
                }
                SourceProfile sourceProfile = new SourceProfile(inputStream, string2);
                sourceProfile.putValue("PROFIL_NAME", string2);
                profilePersistenceManager.create(gUID2, (DefaultProfile)sourceProfile);
            } else {
                SourceProfile sourceProfile = new SourceProfile(inputStream, string2);
                boolean bl = profilePersistenceManager.update(gUID, (DefaultProfile)sourceProfile, gUID2);
                if (!bl) {
                    throw new a(com.inet.pdfc.webgui.i18n.a.A, new Object[0]);
                }
            }
        }
        catch (Exception exception) {
            PDFCWebGuiServerPlugin.LOGGER.error((Throwable)exception);
            throw new a(com.inet.pdfc.webgui.i18n.a.B, exception.getLocalizedMessage());
        }
        return new Response(string2);
    }

    public /* synthetic */ Object invoke(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, Object object) throws IOException {
        return this.a(httpServletRequest, httpServletResponse, (ImportProfileDriveRequest)object);
    }

    @JsonData
    public static class Response {
        private String profileName;

        public Response(String profileName) {
            this.profileName = profileName;
        }

        public String getProfileName() {
            return this.profileName;
        }
    }
}

