/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.webgui.server.events.data;

import com.inet.annotations.JsonData;
import com.inet.http.servlet.ClientLocale;
import com.inet.pdfc.generator.filter.AnnotationTreeEntry;
import com.inet.pdfc.generator.message.HighlightData;
import java.awt.Color;
import java.awt.Rectangle;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

@JsonData
public class AnnotationsPageData {
    public static final String EVENT_NAME = "pageannotations";
    private static final Set<String> COMMENT_TYPES = Arrays.asList("Text", "Link", "FreeText", "Line", "Square", "Circle", "Polygon", "PolyLine", "Highlight", "Underline", "Squiggly", "StrikeOut", "Stamp", "Caret", "Ink", "Popup", "FileAttachment", "Sound", "Movie", "Widget", "Screen", "PrinterMark", "TrapNet", "Watermark", "3D").stream().collect(Collectors.toUnmodifiableSet());
    private int pageIndex;
    private boolean first;
    private List<CommentData> annotations;

    public AnnotationsPageData(int pageIndex, boolean first, List<HighlightData.Highlight> annotations) {
        this.pageIndex = pageIndex;
        this.first = first;
        List list = AnnotationTreeEntry.convertHighlights(annotations, (int)pageIndex, (boolean)first);
        this.annotations = list.stream().map(a2 -> new CommentData((AnnotationTreeEntry)a2)).collect(Collectors.toList());
    }

    public List<CommentData> getAnnotations() {
        return this.annotations;
    }

    public static List<HighlightData.Highlight> filter(List<HighlightData.Highlight> highlights) {
        if (highlights == null || highlights.isEmpty()) {
            return null;
        }
        ArrayList<HighlightData.Highlight> arrayList = null;
        for (HighlightData.Highlight highlight : highlights) {
            String string;
            if (!highlight.isAnnotation() || (string = highlight.getCaption()) == null || string.isEmpty() || COMMENT_TYPES.contains(string)) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<HighlightData.Highlight>();
            }
            arrayList.add(highlight);
        }
        return arrayList;
    }

    @JsonData
    public static class CommentData {
        private int x;
        private int y;
        private int width;
        private int height;
        private CommentEntry comment;

        private CommentData(AnnotationTreeEntry source) {
            Rectangle rectangle = source.getHighlight().getBounds();
            this.x = rectangle.x;
            this.y = rectangle.y;
            this.width = rectangle.width;
            this.height = rectangle.height;
            this.comment = this.convert(source);
        }

        private CommentEntry convert(AnnotationTreeEntry entry) {
            String string;
            Date date = entry.getHighlight().getCreationDate();
            String string2 = date != null && date.getTime() != 0L ? DateFormat.getDateInstance(2, ClientLocale.getThreadLocale()).format(date) : "";
            Color color = entry.getColor();
            String string3 = null;
            if (!(color == null || entry.getParent() != null && Objects.equals(color, entry.getParent().getColor()))) {
                string3 = "rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")";
            }
            CommentEntry commentEntry = new CommentEntry((string = entry.getAuthor()) != null ? string : "", entry.getCaption(), string2, string3);
            if (entry.getChildren() != null) {
                commentEntry.children = new ArrayList<CommentEntry>();
                for (AnnotationTreeEntry annotationTreeEntry : entry.getChildren()) {
                    commentEntry.children.add(this.convert(annotationTreeEntry));
                }
            }
            return commentEntry;
        }

        public Rectangle getBounds() {
            return new Rectangle(this.x, this.y, this.width, this.height);
        }

        public CommentEntry getComment() {
            return this.comment;
        }
    }

    @JsonData
    public static class CommentEntry {
        private String author;
        private String caption;
        private String date;
        private String color;
        private List<CommentEntry> children;

        public CommentEntry(String author, String caption, String date, String color) {
            this.author = author;
            this.caption = caption;
            this.date = date;
            this.color = color;
        }

        public String getAuthor() {
            return this.author;
        }

        public String getCaption() {
            return this.caption;
        }

        public String getDate() {
            return this.date;
        }

        public List<CommentEntry> getChildren() {
            return this.children;
        }
    }
}

