/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.webgui.server.model;

import com.inet.annotations.JsonData;
import com.inet.lib.util.StringFunctions;
import com.inet.pdfc.generator.model.text.TextModuleUtils;
import com.inet.pdfc.textselection.TextInfo;
import com.inet.pdfc.textselection.TextInfoFactory;
import com.inet.pdfc.textselection.TextInfoImpl;
import com.inet.pdfc.webgui.server.events.data.TextSelectionData;
import com.inet.pdfc.webgui.server.events.data.TextStyle;
import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

@JsonData
public class LoadPageTextSelectionResponse {
    private ArrayList<TextSelectionData> textSelectionData = new ArrayList();
    private boolean firstDocument;
    private int pageIndex;

    public List<TextSelectionData> getTextSelectionData() {
        return this.textSelectionData;
    }

    private LoadPageTextSelectionResponse() {
    }

    public LoadPageTextSelectionResponse(List<TextInfo> textSelectionData, int pageIndex, boolean firstDocument) {
        this.textSelectionData = LoadPageTextSelectionResponse.convertTextInfoData(LoadPageTextSelectionResponse.mergedWords(textSelectionData, null));
        this.pageIndex = pageIndex;
        this.firstDocument = firstDocument;
    }

    private static ArrayList<TextSelectionData> convertTextInfoData(List<TextInfo> textSelectionData) {
        ArrayList<TextSelectionData> arrayList = new ArrayList<TextSelectionData>();
        LinkedList<TextStyle> linkedList = new LinkedList<TextStyle>();
        for (TextInfo textInfo : textSelectionData) {
            TextInfoImpl textInfoImpl = (TextInfoImpl)textInfo;
            double d2 = textInfoImpl.getBounds().getMinX();
            double d3 = textInfoImpl.getBounds().getMinY();
            double d4 = textInfoImpl.getBounds().getX() + textInfoImpl.getBounds().getWidth();
            double d5 = textInfoImpl.getBounds().getY() + textInfoImpl.getBounds().getHeight();
            Font font = textInfoImpl.getFont();
            FontRenderContext fontRenderContext = new FontRenderContext(new AffineTransform(), true, true);
            double d6 = font.getLineMetrics(textInfoImpl.getText(), fontRenderContext).getDescent();
            String string = StringFunctions.encodeHTML((String)textInfoImpl.getLabel());
            TextSelectionData textSelectionData2 = new TextSelectionData(string, d2, d3 -= d6, d4, d5 += d6, textInfoImpl.getCharWidth());
            TextStyle textStyle = new TextStyle();
            textStyle.setBold(font.isBold());
            textStyle.setItalic(font.isItalic());
            textStyle.setFontName(font.getName());
            textStyle.setFontSize(textInfoImpl.getFontSize());
            textStyle.setForegroundColor(textInfoImpl.getColor());
            if (linkedList.isEmpty() || !((TextStyle)linkedList.peekLast()).equals(textStyle)) {
                textSelectionData2.setChangeFontStyle(textStyle);
                linkedList.add(textStyle);
            }
            arrayList.add(textSelectionData2);
        }
        return arrayList;
    }

    public static List<TextInfo> mergedWords(List<TextInfo> textSelectionDatas, List<a> mappingStore) {
        ArrayList<TextInfo> arrayList = new ArrayList<TextInfo>(textSelectionDatas);
        int n2 = 0;
        int n3 = 0;
        LoadPageTextSelectionResponse.push(n2, n3, mappingStore);
        for (int i2 = 1; i2 < arrayList.size(); ++i2) {
            TextInfoImpl textInfoImpl = (TextInfoImpl)arrayList.get(i2 - 1);
            TextInfoImpl textInfoImpl2 = (TextInfoImpl)arrayList.get(i2);
            if (textInfoImpl.getRotation() != 0.0 || textInfoImpl2.getRotation() != 0.0) {
                n3 = 0;
                LoadPageTextSelectionResponse.push(++n2, n3, mappingStore);
                continue;
            }
            Rectangle2D rectangle2D = textInfoImpl.getBounds();
            Rectangle2D rectangle2D2 = textInfoImpl2.getBounds();
            TextInfoImpl textInfoImpl3 = null;
            if (TextModuleUtils.canJoinToOneLineForCopyText((Rectangle2D)rectangle2D, (Rectangle2D)rectangle2D2)) {
                Point2D.Double double_;
                Point2D.Double double_2;
                double d2 = (double)textInfoImpl2.getWhiteSpaceWidth() / 20.0;
                if (TextModuleUtils.canJoinOnOneWord((double)d2, (Point2D)(double_2 = new Point2D.Double(rectangle2D.getMaxX(), rectangle2D.getY())), (Point2D)(double_ = new Point2D.Double(rectangle2D2.getMinX(), rectangle2D2.getY())))) {
                    if (LoadPageTextSelectionResponse.sameStyle(textInfoImpl, textInfoImpl2)) {
                        textInfoImpl3 = TextInfoFactory.mergeTextInfos((TextInfoImpl)textInfoImpl, (TextInfoImpl)textInfoImpl2, (boolean)false);
                    }
                } else if (TextModuleUtils.canJoinOnOneWord((double)(d2 * 5.0), (Point2D)double_2, (Point2D)double_) && LoadPageTextSelectionResponse.sameStyle(textInfoImpl, textInfoImpl2)) {
                    textInfoImpl3 = TextInfoFactory.mergeTextInfos((TextInfoImpl)textInfoImpl, (TextInfoImpl)textInfoImpl2, (boolean)true);
                } else {
                    arrayList.set(i2 - 1, (TextInfo)TextInfoFactory.mergeTextInfos((TextInfoImpl)textInfoImpl, (double)d2, (String)" "));
                }
            }
            if (textInfoImpl3 != null) {
                n3 = textInfoImpl3.getText().length() - textInfoImpl2.getText().length();
                arrayList.set(i2 - 1, (TextInfo)textInfoImpl3);
                arrayList.remove(textInfoImpl2);
                --i2;
            } else {
                ++n2;
                n3 = 0;
            }
            LoadPageTextSelectionResponse.push(n2, n3, mappingStore);
        }
        return arrayList;
    }

    private static void push(int index, int charOffset, List<a> mappingStore) {
        if (mappingStore != null) {
            mappingStore.add(new a(index, charOffset));
        }
    }

    private static boolean sameStyle(TextInfoImpl previous, TextInfoImpl current) {
        boolean bl = true;
        bl &= previous.getColor().equals(current.getColor());
        bl &= previous.getFontname().equals(current.getFontname());
        bl &= previous.getFont().isBold() == current.getFont().isBold();
        bl &= previous.getFont().isItalic() == current.getFont().isItalic();
        return bl &= previous.getFont().getSize() == current.getFont().getSize();
    }

    public static class a {
        private int bc;
        private int bd;

        public a(int n2, int n3) {
            this.bc = n2;
            this.bd = n3;
        }

        public int G() {
            return this.bc;
        }

        public int H() {
            return this.bd;
        }
    }
}

