/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.webgui.server.handler;

import com.inet.annotations.JsonData;
import com.inet.drive.api.DrivePermission;
import com.inet.pdfc.config.Settings;
import com.inet.pdfc.config.VisibilitySetting;
import com.inet.pdfc.plugin.persistence.ComparePersistence;
import com.inet.pdfc.results.ResultModel;
import com.inet.pdfc.server.model.ExportSetting;
import com.inet.pdfc.webgui.server.handler.ExportBase;
import com.inet.permissions.AccessDeniedException;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.Base64;

public class ExportToDrive
extends ExportBase<ExportData> {
    public String getMethodName() {
        return "export.drive";
    }

    public short getMethodType() {
        return 1;
    }

    public ExportBase.ResponseData a(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ExportData exportData) throws IOException {
        if (!SystemPermissionChecker.checkAccess((Permission)DrivePermission.DRIVE_PERMISSION)) {
            throw new AccessDeniedException(DrivePermission.DRIVE_PERMISSION);
        }
        ComparePersistence comparePersistence = this.g(exportData.getGuid());
        ResultModel resultModel = comparePersistence.getResult();
        Settings settings = resultModel.getSettings();
        settings.setEnabled(exportData.headerandfooter, new VisibilitySetting[]{Settings.EXPORT.HEADER, Settings.EXPORT.FOOTER});
        settings.setEnabled(exportData.scalepage, new VisibilitySetting[]{Settings.EXPORT.SCALETOPAGEHEIGHT});
        settings.setEnabled(exportData.hidewithoutdiffs, new VisibilitySetting[]{Settings.OPTION.ONLYPAGESWITHDIFFS});
        settings.setEnabled(exportData.comments, new VisibilitySetting[]{Settings.EXPORT.COMMENTS});
        settings.setEnabled(exportData.outlinemarker, new VisibilitySetting[]{Settings.METAOPTION.ALLOUTLINEMARKER});
        ExportSetting exportSetting = new ExportSetting();
        boolean bl = "auto".equals(exportData.paperformat);
        if (bl) {
            exportSetting.setPageFormat(ExportSetting.PageFormat.AUTO);
            settings.setEnabled(true, new VisibilitySetting[]{Settings.EXPORT.AUTOPAGESSIZE, Settings.EXPORT.SCALETOPAGEHEIGHT});
        } else {
            exportSetting.setPaperWidth(exportData.paperwidth);
            exportSetting.setPaperHeight(exportData.paperheight);
            settings.setEnabled(false, new VisibilitySetting[]{Settings.EXPORT.AUTOPAGESSIZE});
        }
        exportSetting.setExportPage(ExportSetting.ExportPage.getValue((String)exportData.documents));
        httpServletResponse.setContentType("application/pdf");
        exportSetting.setExportFormat(ExportSetting.ExportFormat.PDF);
        String string = exportData.password;
        String string2 = new String(Base64.getDecoder().decode(string));
        String string3 = URLDecoder.decode(string2, "UTF-8");
        exportSetting.setOwnerPass(string3);
        exportSetting.setReplaceSystemFonts(exportData.fontembedding);
        return this.a(exportData, comparePersistence, settings, exportSetting);
    }

    public /* synthetic */ Object invoke(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object object) throws IOException {
        return this.a(httpServletRequest, httpServletResponse, (ExportData)object);
    }

    @JsonData
    public static class ExportData
    extends ExportBase.ExportBaseData {
        private String paperformat;
        private String documents;
        private String password;
        private int paperwidth;
        private int paperheight;
        private boolean headerandfooter;
        private boolean scalepage;
        private boolean hidewithoutdiffs;
        private boolean comments;
        private boolean outlinemarker;
        private boolean fontembedding;
    }
}

