/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.webgui.server.events.data;

import com.inet.annotations.JsonData;
import com.inet.pdfc.results.painter.ScrollController;
import com.inet.pdfc.webgui.server.events.data.PageDiffRectangle;

@JsonData
public class ScrollWindow {
    private int maxHeight;
    private PageDiffRectangle firstRect;
    private PageDiffRectangle secondRect;
    private PageDiffRectangle infoRect;
    private boolean firstGap = false;
    private boolean secondGap = false;
    private boolean infoGap = false;

    private ScrollWindow() {
    }

    public ScrollWindow(PageDiffRectangle firstRect, PageDiffRectangle secondRect, PageDiffRectangle infoRect) {
        this.firstRect = firstRect;
        this.secondRect = secondRect;
        this.infoRect = infoRect;
        this.updateMaxHeight();
    }

    public void setIsGap(ScrollController.Column col, boolean isGap) {
        switch (col) {
            case first: {
                this.firstGap = isGap;
                break;
            }
            case second: {
                this.secondGap = isGap;
                break;
            }
            case info: {
                this.infoGap = isGap;
                break;
            }
        }
    }

    public boolean isGap(ScrollController.Column col) {
        switch (col) {
            case first: {
                return this.firstGap;
            }
            case second: {
                return this.secondGap;
            }
            case info: {
                return this.infoGap;
            }
        }
        return false;
    }

    public PageDiffRectangle getFirstRect() {
        return this.firstRect;
    }

    public PageDiffRectangle getSecondRect() {
        return this.secondRect;
    }

    public PageDiffRectangle getInfoRect() {
        return this.infoRect;
    }

    public void updateMaxHeight() {
        int n2 = this.firstRect == null ? 0 : this.firstRect.getY2() - this.firstRect.getY1();
        int n3 = this.secondRect == null ? 0 : this.secondRect.getY2() - this.secondRect.getY1();
        int n4 = this.infoRect == null ? 0 : this.infoRect.getY2() - this.infoRect.getY1();
        this.maxHeight = Math.max(Math.max(n2, n3), n4);
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }
}

