/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.comparisonapi.command;

import com.inet.id.GUID;
import com.inet.pdfc.comparisonapi.a;
import com.inet.pdfc.comparisonapi.model.ComparisonGUID;
import com.inet.pdfc.comparisonapi.model.OutputElement;
import com.inet.pdfc.comparisonapi.model.OutputElementList;
import com.inet.pdfc.plugin.persistence.ComparePersistence;
import com.inet.pdfc.plugin.persistence.PersistenceFactory;
import com.inet.pdfc.plugin.persistence.UserPersistenceManager;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@Tag(name="PDF Comparison", description="Operations for managing PDF comparisons")
public class d
extends com.inet.pdfc.comparisonapi.server.data.a {
    public d() {
        super("list");
    }

    @Override
    @Operation(summary="List all comparisons", description="Returns a list of all comparison GUIDs for the current user. The list includes both completed and in-progress comparisons. Each GUID can be used with other endpoints to retrieve comparison results or status. Results are returned in no specific order and may change between requests.", responses={@ApiResponse(responseCode="200", description="List of comparison GUIDs retrieved successfully. An empty list indicates no comparisons exist for the user. Each GUID represents a unique comparison that can be queried for details.", content={@Content(schema=@Schema(implementation=OutputElementList.class, description="Array of comparison GUIDs", subTypes={ComparisonGUID.class}))}), @ApiResponse(responseCode="401", description="User not authenticated"), @ApiResponse(responseCode="403", description="User does not have permission to list comparisons")})
    public OutputElement a(@Parameter(description="HTTP request") @Nonnull HttpServletRequest httpServletRequest, @Parameter(description="HTTP response") @Nonnull HttpServletResponse httpServletResponse, @Parameter(description="Optional path parameters") @Nullable List<String> list, @Parameter(description="Whether to run in preview mode") boolean bl) throws IOException {
        OutputElementList outputElementList = new OutputElementList();
        PersistenceFactory persistenceFactory = a.b();
        UserPersistenceManager userPersistenceManager = a.c();
        UserAccount userAccount = UserManager.getInstance().getCurrentUserAccount();
        List list2 = userPersistenceManager.getComparisonIDsForUser(userAccount.getID(), null);
        for (GUID gUID : list2) {
            ComparePersistence comparePersistence = persistenceFactory.getPersistence(gUID);
            if (comparePersistence == null) continue;
            outputElementList.add(new ComparisonGUID(gUID.toString()));
        }
        return outputElementList;
    }

    public String getHelpPageKey() {
        return "comparisonapi-list";
    }
}

