/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.comparisonapi.model.compare;

import com.inet.annotations.JsonData;
import com.inet.http.ClientMessageException;
import com.inet.http.servlet.SessionStore;
import com.inet.lib.json.Json;
import com.inet.pdfc.comparisonapi.ComparisonAPIPlugin;
import com.inet.pdfc.comparisonapi.command.guid.results.g;
import com.inet.pdfc.comparisonapi.model.a;
import com.inet.pdfc.comparisonapi.model.compare.FileRequestData;
import com.inet.pdfc.comparisonapi.model.compare.PDFFileRequestData;
import com.inet.pdfc.comparisonapi.server.b;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.SuppressFBWarnings;

@JsonData
@Schema(description="Request data for initiating a PDF comparison")
public class CompareRequestData {
    @Schema(description="First PDF file to compare", required=true)
    private PDFFileRequestData file1;
    @Schema(description="Second PDF file to compare", required=true)
    private PDFFileRequestData file2;
    @Schema(description="Comparison profile configuration file")
    private FileRequestData profile;
    @Schema(description="Name of an existing comparison profile to use")
    private String profileName;
    @Schema(description="Custom name for the comparison")
    private String name;
    @Schema(description="Type of result to generate", example="pdf,html,xml")
    private String result;
    @Schema(description="Whether to use free comparison mode", defaultValue="false")
    private boolean free;

    protected CompareRequestData() {
    }

    @SuppressFBWarnings(value={"SERVLET_CONTENT_TYPE"}, justification="The data is required to have the application/json content type. The user actively decides to deliver data in a specific way.")
    public static CompareRequestData from(HttpServletRequest request) throws IOException {
        CompareRequestData compareRequestData;
        Object object;
        Object object2;
        b b2 = new b(request);
        ComparisonAPIPlugin.LOGGER.debug((Object)(SessionStore.getHttpSessionId() + " for api call compare parameter ->" + String.valueOf(b2)));
        String string = request.getContentType();
        Optional<a> optional = b2.q().stream().filter(stream -> stream.o() != null && stream.o().toLowerCase().startsWith("application/json")).findFirst();
        if (optional.isPresent()) {
            object2 = optional.get();
            b2.q().remove(object2);
            object = ((a)object2).k();
            try {
                compareRequestData = (CompareRequestData)new Json().fromJson((InputStream)object, CompareRequestData.class);
            }
            finally {
                if (object != null) {
                    ((InputStream)object).close();
                }
            }
        } else {
            compareRequestData = "application/json; charset=utf-8".equalsIgnoreCase(string) ? (CompareRequestData)new Json().fromJson((InputStream)request.getInputStream(), CompareRequestData.class) : new CompareRequestData();
        }
        compareRequestData.name = compareRequestData.name != null ? compareRequestData.name : b2.f("name");
        compareRequestData.free = compareRequestData.free || b2.f("free") != null;
        compareRequestData.result = compareRequestData.result != null ? compareRequestData.result : b2.f("result");
        String string2 = compareRequestData.profileName = compareRequestData.profileName != null ? compareRequestData.profileName : b2.f("profile");
        if (CompareRequestData.isObjectValid(compareRequestData.file1) && CompareRequestData.isObjectValid(compareRequestData.file2) && (CompareRequestData.isObjectValid(compareRequestData.profile) || compareRequestData.profileName != null)) {
            return compareRequestData;
        }
        if (b2.q().size() > 3) {
            throw new ClientMessageException(ComparisonAPIPlugin.MSG.getMsg("error.toManyFiles", new Object[0]));
        }
        object2 = b2.q();
        object = CompareRequestData.getFileStream((List<a>)object2, "file1", false);
        a a2 = CompareRequestData.getFileStream((List<a>)object2, "file2", false);
        a a3 = CompareRequestData.getFileStream((List<a>)object2, "profile", true);
        Iterator iterator = object2.iterator();
        while (iterator.hasNext()) {
            a a4 = (a)iterator.next();
            if (a4.h()) {
                if (object == null) {
                    object = a4;
                    continue;
                }
                if (a2 == null) {
                    a2 = a4;
                    continue;
                }
                if (a3 != null || !a4.i()) {
                    throw new ClientMessageException(ComparisonAPIPlugin.MSG.getMsg("error.toManyPDFFiles", new Object[0]));
                }
            }
            if (a4.i()) {
                if (a3 != null) {
                    throw new ClientMessageException(ComparisonAPIPlugin.MSG.getMsg("error.doubleconfig", new Object[0]));
                }
                a3 = a4;
                continue;
            }
            ComparisonAPIPlugin.LOGGER.warn((Object)("For Parameter " + a4.getName() + " with filename '" + a4.j() + " and conten-type " + a4.o()));
            ComparisonAPIPlugin.LOGGER.warn((Object)("For Parameter " + a4.getName() + " with filename '" + a4.j() + " received " + a4.l() + " bytes."));
            throw new ClientMessageException(ComparisonAPIPlugin.MSG.getMsg("error.unknowFileFormat", new Object[]{a4.j()}));
        }
        compareRequestData.file1 = CompareRequestData.setAndCheckFileParameter(compareRequestData.getFile1(), b2, "file1", (a)object, true);
        compareRequestData.file2 = CompareRequestData.setAndCheckFileParameter(compareRequestData.getFile2(), b2, "file2", a2, true);
        compareRequestData.profile = CompareRequestData.setAndCheckFileParameter(compareRequestData.getProfile(), b2, "profile", a3, false);
        return compareRequestData;
    }

    private static boolean isObjectValid(FileRequestData data) {
        return data != null && data.hasFileStream();
    }

    private static <T extends FileRequestData> T setAndCheckFileParameter(@Nonnull T fileRequestData, @Nonnull b parseRequest, @Nonnull String fileParameterName, @Nonnull a fileStream, boolean throwIfNotSet) {
        block6: {
            if (fileStream != null) {
                fileRequestData.setFileStream(fileStream);
            } else if (parseRequest.f(fileParameterName) != null) {
                fileRequestData.setUrl(parseRequest.f(fileParameterName));
            }
            try {
                if (throwIfNotSet && fileRequestData.getFileStream() == null) {
                    throw new ClientMessageException(ComparisonAPIPlugin.MSG.getMsg("error.fileRequiredWithParameter", new Object[]{fileParameterName}));
                }
            }
            catch (IOException iOException) {
                if (!throwIfNotSet) break block6;
                throw new ClientMessageException(ComparisonAPIPlugin.MSG.getMsg("error.filenotfound", new Object[]{fileParameterName, fileRequestData.getUrl(), iOException.getMessage()}));
            }
        }
        return fileRequestData;
    }

    public void clearTemporaryFiles() throws IOException {
        if (this.file1 != null) {
            this.file1.close();
        }
        if (this.file2 != null) {
            this.file1.close();
        }
        if (this.profile != null) {
            this.file1.close();
        }
    }

    private static a getFileStream(List<a> fileStreams, String key, boolean isConfigStream) {
        Optional<a> optional = fileStreams.stream().filter(fileStream -> key == null || key.equalsIgnoreCase(fileStream.getName())).findFirst();
        if (optional.isPresent()) {
            a a2 = optional.get();
            if (isConfigStream && !a2.i()) {
                return null;
            }
            if (!isConfigStream && !a2.h()) {
                ComparisonAPIPlugin.LOGGER.warn((Object)("For Parameter " + a2.getName() + " with filename '" + a2.j() + " and conten-type " + a2.o()));
                ComparisonAPIPlugin.LOGGER.warn((Object)("For Parameter " + a2.getName() + " with filename '" + a2.j() + " received " + a2.l() + " bytes."));
                throw new ClientMessageException(ComparisonAPIPlugin.MSG.getMsg("error.unknowFileFormat", new Object[]{a2.j()}));
            }
            fileStreams.remove(a2);
            return a2;
        }
        return null;
    }

    public PDFFileRequestData getFile1() {
        return this.file1 == null ? new PDFFileRequestData() : this.file1;
    }

    public PDFFileRequestData getFile2() {
        return this.file2 == null ? new PDFFileRequestData() : this.file2;
    }

    public FileRequestData getProfile() {
        return this.profile == null ? new FileRequestData() : this.profile;
    }

    public String getName() {
        return this.name;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public g getResultType() {
        return g.c(this.result);
    }

    public boolean isFree() {
        return this.free || g.e.equals(this.getResultType());
    }
}

