/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.comparisonapi.model;

import com.inet.annotations.JsonData;
import com.inet.pdfc.comparisonapi.ComparisonAPIPlugin;
import com.inet.pdfc.comparisonapi.model.DefaultOutputElement;
import com.inet.pdfc.config.ColorSetting;
import com.inet.pdfc.config.Settings;
import com.inet.pdfc.config.VisibilitySetting;
import java.awt.Color;

@JsonData
public class Coloring
extends DefaultOutputElement {
    private String type = null;
    private boolean visible = false;
    private String color = null;

    public Coloring() {
    }

    public Coloring(ColorSetting setting, Settings settings) {
        this.type = setting.name();
        this.visible = settings.isEnabled((VisibilitySetting)setting);
        Color color = settings.getColor(setting);
        this.color = Coloring.getHexColor(color);
    }

    @Override
    public String htmlHead() {
        return "<th>" + ComparisonAPIPlugin.MSG.getMsg("html.head.colortyp", new Object[0]) + "</th><th>" + ComparisonAPIPlugin.MSG.getMsg("html.head.visible", new Object[0]) + "</th><th>" + ComparisonAPIPlugin.MSG.getMsg("html.head.color", new Object[0]) + "</th>";
    }

    @Override
    public String toHTML() {
        return "<td>" + this.type + "</td><td>" + this.visible + "</td><td>" + this.color + "<div style=\"width: 20px; height: 20px; background: " + Coloring.getHTMLColor(this.color) + ";\"></div></td>";
    }

    private static String getHexColor(Color color) {
        if (color == null) {
            color = Color.WHITE;
        }
        return String.format("#%02x%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
    }

    private static String getHTMLColor(String hexColor) {
        int n = Integer.parseInt(hexColor.substring(1, 3), 16);
        int n2 = Integer.parseInt(hexColor.substring(3, 5), 16);
        int n3 = Integer.parseInt(hexColor.substring(5, 7), 16);
        double d2 = (double)Integer.parseInt(hexColor.substring(7, 9), 16) / 255.0;
        return "rgba(" + n + "," + n2 + "," + n3 + "," + d2 + ")";
    }
}

