/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.comparisonapi.command.guid.results;

import com.inet.annotations.InternalApi;
import com.inet.http.ClientMessageException;
import com.inet.id.GUID;
import com.inet.pdfc.comparisonapi.ComparisonAPIPlugin;
import com.inet.pdfc.comparisonapi.command.guid.results.a;
import com.inet.pdfc.comparisonapi.model.OutputElement;
import com.inet.pdfc.comparisonapi.model.b;
import com.inet.pdfc.plugin.persistence.ComparePersistence;
import com.inet.pdfc.plugin.persistence.CompareState;
import com.inet.pdfc.plugin.persistence.PersistenceFactory;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountScope;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.SuppressFBWarnings;

@InternalApi
public abstract class ResultBlocking
implements a {
    @Override
    @SuppressFBWarnings(value={"UNVALIDATED_REDIRECT"}, justification="The redirect URL is created from internally known parameters without user interaction.")
    public final OutputElement handle(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response, @Nonnull GUID guid, @Nonnull UserAccount account, boolean deleteOnFinished) throws IOException {
        b b2 = b.b(request);
        try (UserAccountScope userAccountScope = UserAccountScope.create((GUID)account.getID());){
            ComparePersistence comparePersistence = com.inet.pdfc.comparisonapi.a.b().getPersistence(guid);
            if (comparePersistence == null) {
                response.setStatus(404);
                throw new ClientMessageException(ComparisonAPIPlugin.MSG.getMsg("compare.state.canceled", new Object[0]));
            }
            CompareState compareState = comparePersistence.getCompareState();
            switch (compareState.getState()) {
                case CANCELED: {
                    this.a(deleteOnFinished, comparePersistence);
                }
                case CANCELING: {
                    response.setStatus(404);
                    throw new ClientMessageException(ComparisonAPIPlugin.MSG.getMsg("compare.state.canceled", new Object[0]));
                }
                case ERROR: {
                    this.a(deleteOnFinished, comparePersistence);
                    response.setStatus(404);
                    throw new ClientMessageException(ComparisonAPIPlugin.MSG.getMsg("compare.state.error", new Object[0]));
                }
                case IDLE: {
                    response.setStatus(404);
                    throw new ClientMessageException(ComparisonAPIPlugin.MSG.getMsg("compare.state.idle", new Object[0]));
                }
                case FINISHED: {
                    if (!comparePersistence.canExecute()) break;
                    OutputElement outputElement = this.a(request, response, comparePersistence, b2);
                    this.a(deleteOnFinished, comparePersistence);
                    OutputElement outputElement2 = outputElement;
                    return outputElement2;
                }
            }
            com.inet.pdfc.comparisonapi.a.b(guid);
            response.sendRedirect(com.inet.pdfc.comparisonapi.a.a(request, String.valueOf(guid) + "/result/" + this.e().g().toLowerCase()));
            OutputElement outputElement = null;
            return outputElement;
        }
    }

    private void a(boolean bl, ComparePersistence comparePersistence) throws IOException {
        if (bl || Boolean.TRUE.toString().equals(comparePersistence.getMetaData().get("pdfcfree"))) {
            ((PersistenceFactory)ServerPluginManager.getInstance().getSingleInstance(PersistenceFactory.class)).remove(comparePersistence.getGUID(), false);
        } else {
            comparePersistence.setMetaProperty("pdfcfree", null);
        }
    }

    abstract OutputElement a(@Nonnull HttpServletRequest var1, @Nonnull HttpServletResponse var2, ComparePersistence var3, b var4) throws IOException;
}

