/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.comparisonapi.command;

import com.inet.http.ClientMessageException;
import com.inet.id.GUID;
import com.inet.pdfc.comparisonapi.ComparisonAPIPlugin;
import com.inet.pdfc.comparisonapi.a;
import com.inet.pdfc.comparisonapi.model.OutputElement;
import com.inet.pdfc.comparisonapi.server.b;
import com.inet.pdfc.config.ColorSetting;
import com.inet.pdfc.config.SettingUtil;
import com.inet.pdfc.config.Settings;
import com.inet.pdfc.config.VisibilitySetting;
import com.inet.pdfc.generator.model.DiffGroup;
import com.inet.pdfc.generator.model.Modification;
import com.inet.pdfc.persistence.UserSettingsImpl;
import com.inet.pdfc.results.painter.DiffConstants;
import com.inet.plugin.webapi.api.ResponseWriter;
import com.inet.usersandgroups.api.user.UserManager;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;

@Tag(name="PDF Comparison", description="Operations for managing comparison settings")
public class f
extends com.inet.pdfc.comparisonapi.server.data.a {
    public f() {
        super("settings");
    }

    @Override
    @Operation(summary="Update comparison settings", description="Updates user-specific comparison settings including visibility options and color settings. Settings control how differences are displayed in comparison results. Settings can be reset to defaults or modified individually. Visibility settings control which types of changes are shown (e.g., additions, deletions). Color settings define how different types of changes are highlighted. After successful update, redirects to the info endpoint.", responses={@ApiResponse(responseCode="200", description="Settings updated successfully. Response will be empty due to redirect."), @ApiResponse(responseCode="302", description="Settings updated successfully, redirecting to info endpoint to view current settings"), @ApiResponse(responseCode="400", description="Invalid settings format. Common causes: invalid color format (must be 6 or 8 hex digits), unknown visibility setting, malformed request parameters"), @ApiResponse(responseCode="401", description="User not authenticated"), @ApiResponse(responseCode="403", description="User does not have permission to modify settings")})
    @Parameters(value={@Parameter(name="reset", description="If present, resets all settings to system defaults before applying other changes", in=ParameterIn.QUERY), @Parameter(name="visible", description="Comma-separated list of visibility settings to enable (e.g., 'ADDED,DELETED,CHANGED')", in=ParameterIn.QUERY), @Parameter(name="invisible", description="Comma-separated list of visibility settings to disable (e.g., 'MOVED,STYLE')", in=ParameterIn.QUERY), @Parameter(name="{colorSetting}", description="Hex color value for specific color setting (e.g., 'ADDED=#FF0000'). ", in=ParameterIn.QUERY)})
    @SuppressFBWarnings(value={"UNVALIDATED_REDIRECT"}, justification="The redirect URL is created from internally known parameters without user interaction.")
    public OutputElement a(@Parameter(description="HTTP request containing settings parameters") @Nonnull HttpServletRequest httpServletRequest, @Parameter(description="HTTP response for redirect") @Nonnull HttpServletResponse httpServletResponse, @Parameter(description="Optional path parameters") @Nullable List<String> list, @Parameter(description="Whether to run in preview mode") boolean bl) throws IOException {
        b b2 = new b(httpServletRequest);
        GUID gUID = UserManager.getInstance().getCurrentUserAccountID();
        if (gUID == null) {
            ResponseWriter.forbidden((HttpServletResponse)httpServletResponse);
            return null;
        }
        UserSettingsImpl userSettingsImpl = new UserSettingsImpl(gUID);
        String string = b2.f("reset");
        if (string != null) {
            userSettingsImpl.reset();
        }
        this.a(b2.f("visible"), userSettingsImpl, true);
        this.a(b2.f("invisible"), userSettingsImpl, false);
        ArrayList<DiffGroup.GroupType> arrayList = new ArrayList<DiffGroup.GroupType>(SettingUtil.getAvailableColorSetting());
        arrayList.addAll(Arrays.stream(DiffGroup.GroupType.values()).toList());
        for (ColorSetting object2 : arrayList) {
            Object object;
            Object object3;
            String string2 = object2.name().toLowerCase();
            String string3 = b2.f(string2);
            if (string3 == null || string3.isEmpty()) continue;
            if ((string3 = string3.replace("#", "")).length() < 7 && string3.length() != 6) {
                object3 = ComparisonAPIPlugin.MSG.getMsg("error.setting.colortoshort", new Object[]{object2.name()});
                throw new ClientMessageException(ComparisonAPIPlugin.MSG.getMsg("error.setting.wrongcolorformat", new Object[]{object3}));
            }
            if (string3.length() > 8) {
                object3 = ComparisonAPIPlugin.MSG.getMsg("error.setting.colortolong", new Object[]{object2.name()});
                throw new ClientMessageException(ComparisonAPIPlugin.MSG.getMsg("error.setting.wrongcolorformat", new Object[]{object3}));
            }
            object3 = SettingUtil.hexToColor((String)string3);
            if (object3 == null) {
                object = ComparisonAPIPlugin.MSG.getMsg("error.setting.colorinvalidcharacters", new Object[]{object2.name()});
                throw new ClientMessageException(ComparisonAPIPlugin.MSG.getMsg("error.setting.wrongcolorformat", new Object[]{object}));
            }
            if (object2 == Settings.METAOPTION.ALLOUTLINEMARKER) {
                SettingUtil.setAllOutlineMarkerSetting((Color)object3, (Settings)userSettingsImpl);
                continue;
            }
            if (object2 instanceof DiffGroup.GroupType) {
                for (Modification.ModificationType modificationType : object = DiffConstants.getModificationType((DiffGroup.GroupType)((DiffGroup.GroupType)object2))) {
                    userSettingsImpl.setColor((Color)object3, (ColorSetting)modificationType);
                }
                continue;
            }
            userSettingsImpl.setColor((Color)object3, object2);
        }
        userSettingsImpl.save();
        Object object5 = a.a(httpServletRequest, "info");
        com.inet.pdfc.comparisonapi.model.b b3 = com.inet.pdfc.comparisonapi.model.b.b(httpServletRequest);
        if (!com.inet.pdfc.comparisonapi.model.b.r.equals((Object)b3)) {
            object5 = (String)object5 + "?format=" + String.valueOf((Object)b3);
        }
        httpServletResponse.sendRedirect((String)object5);
        return null;
    }

    private void a(@Nullable String string, @Nonnull UserSettingsImpl userSettingsImpl, boolean bl) {
        if (string != null && !string.isEmpty()) {
            String[] stringArray;
            for (String string2 : stringArray = string.split(",")) {
                for (VisibilitySetting visibilitySetting : SettingUtil.getAvailableVisibilitySetting()) {
                    if (!string2.equalsIgnoreCase(visibilitySetting.name())) continue;
                    userSettingsImpl.setEnabled(bl, new VisibilitySetting[]{visibilitySetting});
                }
                for (DiffGroup.GroupType groupType : DiffGroup.GroupType.values()) {
                    if (!string2.equalsIgnoreCase(groupType.name())) continue;
                    DiffConstants.getModificationType((DiffGroup.GroupType)groupType);
                    for (Modification.ModificationType modificationType : DiffConstants.getModificationType((DiffGroup.GroupType)groupType)) {
                        userSettingsImpl.setEnabled(bl, new VisibilitySetting[]{modificationType});
                    }
                }
            }
        }
    }

    public String getHelpPageKey() {
        return "comparisonapi-setting";
    }
}

