/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.comparisonapi.model.compare;

import com.inet.annotations.JsonData;
import com.inet.lib.util.IOFunctions;
import com.inet.pdfc.comparisonapi.model.a;
import com.inet.permissions.AccessDeniedException;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

@JsonData
@Schema(description="Request data for a file that can be provided via URL or direct upload")
public class FileRequestData
implements Closeable,
AutoCloseable {
    @Schema(description="URL to download the file from")
    private String url;
    @Schema(description="HTTP headers to use when downloading from URL")
    private Map<String, String> headers = new HashMap<String, String>();
    @Schema(description="File data when provided as direct upload", hidden=true)
    private a fileStream;

    protected FileRequestData() {
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setFileStream(a fileStream) {
        this.fileStream = fileStream;
    }

    @Override
    public void close() throws IOException {
        if (this.fileStream != null) {
            this.fileStream.n();
            this.fileStream = null;
        }
    }

    public a getFileStream() throws IOException {
        if (this.fileStream == null && this.url != null && !this.url.trim().isEmpty()) {
            this.fileStream = new a(IOFunctions.getURLFromString((String)this.url), System.currentTimeMillis(), this.headers);
        }
        return this.fileStream;
    }

    public boolean hasFileStream() {
        try {
            return this.getFileStream() != null;
        }
        catch (AccessDeniedException | IOException throwable) {
            return false;
        }
    }
}

