/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.comparisonapi.model;

import com.inet.annotations.JsonData;
import com.inet.lib.util.StringFunctions;
import com.inet.pdfc.comparisonapi.ComparisonAPIPlugin;
import com.inet.pdfc.comparisonapi.model.Coloring;
import com.inet.pdfc.comparisonapi.model.DefaultOutputElement;
import com.inet.pdfc.comparisonapi.model.OutputElementList;
import com.inet.pdfc.comparisonapi.model.Visibility;
import com.inet.pdfc.config.ColorSetting;
import com.inet.pdfc.config.SettingUtil;
import com.inet.pdfc.config.Settings;
import com.inet.pdfc.config.VisibilitySetting;
import com.inet.pdfc.plugin.persistence.UserContingent;
import com.inet.pdfc.server.persistence.ContingentManager;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;

@JsonData
public class Info
extends DefaultOutputElement {
    private String username;
    private int comparisons;
    private int maxcomparisons;
    private long space;
    private long maxspace;
    private int maxpagesperdocument;
    private int profiles;
    private final List<Visibility> visiblesettings = new ArrayList<Visibility>();
    private final List<Coloring> colorsettings = new ArrayList<Coloring>();

    public Info() {
    }

    public Info(@Nonnull UserContingent userContingent, int profiles, Settings settings) {
        UserAccount userAccount = UserManager.getInstance().getUserAccount(userContingent.getUserID());
        this.username = userAccount != null ? userAccount.getDisplayName() : "<undefined>";
        this.comparisons = userContingent.getUsedComparison();
        this.maxcomparisons = (Integer)ContingentManager.CONTIGENT_COMPARISIONPERUSER.get();
        this.space = userContingent.getUsedHardDiskSpace() / 0x100000L;
        this.maxspace = (Long)ContingentManager.CONTIGENT_HDD.get();
        this.maxpagesperdocument = (Integer)ContingentManager.CONTIGENT_NUMOFPAGES.get();
        this.profiles = profiles;
        ArrayList<ColorSetting> arrayList = new ArrayList<ColorSetting>(SettingUtil.getAvailableColorSetting());
        arrayList.sort(Comparator.comparing(VisibilitySetting::name));
        for (ColorSetting object2 : arrayList) {
            this.colorsettings.add(new Coloring(object2, settings));
        }
        ArrayList arrayList2 = new ArrayList(SettingUtil.getAvailableVisibilitySetting());
        arrayList2.removeAll(arrayList);
        arrayList2.sort(Comparator.comparing(VisibilitySetting::name));
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            VisibilitySetting visibilitySetting = (VisibilitySetting)iterator.next();
            this.visiblesettings.add(new Visibility(visibilitySetting, settings));
        }
    }

    @Override
    public String toHTML() {
        return "<h1>" + ComparisonAPIPlugin.MSG.getMsg("html.info.head.general", new Object[0]) + "</h1>\n<table border=\"1\"><tr><td>" + StringFunctions.encodeHTML((String)ComparisonAPIPlugin.MSG.getMsg("info.username", new Object[0]), (boolean)false) + "</td><td>" + this.username + "</td></tr><tr><td>" + ComparisonAPIPlugin.MSG.getMsg("info.numofcomparing", new Object[0]) + "</td><td>" + this.comparisons + "</td></tr><tr><td>" + ComparisonAPIPlugin.MSG.getMsg("info.maxnumofcomparing", new Object[0]) + "</td><td>" + this.getValue(this.maxcomparisons) + "</td></tr><tr><td>" + ComparisonAPIPlugin.MSG.getMsg("info.usedspace", new Object[0]) + "</td><td>" + this.space + " MB</td></tr><tr><td>" + ComparisonAPIPlugin.MSG.getMsg("info.maxusedspace", new Object[0]) + "</td><td>" + this.getValue(this.maxspace) + " MB</td></tr><tr><td>" + ComparisonAPIPlugin.MSG.getMsg("info.maxnumofsites", new Object[0]) + "</td><td>" + this.getValue(this.maxpagesperdocument) + "</td></tr><tr><td>" + ComparisonAPIPlugin.MSG.getMsg("info.numofconfiguration", new Object[0]) + "</td><td>" + this.profiles + "</td></tr></table>\n<h1>" + ComparisonAPIPlugin.MSG.getMsg("html.info.head.setting", new Object[0]) + "</h1>\n<h2>" + ComparisonAPIPlugin.MSG.getMsg("html.info.head.visibilitysetting", new Object[0]) + "</h2>" + new OutputElementList<Visibility>((Collection<Visibility>)this.visiblesettings).toHTML() + "<h2>" + ComparisonAPIPlugin.MSG.getMsg("html.info.head.colorsetting", new Object[0]) + "</h2>" + new OutputElementList<Coloring>((Collection<Coloring>)this.colorsettings).toHTML();
    }

    private String getValue(long value) {
        return value == 0L ? ComparisonAPIPlugin.MSG.getMsg("html.unlimited", new Object[0]) : "" + value;
    }
}

