/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.comparisonapi.command;

import com.inet.pdfc.comparisonapi.a;
import com.inet.pdfc.comparisonapi.model.OutputElement;
import com.inet.pdfc.comparisonapi.model.OutputElementList;
import com.inet.pdfc.comparisonapi.model.Profile;
import com.inet.pdfc.plugin.persistence.ProfilePersistence;
import com.inet.usersandgroups.api.user.UserManager;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@Tag(name="PDF Comparison", description="Operations for managing comparison profiles")
public class e
extends com.inet.pdfc.comparisonapi.server.data.a {
    public e() {
        super("profiles");
    }

    @Override
    @Operation(summary="List all comparison profiles", description="Returns a list of all available comparison profiles for the current user. Profiles define settings and rules for how PDFs should be compared, including visibility settings, color configurations, and comparison rules. The response is localized based on the request's locale. Profiles can be referenced by ID when initiating new comparisons.", responses={@ApiResponse(responseCode="200", description="List of comparison profiles retrieved successfully. An empty list indicates no profiles are configured. Each profile contains settings that can be applied to new comparisons.", content={@Content(schema=@Schema(implementation=OutputElementList.class, description="Array of comparison profiles with localized descriptions", subTypes={Profile.class}))}), @ApiResponse(responseCode="401", description="User not authenticated"), @ApiResponse(responseCode="403", description="User does not have permission to access profiles")})
    public OutputElement a(@Parameter(description="HTTP request containing locale information") @Nonnull HttpServletRequest httpServletRequest, @Parameter(description="HTTP response") @Nonnull HttpServletResponse httpServletResponse, @Parameter(description="Optional path parameters") @Nullable List<String> list, @Parameter(description="Whether to run in preview mode") boolean bl) throws IOException {
        Locale locale = httpServletRequest.getLocale();
        return new OutputElementList<OutputElement>((Collection<OutputElement>)this.a(locale));
    }

    private List<OutputElement> a(Locale locale) throws IOException {
        ArrayList<OutputElement> arrayList = new ArrayList<OutputElement>();
        List list = a.d().getAllProfiles(UserManager.getInstance().getCurrentUserAccountID());
        arrayList.addAll(list.stream().map(profilePersistence -> new Profile((ProfilePersistence)profilePersistence, locale)).collect(Collectors.toList()));
        return arrayList;
    }

    public String getHelpPageKey() {
        return "comparisonapi-profiles";
    }
}

