/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.comparisonapi.command;

import com.inet.id.GUID;
import com.inet.pdfc.comparisonapi.ComparisonAPIPlugin;
import com.inet.pdfc.comparisonapi.a;
import com.inet.pdfc.comparisonapi.model.ComparisonGUID;
import com.inet.pdfc.comparisonapi.model.OutputElement;
import com.inet.pdfc.comparisonapi.model.OutputElementList;
import com.inet.pdfc.plugin.persistence.PersistenceFactory;
import com.inet.pdfc.plugin.persistence.UserPersistenceManager;
import com.inet.permissions.AccessDeniedException;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.webapi.api.ResponseWriter;
import com.inet.usersandgroups.api.user.UserManager;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@Tag(name="PDF Comparison", description="Operations for managing comparisons")
public class b
extends com.inet.pdfc.comparisonapi.server.data.a {
    public b() {
        super("deleteall");
    }

    @Override
    @Operation(summary="Delete all comparisons", description="Deletes all comparisons for the current user. Requires administrator permissions to delete all comparisons.", responses={@ApiResponse(responseCode="200", description="All comparisons deleted successfully", content={@Content(schema=@Schema(implementation=OutputElementList.class))}), @ApiResponse(responseCode="401", description="User not authorized"), @ApiResponse(responseCode="403", description="User does not have administrator permissions")})
    public OutputElement a(@Parameter(description="HTTP request") @Nonnull HttpServletRequest httpServletRequest, @Parameter(description="HTTP response") @Nonnull HttpServletResponse httpServletResponse, @Parameter(description="Optional path parameters") @Nullable List<String> list, @Parameter(description="Whether to run in preview mode") boolean bl) throws IOException {
        if (!SystemPermissionChecker.isAdministrator()) {
            throw new AccessDeniedException(ComparisonAPIPlugin.MSG.getMsg("error.delelteAll.permissions", new Object[0]));
        }
        UserPersistenceManager userPersistenceManager = a.c();
        PersistenceFactory persistenceFactory = a.b();
        GUID gUID = UserManager.getInstance().getCurrentUserAccountID();
        if (gUID == null) {
            ResponseWriter.forbidden((HttpServletResponse)httpServletResponse);
            return null;
        }
        List list2 = userPersistenceManager.getComparisonIDsForUser(gUID, null);
        ArrayList<ComparisonGUID> arrayList = new ArrayList<ComparisonGUID>();
        for (GUID gUID2 : list2) {
            arrayList.add(new ComparisonGUID(gUID2.toString()));
        }
        if (!bl) {
            for (ComparisonGUID comparisonGUID : arrayList) {
                persistenceFactory.remove(GUID.valueOf((String)comparisonGUID.toHTML()), true);
            }
        }
        return new OutputElementList(arrayList);
    }

    @Override
    public boolean shouldSendJsonResponse() {
        return false;
    }

    public String getHelpPageKey() {
        return "comparisonapi-deleteall";
    }
}

