/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.comparisonapi.model;

import com.inet.annotations.JsonData;
import com.inet.lib.util.StringFunctions;
import com.inet.pdfc.comparisonapi.ComparisonAPIPlugin;
import com.inet.pdfc.comparisonapi.a;
import com.inet.pdfc.comparisonapi.model.DefaultOutputElement;
import com.inet.pdfc.config.PdfSource;
import com.inet.pdfc.plugin.persistence.ComparePersistence;
import com.inet.pdfc.plugin.persistence.ProfilePersistence;
import com.inet.usersandgroups.api.user.UserAccount;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.Properties;
import javax.annotation.Nonnull;

@JsonData
@Schema(description="Model data representing a PDF comparison")
public class Comparison
extends DefaultOutputElement {
    @Schema(description="Unique identifier of the comparison", required=true)
    private String guid = null;
    @Schema(description="Name of the comparison")
    private String name = null;
    @Schema(description="Name of the first file being compared")
    private String file1name = null;
    @Schema(description="Name of the second file being compared")
    private String file2name = null;
    @Schema(description="Current status of the comparison", required=true)
    private String status = null;
    @Schema(description="Name of the profile used for comparison")
    private String profilename = null;
    @Schema(description="ID of the profile used for comparison")
    private String profileid = null;
    @Schema(description="Filename of the profile used for comparison")
    private String profilefilename = null;
    @Schema(description="Number of differences found in the comparison", defaultValue="0")
    private int differences = 0;
    @Schema(description="Whether the comparison is publicly accessible", defaultValue="false")
    private boolean ispublic = false;
    @Schema(description="Timestamp when the comparison was created", required=true)
    private long created = 0L;
    @Schema(description="Timestamp when the comparison was last modified", required=true)
    private long modified = 0L;

    public Comparison() {
    }

    public Comparison(@Nonnull ComparePersistence persistence, @Nonnull UserAccount user) throws IOException {
        this.ispublic = persistence.getPublicationMode() != ComparePersistence.PUBLICATION_MODE.none;
        this.guid = persistence.getGUID().toString();
        this.name = persistence.getMetaData().getProperty("title", "");
        this.created = Long.parseLong(persistence.getMetaData().getProperty("created", "0"));
        this.modified = Long.parseLong(persistence.getMetaData().getProperty("created", "0"));
        this.status = persistence.getCompareState().getState().name();
        PdfSource pdfSource = persistence.getDocument(true);
        this.file1name = pdfSource == null ? "" : pdfSource.getName();
        PdfSource pdfSource2 = persistence.getDocument(false);
        this.file2name = pdfSource2 == null ? "" : pdfSource2.getName();
        Properties properties = persistence.getMetaData();
        String string = properties.getProperty("configuration.guid");
        String string2 = null;
        Object var8_8 = null;
        if (string != null && !string.isEmpty()) {
            try {
                ProfilePersistence profilePersistence = a.d().getUserProfile(user.getID(), string);
                if (profilePersistence != null) {
                    string2 = profilePersistence.getName();
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        this.profileid = var8_8;
        this.profilefilename = properties.getProperty("configuration.filename");
        this.profilename = string2;
        int n = 0;
        String string3 = properties.getProperty("differences.count");
        if (string3 != null) {
            try {
                n = Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.differences = n;
    }

    @Override
    public String htmlHead() {
        return "<th>" + ComparisonAPIPlugin.MSG.getMsg("html.head.id", new Object[0]) + "</th><th>" + ComparisonAPIPlugin.MSG.getMsg("html.head.name", new Object[0]) + "</th><th>" + ComparisonAPIPlugin.MSG.getMsg("html.head.file1", new Object[0]) + "</th><th>" + ComparisonAPIPlugin.MSG.getMsg("html.head.file2", new Object[0]) + "</th><th>" + ComparisonAPIPlugin.MSG.getMsg("html.head.configname", new Object[0]) + "</th><th>" + ComparisonAPIPlugin.MSG.getMsg("html.head.configid", new Object[0]) + "</th><th>" + ComparisonAPIPlugin.MSG.getMsg("html.head.configfilename", new Object[0]) + "</th><th>" + ComparisonAPIPlugin.MSG.getMsg("html.head.state", new Object[0]) + "</th><th>" + ComparisonAPIPlugin.MSG.getMsg("html.head.difference", new Object[0]) + "</th><th>" + ComparisonAPIPlugin.MSG.getMsg("html.head.publish", new Object[0]) + "</th>";
    }

    @Override
    public String toHTML() {
        return "<td>" + this.guid + "</td><td>" + StringFunctions.encodeHTML((String)(this.name == null ? "" : this.name), (boolean)false) + "</td><td>" + StringFunctions.encodeHTML((String)(this.file1name == null ? "" : this.file1name), (boolean)false) + "</td><td>" + StringFunctions.encodeHTML((String)(this.file2name == null ? "" : this.file2name), (boolean)false) + "</td><td>" + StringFunctions.encodeHTML((String)(this.profileid == null ? "" : this.profileid), (boolean)false) + "</td><td>" + StringFunctions.encodeHTML((String)(this.profilename == null ? "" : this.profilename), (boolean)false) + "</td><td>" + StringFunctions.encodeHTML((String)(this.profilefilename == null ? "" : this.profilefilename), (boolean)false) + "</td><td>" + StringFunctions.encodeHTML((String)(this.status == null ? "" : this.status), (boolean)false) + "</td><td>" + this.differences + "</td><td>" + this.ispublic + "</td>";
    }

    @Nonnull
    public String toString() {
        return "Comparison{guid='" + this.guid + "', file1Name='" + this.name + "', file1Name='" + this.file1name + "', file2Name='" + this.file2name + "', profileID='" + this.profileid + "', profileName='" + this.profilename + "', profileFilename='" + this.profilefilename + "', status='" + this.status + "', differences=" + this.differences + ", publish=" + this.ispublic + ", created=" + this.created + ", modified=" + this.modified + "}";
    }
}

