/*
 * Decompiled with CFR 0.152.
 */
package com.inet.calendar;

import com.inet.calendar.taskplanner.server.series.CalendarSeriesFactory;
import com.inet.calendar.taskplanner.server.trigger.b;
import com.inet.classloader.I18nMessages;
import com.inet.id.GUID;
import com.inet.permissions.Permission;
import com.inet.persistence.Persistence;
import com.inet.persistence.PersistenceEntry;
import com.inet.plugin.Executable;
import com.inet.plugin.HelpProviderContainer;
import com.inet.plugin.PluginInfo;
import com.inet.plugin.ServerPlugin;
import com.inet.plugin.ServerPluginManager;
import com.inet.plugin.help.HelpProvider;
import com.inet.plugin.help.HelpProviderImpl;
import com.inet.taskplanner.server.api.TaskPlanner;
import com.inet.taskplanner.server.api.event.TaskEvent;
import com.inet.taskplanner.server.api.series.SeriesFactory;
import com.inet.taskplanner.server.api.trigger.TriggerFactory;

@PluginInfo(id="calendar", version="25.10.314", group="system;taskplanner", dependencies="", optionalDependencies="taskplanner", packages="biweekly;com.github.mangstadt.vinnie", external="", internal="biweekly.jar;vinnie.jar;jackson-core.jar", initAfter="", icon="", flags="")
public class CalendarServerPlugin
implements ServerPlugin {
    public static final I18nMessages MSG = new I18nMessages("com.inet.calendar.structure.i18n.ConfigStructure", CalendarServerPlugin.class);
    public static final String PROPERTY_START_DATE_INSTANT = "calendar.event.startDate";

    public void registerHelp(HelpProviderContainer container) {
        container.add((HelpProvider)new HelpProviderImpl("taskplanner", 9222, new Permission[]{Permission.valueOfExistingOrCreate((String)"taskplanner")}){}, new String[]{"taskplanner"});
    }

    public void registerExtension(final ServerPluginManager spm) {
        spm.runIfPluginLoaded("taskplanner", () -> new Executable(){

            public void execute() {
                spm.register(SeriesFactory.class, (Object)new CalendarSeriesFactory());
                spm.register(TriggerFactory.class, (Object)new b());
            }
        });
    }

    public void init(ServerPluginManager spm) {
        spm.runIfPluginLoaded("taskplanner", () -> new Executable(){

            public void execute() {
                TaskPlanner.getInstance().registerEventListener(taskEvent -> {
                    TaskEvent.TaskEventType taskEventType = taskEvent.getType();
                    if (taskEventType == TaskEvent.TaskEventType.DEACTIVATED || taskEventType == TaskEvent.TaskEventType.REMOVED || taskEventType == TaskEvent.TaskEventType.MODIFIED || taskEventType == TaskEvent.TaskEventType.ADDED) {
                        GUID gUID = taskEvent.getTaskID();
                        PersistenceEntry persistenceEntry = Persistence.getInstance().resolve("taskplanner").resolve("calendarseries").resolve(gUID.toString());
                        persistenceEntry.deleteValue();
                    }
                });
            }
        });
    }

    public void reset() {
    }

    public void restart() {
    }
}

