/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.json;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import java.io.IOException;

public class JCalPrettyPrinter
extends DefaultPrettyPrinter {
    private static final long serialVersionUID = 1L;
    public static final Object PROPERTY_VALUE = "ical-property";
    private static final DefaultPrettyPrinter.Indenter NEWLINE_INDENTER = DefaultIndenter.SYSTEM_LINEFEED_INSTANCE;
    private static final DefaultPrettyPrinter.Indenter INLINE_INDENTER = new DefaultPrettyPrinter.FixedSpaceIndenter();
    private DefaultPrettyPrinter.Indenter propertyIndenter;
    private DefaultPrettyPrinter.Indenter arrayIndenter;
    private DefaultPrettyPrinter.Indenter objectIndenter;

    public JCalPrettyPrinter() {
        this.propertyIndenter = INLINE_INDENTER;
        this.indentArraysWith(NEWLINE_INDENTER);
        this.indentObjectsWith(NEWLINE_INDENTER);
    }

    public JCalPrettyPrinter(JCalPrettyPrinter base) {
        super((DefaultPrettyPrinter)base);
        this.propertyIndenter = base.propertyIndenter;
        this.indentArraysWith(base.arrayIndenter);
        this.indentObjectsWith(base.objectIndenter);
    }

    public JCalPrettyPrinter createInstance() {
        return new JCalPrettyPrinter(this);
    }

    public void indentArraysWith(DefaultPrettyPrinter.Indenter indenter) {
        this.arrayIndenter = indenter;
        super.indentArraysWith(indenter);
    }

    public void indentObjectsWith(DefaultPrettyPrinter.Indenter indenter) {
        this.objectIndenter = indenter;
        super.indentObjectsWith(indenter);
    }

    public void indentICalPropertiesWith(DefaultPrettyPrinter.Indenter indenter) {
        this.propertyIndenter = indenter;
    }

    protected static boolean isInICalProperty(JsonStreamContext context) {
        if (context == null) {
            return false;
        }
        Object currentValue = context.getCurrentValue();
        if (currentValue == PROPERTY_VALUE) {
            return true;
        }
        return JCalPrettyPrinter.isInICalProperty(context.getParent());
    }

    private void updateIndenter(JsonStreamContext context) {
        boolean inICalProperty = JCalPrettyPrinter.isInICalProperty(context);
        super.indentArraysWith(inICalProperty ? this.propertyIndenter : this.arrayIndenter);
        super.indentObjectsWith(inICalProperty ? this.propertyIndenter : this.objectIndenter);
    }

    public void writeStartArray(JsonGenerator gen) throws IOException, JsonGenerationException {
        this.updateIndenter(gen.getOutputContext().getParent());
        super.writeStartArray(gen);
    }

    public void writeEndArray(JsonGenerator gen, int numValues) throws IOException, JsonGenerationException {
        this.updateIndenter(gen.getOutputContext().getParent());
        super.writeEndArray(gen, numValues);
    }

    public void writeArrayValueSeparator(JsonGenerator gen) throws IOException {
        this.updateIndenter(gen.getOutputContext().getParent());
        super.writeArrayValueSeparator(gen);
    }
}

