/*
 * Decompiled with CFR 0.152.
 */
package com.inet.calendar.taskplanner.server.trigger;

import com.inet.calendar.CalendarServerPlugin;
import com.inet.calendar.taskplanner.server.trigger.a;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.config.structure.model.UnitConfigProperty;
import com.inet.http.servlet.ClientLocale;
import com.inet.id.GUID;
import com.inet.lib.util.IOFunctions;
import com.inet.logging.LogManager;
import com.inet.taskplanner.server.api.common.AbstractDefinition;
import com.inet.taskplanner.server.api.common.AbstractInfo;
import com.inet.taskplanner.server.api.common.SummaryEntry;
import com.inet.taskplanner.server.api.common.SummaryInfo;
import com.inet.taskplanner.server.api.error.ValidationException;
import com.inet.taskplanner.server.api.field.Field;
import com.inet.taskplanner.server.api.field.FieldCondition;
import com.inet.taskplanner.server.api.field.FileField;
import com.inet.taskplanner.server.api.field.NumberField;
import com.inet.taskplanner.server.api.field.SelectField;
import com.inet.taskplanner.server.api.trigger.Trigger;
import com.inet.taskplanner.server.api.trigger.TriggerDefinition;
import com.inet.taskplanner.server.api.trigger.TriggerFactory;
import com.inet.taskplanner.server.api.trigger.TriggerInfo;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.io.FileNotFoundException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class b
extends TriggerFactory<Trigger> {
    private boolean q = false;

    public b() {
        super("taskplanner.calendar.trigger");
    }

    public TriggerInfo b(@Nullable GUID gUID) {
        URL uRL = ((Object)((Object)this)).getClass().getResource("calendar_32.png");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("calendar.event.summary");
        arrayList.add("calendar.event.description");
        arrayList.add("calendar.event.comments");
        arrayList.add("calendar.event.creationDate");
        arrayList.add("calendar.event.startDate");
        arrayList.add("calendar.event.endDate");
        arrayList.add("calendar.event.startDatePretty");
        arrayList.add("calendar.event.endDatePretty");
        arrayList.add("calendar.event.organizerName");
        arrayList.add("calendar.event.organizerEmail");
        arrayList.add("calendar.event.priority");
        arrayList.add("calendar.event.attendee");
        return new TriggerInfo("taskplanner.calendar.trigger", CalendarServerPlugin.MSG.getMsg("CalendarTrigger.name", new Object[0]), CalendarServerPlugin.MSG.getMsg("CalendarTrigger.desc", new Object[0]), uRL, "taskplanner.trigger.calendar", this.d(), arrayList);
    }

    private List<Field> d() {
        ArrayList<Field> arrayList = new ArrayList<Field>();
        FileField fileField = new FileField("file", CalendarServerPlugin.MSG.getMsg("series.calendar.file", new Object[0]));
        fileField.setProtocols(this.getAllAvailableProtocols());
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add("*.ics");
        arrayList2.add("*.cal");
        arrayList2.add("*.*");
        fileField.setFilter(arrayList2);
        arrayList.add((Field)fileField);
        ArrayList<LocalizedKey> arrayList3 = new ArrayList<LocalizedKey>();
        arrayList3.add(new LocalizedKey("before", CalendarServerPlugin.MSG.getMsg("trigger.calendar.beforeOrAfter.before", new Object[0])));
        arrayList3.add(new LocalizedKey("at", CalendarServerPlugin.MSG.getMsg("trigger.calendar.beforeOrAfter.at", new Object[0])));
        arrayList3.add(new LocalizedKey("after", CalendarServerPlugin.MSG.getMsg("trigger.calendar.beforeOrAfter.after", new Object[0])));
        SelectField selectField = new SelectField("beforeOrAfter", CalendarServerPlugin.MSG.getMsg("trigger.calendar.beforeOrAfter", new Object[0]), arrayList3);
        selectField.setValue("before");
        arrayList.add((Field)selectField);
        ArrayList<UnitConfigProperty.Unit> arrayList4 = new ArrayList<UnitConfigProperty.Unit>();
        arrayList4.add(new UnitConfigProperty.Unit(2.48015873015873E-5, CalendarServerPlugin.MSG.getMsg("series.calendar.months", new Object[0])));
        arrayList4.add(new UnitConfigProperty.Unit(9.92063492063492E-5, CalendarServerPlugin.MSG.getMsg("series.calendar.weeks", new Object[0])));
        arrayList4.add(new UnitConfigProperty.Unit(6.944444444444444E-4, CalendarServerPlugin.MSG.getMsg("series.calendar.days", new Object[0])));
        arrayList4.add(new UnitConfigProperty.Unit(0.016666666666666666, CalendarServerPlugin.MSG.getMsg("trigger.calendar.hours", new Object[0])));
        arrayList4.add(new UnitConfigProperty.Unit(1.0, CalendarServerPlugin.MSG.getMsg("trigger.calendar.minutes", new Object[0])));
        NumberField numberField = new NumberField("howFarBefore", CalendarServerPlugin.MSG.getMsg("trigger.calendar.howfarbefore", new Object[0]), arrayList4);
        numberField.setValue("60");
        ArrayList<FieldCondition> arrayList5 = new ArrayList<FieldCondition>();
        arrayList5.add(FieldCondition.visible((Field)selectField, (FieldCondition.OP)FieldCondition.OP.equals, (String)"before"));
        numberField.setConditions(arrayList5);
        arrayList.add((Field)numberField);
        NumberField numberField2 = new NumberField("howFarAfter", CalendarServerPlugin.MSG.getMsg("trigger.calendar.howfarafter", new Object[0]), arrayList4);
        numberField2.setValue("60");
        ArrayList<FieldCondition> arrayList6 = new ArrayList<FieldCondition>();
        arrayList6.add(FieldCondition.visible((Field)selectField, (FieldCondition.OP)FieldCondition.OP.equals, (String)"after"));
        numberField2.setConditions(arrayList6);
        arrayList.add((Field)numberField2);
        return arrayList;
    }

    protected List<String> getAllAvailableProtocols() {
        return FileField.getAllAvailableProtocols();
    }

    public void a(@Nonnull TriggerDefinition triggerDefinition, GUID gUID) throws ValidationException {
        String string = triggerDefinition.getProperty("file");
        if (string == null || string.trim().isEmpty()) {
            throw new ValidationException(new String[]{CalendarServerPlugin.MSG.getMsg("trigger.calendar.error.nocal", new Object[0])});
        }
        String string2 = triggerDefinition.getProperty("howFarBefore");
        String string3 = triggerDefinition.getProperty("howFarAfter");
        String string4 = triggerDefinition.getProperty("beforeOrAfter");
        if (string4 != null ? ("after".equals(string4) ? string3 == null || string3.trim().isEmpty() || Long.valueOf(string3) < 0L : string2 == null || string2.trim().isEmpty() || Long.valueOf(string2) < 0L) : string2 == null || string2.trim().isEmpty() || Long.valueOf(string2) < 0L) {
            throw new ValidationException(new String[]{CalendarServerPlugin.MSG.getMsg("trigger.calendar.error.beforemustbezeroorpositive", new Object[0])});
        }
        try {
            List<Map<String, String>> list = this.a(Instant.now(), IOFunctions.getURLFromString((String)string), triggerDefinition);
        }
        catch (RuntimeException runtimeException) {
            if (runtimeException.getCause() instanceof FileNotFoundException && string.startsWith("http")) {
                throw new ValidationException(new String[]{CalendarServerPlugin.MSG.getMsg("trigger.calendar.error.urlnotaccessible", new Object[0])});
            }
            throw new ValidationException(new String[]{runtimeException.getMessage()});
        }
    }

    public SummaryInfo a(@Nonnull TriggerDefinition triggerDefinition) {
        ArrayList<SummaryEntry> arrayList = new ArrayList<SummaryEntry>();
        String string = triggerDefinition.getProperty("file");
        String string2 = triggerDefinition.getProperty("howFarBefore");
        String string3 = triggerDefinition.getProperty("howFarAfter");
        String string4 = triggerDefinition.getProperty("beforeOrAfter");
        boolean bl = false;
        boolean bl2 = false;
        if (string4 != null) {
            if ("after".equals(string4)) {
                bl = true;
            } else if ("at".equals(string4)) {
                bl2 = true;
            }
        }
        if (string != null && !string.isEmpty() && IOFunctions.getURLFromString((String)string) != null) {
            arrayList.add(new SummaryEntry(null, CalendarServerPlugin.MSG.getMsg("trigger.calendar.url", new Object[]{string})));
        }
        int n = 0;
        if (bl) {
            n = Integer.valueOf(string3);
        } else if (!bl2) {
            n = Integer.valueOf(string2);
        }
        if (n > 0 && bl) {
            String string5 = "trigger.calendar.howFarAfter.description";
            SummaryEntry summaryEntry = this.a(triggerDefinition, n, string5);
            arrayList.add(summaryEntry);
        } else if (n > 0 && !bl2) {
            String string6 = "trigger.calendar.howFarBefore.description";
            SummaryEntry summaryEntry = this.a(triggerDefinition, n, string6);
            arrayList.add(summaryEntry);
        } else {
            String string7 = "trigger.calendar.howFarBefore.zero.description";
            SummaryEntry summaryEntry = this.a(triggerDefinition, n, string7);
            arrayList.add(summaryEntry);
        }
        return new SummaryInfo(arrayList);
    }

    private SummaryEntry a(TriggerDefinition triggerDefinition, int n, String string) {
        String string2;
        Object object;
        int n2 = n;
        n2 = Math.abs(n2);
        Object object2 = "trigger.calendar.description.minute";
        if (n2 >= 60 && n2 % 60 == 0) {
            object2 = "trigger.calendar.description.hour";
            if ((n2 /= 60) >= 24 && n2 % 24 == 0) {
                object2 = "trigger.calendar.description.day";
                if ((n2 /= 24) >= 7 && n2 % 7 == 0) {
                    object2 = "trigger.calendar.description.week";
                    n2 /= 7;
                }
            }
        }
        if (n2 > 1) {
            object2 = (String)object2 + "s";
        }
        Optional<ZonedDateTime> optional = this.getNextExecutionTimes(triggerDefinition).stream().filter(zonedDateTime -> zonedDateTime.isAfter(ZonedDateTime.now())).findFirst();
        Object object3 = " ";
        if (optional.isPresent()) {
            object = (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(2, 3, ClientLocale.getThreadLocale());
            string2 = ((SimpleDateFormat)object).toPattern();
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(string2);
            object3 = (String)object3 + CalendarServerPlugin.MSG.getMsg("trigger.calendar.nextEvent", new Object[]{optional.get().format(dateTimeFormatter)});
        } else {
            object3 = (String)object3 + CalendarServerPlugin.MSG.getMsg("trigger.calendar.noNextEvents", new Object[0]);
        }
        object = n2 == 1 ? "" : n2 + " ";
        string2 = n == 0 ? CalendarServerPlugin.MSG.getMsg(string, new Object[0]) : CalendarServerPlugin.MSG.getMsg(string, new Object[]{object, CalendarServerPlugin.MSG.getMsg((String)object2, new Object[0])});
        return new SummaryEntry(null, string2 + (String)object3);
    }

    public List<ZonedDateTime> getNextExecutionTimes(TriggerDefinition definition) {
        String string = definition.getProperty("file");
        String string2 = definition.getProperty("howFarBefore");
        String string3 = definition.getProperty("howFarAfter");
        String string4 = definition.getProperty("beforeOrAfter");
        long l = 0L;
        if (string4 != null) {
            if ("after".equals(string4)) {
                l = -(string3.isEmpty() ? 0L : Long.valueOf(string3));
            } else if (!"at".equals(string4)) {
                l = string2.isEmpty() ? 0L : Long.valueOf(string2);
            }
        }
        Instant instant = Instant.now();
        try {
            List<Map<String, String>> list = this.a(instant, IOFunctions.getURLFromString((String)string), definition);
            List<ZonedDateTime> list2 = b.a(l, list);
            ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(instant, ZoneId.systemDefault());
            return list2.stream().filter(zonedDateTime2 -> zonedDateTime2.isAfter(zonedDateTime)).collect(Collectors.toList());
        }
        catch (RuntimeException runtimeException) {
            LogManager.getApplicationLogger().error((Throwable)runtimeException);
            return new ArrayList<ZonedDateTime>();
        }
    }

    static List<ZonedDateTime> a(long l, List<Map<String, String>> list) {
        List<ZonedDateTime> list2 = list.stream().map(map -> (String)map.get("calendar.event.startDate")).filter(Objects::nonNull).map(string -> Instant.parse(string).minusSeconds(l * 60L)).map(instant -> ZonedDateTime.ofInstant(instant, ZoneId.systemDefault())).sorted().collect(Collectors.toList());
        return list2;
    }

    private List<Map<String, String>> a(Instant instant, URL uRL, TriggerDefinition triggerDefinition) {
        Integer n = b.b(triggerDefinition);
        return com.inet.calendar.taskplanner.server.series.a.a(uRL, instant.plusSeconds(n * 60), instant.plusMillis(315360000000L));
    }

    protected Trigger b(@Nonnull TriggerDefinition triggerDefinition, @Nullable GUID gUID) {
        String string = triggerDefinition.getProperty("file");
        Integer n = b.b(triggerDefinition);
        return new a(string, n);
    }

    @Nonnull
    private static Integer b(TriggerDefinition triggerDefinition) {
        String string = triggerDefinition.getProperty("howFarBefore");
        String string2 = triggerDefinition.getProperty("howFarAfter");
        String string3 = triggerDefinition.getProperty("beforeOrAfter");
        Integer n = 0;
        if (string3 != null) {
            if ("after".equals(string3)) {
                n = -(string2.isEmpty() ? 0 : Integer.valueOf(string2));
            } else if (!"at".equals(string3)) {
                n = string.isEmpty() ? 0 : Integer.valueOf(string);
            }
        } else {
            n = string.isEmpty() ? 0 : Integer.valueOf(string);
        }
        return n;
    }

    public boolean isAvailable() {
        UserAccount userAccount = UserManager.getInstance().getCurrentUserAccount();
        return userAccount != null;
    }

    public /* synthetic */ void validate(@Nonnull AbstractDefinition abstractDefinition, GUID gUID) throws ValidationException {
        this.a((TriggerDefinition)abstractDefinition, gUID);
    }

    public /* synthetic */ SummaryInfo getSummary(@Nonnull AbstractDefinition abstractDefinition) {
        return this.a((TriggerDefinition)abstractDefinition);
    }

    protected /* synthetic */ Object createInstanceFrom(@Nonnull AbstractDefinition abstractDefinition, @Nullable GUID gUID) {
        return this.b((TriggerDefinition)abstractDefinition, gUID);
    }

    public /* synthetic */ AbstractInfo getInformation(@Nullable GUID gUID) {
        return this.b(gUID);
    }
}

