/*
 * Decompiled with CFR 0.152.
 */
package biweekly.util.com.google.ical.iter;

import biweekly.util.ByDay;
import biweekly.util.DayOfWeek;
import biweekly.util.com.google.ical.iter.Util;
import biweekly.util.com.google.ical.util.DTBuilder;
import biweekly.util.com.google.ical.util.Predicate;
import biweekly.util.com.google.ical.util.Predicates;
import biweekly.util.com.google.ical.util.TimeUtils;
import biweekly.util.com.google.ical.values.DateValue;
import biweekly.util.com.google.ical.values.TimeValue;

class Filters {
    private static final int LOW_24_BITS = 0xFFFFFF;
    private static final long LOW_60_BITS = 0xFFFFFFFFFFFFFFFL;

    static Predicate<DateValue> byDayFilter(final ByDay[] days, final boolean weeksInYear, final DayOfWeek weekStart) {
        return new Predicate<DateValue>(){
            private static final long serialVersionUID = 1636822853835207274L;

            @Override
            public boolean apply(DateValue date) {
                int instance;
                DayOfWeek firstDayOfWeek;
                int nDays;
                DayOfWeek dow = TimeUtils.dayOfWeek(date);
                if (weeksInYear) {
                    nDays = TimeUtils.yearLength(date.year());
                    firstDayOfWeek = TimeUtils.firstDayOfWeekInMonth(date.year(), 1);
                    instance = TimeUtils.dayOfYear(date.year(), date.month(), date.day());
                } else {
                    nDays = TimeUtils.monthLength(date.year(), date.month());
                    firstDayOfWeek = TimeUtils.firstDayOfWeekInMonth(date.year(), date.month());
                    instance = date.day() - 1;
                }
                int dateWeekNo = instance / 7;
                if (weekStart.getCalendarConstant() <= dow.getCalendarConstant()) {
                    ++dateWeekNo;
                }
                for (int i = days.length - 1; i >= 0; --i) {
                    ByDay day = days[i];
                    if (day.getDay() != dow) continue;
                    Integer weekNo = day.getNum();
                    if (weekNo == null || weekNo == 0) {
                        return true;
                    }
                    if (weekNo < 0) {
                        weekNo = Util.invertWeekdayNum(day, firstDayOfWeek, nDays);
                    }
                    if (dateWeekNo != weekNo) continue;
                    return true;
                }
                return false;
            }
        };
    }

    static Predicate<DateValue> byMonthDayFilter(final int[] monthDays) {
        return new Predicate<DateValue>(){
            private static final long serialVersionUID = -1618039447294490037L;

            @Override
            public boolean apply(DateValue date) {
                int nDays = TimeUtils.monthLength(date.year(), date.month());
                for (int i = monthDays.length - 1; i >= 0; --i) {
                    int day = monthDays[i];
                    if (day < 0) {
                        day += nDays + 1;
                    }
                    if (day != date.day()) continue;
                    return true;
                }
                return false;
            }
        };
    }

    static Predicate<DateValue> weekIntervalFilter(final int interval, final DayOfWeek weekStart, final DateValue dtStart) {
        return new Predicate<DateValue>(){
            private static final long serialVersionUID = 7059994888520369846L;
            DateValue wkStart;
            {
                DTBuilder wkStartB = new DTBuilder(dtStart);
                wkStartB.day -= (7 + TimeUtils.dayOfWeek(dtStart).getCalendarConstant() - weekStart.getCalendarConstant()) % 7;
                this.wkStart = wkStartB.toDate();
            }

            @Override
            public boolean apply(DateValue date) {
                int off;
                int daysBetween = TimeUtils.daysBetween(date, this.wkStart);
                if (daysBetween < 0) {
                    daysBetween += interval * 7 * (1 + daysBetween / (-7 * interval));
                }
                return (off = daysBetween / 7 % interval) == 0;
            }
        };
    }

    static Predicate<DateValue> byHourFilter(int[] hours) {
        int hoursByBit = 0;
        for (int hour : hours) {
            hoursByBit |= 1 << hour;
        }
        if ((hoursByBit & 0xFFFFFF) == 0xFFFFFF) {
            return Predicates.alwaysTrue();
        }
        final int bitField = hoursByBit;
        return new Predicate<DateValue>(){
            private static final long serialVersionUID = -6284974028385246889L;

            @Override
            public boolean apply(DateValue date) {
                if (!(date instanceof TimeValue)) {
                    return false;
                }
                TimeValue tv = (TimeValue)((Object)date);
                return (bitField & 1 << tv.hour()) != 0;
            }
        };
    }

    static Predicate<DateValue> byMinuteFilter(int[] minutes) {
        long minutesByBit = 0L;
        for (int minute : minutes) {
            minutesByBit |= 1L << minute;
        }
        if ((minutesByBit & 0xFFFFFFFFFFFFFFFL) == 0xFFFFFFFFFFFFFFFL) {
            return Predicates.alwaysTrue();
        }
        final long bitField = minutesByBit;
        return new Predicate<DateValue>(){
            private static final long serialVersionUID = 5028303473420393470L;

            @Override
            public boolean apply(DateValue date) {
                if (!(date instanceof TimeValue)) {
                    return false;
                }
                TimeValue tv = (TimeValue)((Object)date);
                return (bitField & 1L << tv.minute()) != 0L;
            }
        };
    }

    static Predicate<DateValue> bySecondFilter(int[] seconds) {
        long secondsByBit = 0L;
        for (int second : seconds) {
            secondsByBit |= 1L << second;
        }
        if ((secondsByBit & 0xFFFFFFFFFFFFFFFL) == 0xFFFFFFFFFFFFFFFL) {
            return Predicates.alwaysTrue();
        }
        final long bitField = secondsByBit;
        return new Predicate<DateValue>(){
            private static final long serialVersionUID = 4109739845053177924L;

            @Override
            public boolean apply(DateValue date) {
                if (!(date instanceof TimeValue)) {
                    return false;
                }
                TimeValue tv = (TimeValue)((Object)date);
                return (bitField & 1L << tv.second()) != 0L;
            }
        };
    }

    private Filters() {
    }
}

