/*
 * Decompiled with CFR 0.152.
 */
package biweekly.util;

import biweekly.util.ByDay;
import biweekly.util.DayOfWeek;
import biweekly.util.Frequency;
import biweekly.util.Google2445Utils;
import biweekly.util.ICalDate;
import biweekly.util.ListMultimap;
import biweekly.util.com.google.ical.compat.javautil.DateIterator;
import biweekly.util.com.google.ical.compat.javautil.DateIteratorFactory;
import biweekly.util.com.google.ical.iter.RecurrenceIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public final class Recurrence {
    private final Frequency frequency;
    private final Integer interval;
    private final Integer count;
    private final ICalDate until;
    private final List<Integer> bySecond;
    private final List<Integer> byMinute;
    private final List<Integer> byHour;
    private final List<Integer> byMonthDay;
    private final List<Integer> byYearDay;
    private final List<Integer> byWeekNo;
    private final List<Integer> byMonth;
    private final List<Integer> bySetPos;
    private final List<ByDay> byDay;
    private final DayOfWeek workweekStarts;
    private final Map<String, List<String>> xrules;

    private Recurrence(Builder builder) {
        this.frequency = builder.frequency;
        this.interval = builder.interval;
        this.count = builder.count;
        this.until = builder.until;
        this.bySecond = Collections.unmodifiableList(builder.bySecond);
        this.byMinute = Collections.unmodifiableList(builder.byMinute);
        this.byHour = Collections.unmodifiableList(builder.byHour);
        this.byMonthDay = Collections.unmodifiableList(builder.byMonthDay);
        this.byYearDay = Collections.unmodifiableList(builder.byYearDay);
        this.byWeekNo = Collections.unmodifiableList(builder.byWeekNo);
        this.byMonth = Collections.unmodifiableList(builder.byMonth);
        this.bySetPos = Collections.unmodifiableList(builder.bySetPos);
        this.byDay = Collections.unmodifiableList(builder.byDay);
        this.workweekStarts = builder.workweekStarts;
        this.xrules = Collections.unmodifiableMap(builder.xrules.getMap());
    }

    public Frequency getFrequency() {
        return this.frequency;
    }

    public ICalDate getUntil() {
        return this.until == null ? null : new ICalDate(this.until);
    }

    public Integer getCount() {
        return this.count;
    }

    public Integer getInterval() {
        return this.interval;
    }

    public List<Integer> getBySecond() {
        return this.bySecond;
    }

    public List<Integer> getByMinute() {
        return this.byMinute;
    }

    public List<Integer> getByHour() {
        return this.byHour;
    }

    public List<ByDay> getByDay() {
        return this.byDay;
    }

    public List<Integer> getByMonthDay() {
        return this.byMonthDay;
    }

    public List<Integer> getByYearDay() {
        return this.byYearDay;
    }

    public List<Integer> getByWeekNo() {
        return this.byWeekNo;
    }

    public List<Integer> getByMonth() {
        return this.byMonth;
    }

    public List<Integer> getBySetPos() {
        return this.bySetPos;
    }

    public DayOfWeek getWorkweekStarts() {
        return this.workweekStarts;
    }

    public Map<String, List<String>> getXRules() {
        return this.xrules;
    }

    public DateIterator getDateIterator(Date startDate, TimeZone timezone) {
        return this.getDateIterator(new ICalDate(startDate), timezone);
    }

    public DateIterator getDateIterator(ICalDate startDate, TimeZone timezone) {
        RecurrenceIterator iterator = Google2445Utils.createRecurrenceIterator(this, startDate, timezone);
        return DateIteratorFactory.createDateIterator(iterator);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.byDay.hashCode();
        result = 31 * result + this.byHour.hashCode();
        result = 31 * result + this.byMinute.hashCode();
        result = 31 * result + this.byMonth.hashCode();
        result = 31 * result + this.byMonthDay.hashCode();
        result = 31 * result + this.bySecond.hashCode();
        result = 31 * result + this.bySetPos.hashCode();
        result = 31 * result + this.byWeekNo.hashCode();
        result = 31 * result + this.byYearDay.hashCode();
        result = 31 * result + (this.count == null ? 0 : this.count.hashCode());
        result = 31 * result + this.xrules.hashCode();
        result = 31 * result + (this.frequency == null ? 0 : this.frequency.hashCode());
        result = 31 * result + (this.interval == null ? 0 : this.interval.hashCode());
        result = 31 * result + (this.until == null ? 0 : this.until.hashCode());
        result = 31 * result + (this.workweekStarts == null ? 0 : this.workweekStarts.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Recurrence other = (Recurrence)obj;
        if (!this.byDay.equals(other.byDay)) {
            return false;
        }
        if (!this.byHour.equals(other.byHour)) {
            return false;
        }
        if (!this.byMinute.equals(other.byMinute)) {
            return false;
        }
        if (!this.byMonth.equals(other.byMonth)) {
            return false;
        }
        if (!this.byMonthDay.equals(other.byMonthDay)) {
            return false;
        }
        if (!this.bySecond.equals(other.bySecond)) {
            return false;
        }
        if (!this.bySetPos.equals(other.bySetPos)) {
            return false;
        }
        if (!this.byWeekNo.equals(other.byWeekNo)) {
            return false;
        }
        if (!this.byYearDay.equals(other.byYearDay)) {
            return false;
        }
        if (this.count == null ? other.count != null : !this.count.equals(other.count)) {
            return false;
        }
        if (!this.xrules.equals(other.xrules)) {
            return false;
        }
        if (this.frequency != other.frequency) {
            return false;
        }
        if (this.interval == null ? other.interval != null : !this.interval.equals(other.interval)) {
            return false;
        }
        if (this.until == null ? other.until != null : !this.until.equals(other.until)) {
            return false;
        }
        return this.workweekStarts == other.workweekStarts;
    }

    public static class Builder {
        private Frequency frequency;
        private Integer interval;
        private Integer count;
        private ICalDate until;
        private List<Integer> bySecond;
        private List<Integer> byMinute;
        private List<Integer> byHour;
        private List<ByDay> byDay;
        private List<Integer> byMonthDay;
        private List<Integer> byYearDay;
        private List<Integer> byWeekNo;
        private List<Integer> byMonth;
        private List<Integer> bySetPos;
        private DayOfWeek workweekStarts;
        private ListMultimap<String, String> xrules;

        public Builder(Frequency frequency) {
            this.frequency = frequency;
            this.bySecond = new ArrayList<Integer>(0);
            this.byMinute = new ArrayList<Integer>(0);
            this.byHour = new ArrayList<Integer>(0);
            this.byDay = new ArrayList<ByDay>(0);
            this.byMonthDay = new ArrayList<Integer>(0);
            this.byYearDay = new ArrayList<Integer>(0);
            this.byWeekNo = new ArrayList<Integer>(0);
            this.byMonth = new ArrayList<Integer>(0);
            this.bySetPos = new ArrayList<Integer>(0);
            this.xrules = new ListMultimap(0);
        }

        public Builder(Recurrence recur) {
            this.frequency = recur.frequency;
            this.interval = recur.interval;
            this.count = recur.count;
            this.until = recur.until;
            this.bySecond = new ArrayList<Integer>(recur.bySecond);
            this.byMinute = new ArrayList<Integer>(recur.byMinute);
            this.byHour = new ArrayList<Integer>(recur.byHour);
            this.byDay = new ArrayList<ByDay>(recur.byDay);
            this.byMonthDay = new ArrayList<Integer>(recur.byMonthDay);
            this.byYearDay = new ArrayList<Integer>(recur.byYearDay);
            this.byWeekNo = new ArrayList<Integer>(recur.byWeekNo);
            this.byMonth = new ArrayList<Integer>(recur.byMonth);
            this.bySetPos = new ArrayList<Integer>(recur.bySetPos);
            this.workweekStarts = recur.workweekStarts;
            HashMap map = new HashMap(recur.xrules);
            this.xrules = new ListMultimap(map);
        }

        public Builder frequency(Frequency frequency) {
            this.frequency = frequency;
            return this;
        }

        public Builder until(ICalDate until) {
            this.until = until == null ? null : new ICalDate(until);
            return this;
        }

        public Builder until(Date until) {
            return this.until(until, true);
        }

        public Builder until(Date until, boolean hasTime) {
            this.until = new ICalDate(until, hasTime);
            return this;
        }

        public Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public Builder interval(Integer interval) {
            this.interval = interval;
            return this;
        }

        public Builder bySecond(Integer ... seconds) {
            return this.bySecond(Arrays.asList(seconds));
        }

        public Builder bySecond(Collection<Integer> seconds) {
            this.bySecond.addAll(seconds);
            return this;
        }

        public Builder byMinute(Integer ... minutes) {
            return this.byMinute(Arrays.asList(minutes));
        }

        public Builder byMinute(Collection<Integer> minutes) {
            this.byMinute.addAll(minutes);
            return this;
        }

        public Builder byHour(Integer ... hours) {
            return this.byHour(Arrays.asList(hours));
        }

        public Builder byHour(Collection<Integer> hours) {
            this.byHour.addAll(hours);
            return this;
        }

        public Builder byMonthDay(Integer ... monthDays) {
            return this.byMonthDay(Arrays.asList(monthDays));
        }

        public Builder byMonthDay(Collection<Integer> monthDays) {
            this.byMonthDay.addAll(monthDays);
            return this;
        }

        public Builder byYearDay(Integer ... yearDays) {
            return this.byYearDay(Arrays.asList(yearDays));
        }

        public Builder byYearDay(Collection<Integer> yearDays) {
            this.byYearDay.addAll(yearDays);
            return this;
        }

        public Builder byWeekNo(Integer ... weekNumbers) {
            return this.byWeekNo(Arrays.asList(weekNumbers));
        }

        public Builder byWeekNo(Collection<Integer> weekNumbers) {
            this.byWeekNo.addAll(weekNumbers);
            return this;
        }

        public Builder byMonth(Integer ... months) {
            return this.byMonth(Arrays.asList(months));
        }

        public Builder byMonth(Collection<Integer> months) {
            this.byMonth.addAll(months);
            return this;
        }

        public Builder bySetPos(Integer ... positions) {
            return this.bySetPos(Arrays.asList(positions));
        }

        public Builder bySetPos(Collection<Integer> positions) {
            this.bySetPos.addAll(positions);
            return this;
        }

        public Builder byDay(DayOfWeek ... days) {
            return this.byDay(Arrays.asList(days));
        }

        public Builder byDay(Collection<DayOfWeek> days) {
            for (DayOfWeek day : days) {
                this.byDay((Integer)null, day);
            }
            return this;
        }

        public Builder byDay(Integer num, DayOfWeek day) {
            this.byDay.add(new ByDay(num, day));
            return this;
        }

        public Builder workweekStarts(DayOfWeek day) {
            this.workweekStarts = day;
            return this;
        }

        public Builder xrule(String name, String value) {
            name = name.toUpperCase();
            if (value == null) {
                this.xrules.removeAll(name);
            } else {
                this.xrules.put(name, value);
            }
            return this;
        }

        public Recurrence build() {
            return new Recurrence(this);
        }
    }
}

