/*
 * Decompiled with CFR 0.152.
 */
package com.inet.calendar.taskplanner.server.series;

import biweekly.component.VEvent;
import biweekly.io.text.ICalReader;
import biweekly.property.Attendee;
import biweekly.property.TextProperty;
import biweekly.util.ICalDate;
import biweekly.util.com.google.ical.compat.javautil.DateIterator;
import com.inet.calendar.CalendarServerPlugin;
import com.inet.http.servlet.ClientLocale;
import com.inet.http.servlet.ClientTimezone;
import com.inet.id.GUID;
import com.inet.lib.io.FastBufferedInputStream;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonException;
import com.inet.lib.util.IOFunctions;
import com.inet.permissions.AccessDeniedException;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.persistence.Persistence;
import com.inet.persistence.PersistenceEntry;
import com.inet.taskplanner.server.api.series.Series;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.DateFormat;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.SuppressFBWarnings;

public class a
implements Series {
    private GUID c;
    private final URL d;
    private Instant e;
    private Instant f;
    private static Map<String, Set<String>> g = Collections.synchronizedMap(new HashMap());

    public a(GUID gUID, String string, Integer n, Integer n2) {
        this.c = gUID;
        this.d = IOFunctions.getURLFromString((String)string);
        this.e = this.b().plus(Duration.ofDays(n.longValue()));
        this.f = this.b().plus(Duration.ofDays(n2.longValue()));
        if ("file".equals(this.d.getProtocol()) && ((Boolean)SystemPermissionChecker.SYSTEMPERMISSION_ENABLED.get()).booleanValue() && !SystemPermissionChecker.checkAccess((Permission)Permission.CONFIGURATION)) {
            throw new RuntimeException(CalendarServerPlugin.MSG.getMsg("taskplanner.fileAccessDenied", new Object[]{Permission.CONFIGURATION.getDisplayName()}));
        }
    }

    protected Instant b() {
        return Instant.now();
    }

    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="File access is secured for admin users only. Other URLs have to deliver in JSON format.")
    public Iterator<Map<String, String>> iterator() {
        List<Map<String, String>> list = this.c();
        PersistenceEntry persistenceEntry = Persistence.getInstance().resolve("taskplanner").resolve("calendarseries").resolve(this.c.toString());
        Set<String> set = this.a(persistenceEntry);
        g.put(this.c.toString(), set);
        list = list.stream().filter(map -> !set.contains(map.getOrDefault("calendar.event.startDate", ""))).collect(Collectors.toList());
        set.addAll(list.stream().map(map -> map.getOrDefault("calendar.event.startDate", "")).collect(Collectors.toList()));
        persistenceEntry = Persistence.getInstance().resolve("taskplanner").resolve("calendarseries").resolve("tmp" + this.c.toString());
        persistenceEntry.setString(new Json().toJson(set));
        return list.iterator();
    }

    protected List<Map<String, String>> c() {
        return a.a(this.d, this.e, this.f);
    }

    private Set<String> a(PersistenceEntry persistenceEntry) {
        String string = persistenceEntry.getString();
        Set<String> set = new HashSet<String>();
        if (string != null) {
            Set set2 = (Set)new Json().fromJson(string, Set.class);
            set = set2.stream().map(Object::toString).collect(Collectors.toSet());
        }
        return set;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="Opening this url is the whole point. Files are already checked re: permissions beforehand.")
    public static List<Map<String, String>> a(URL uRL, Instant instant, Instant instant2) {
        try (FastBufferedInputStream fastBufferedInputStream = new FastBufferedInputStream(uRL.openStream());){
            ArrayList<Map<String, String>> arrayList;
            try (ICalReader iCalReader = new ICalReader((InputStream)fastBufferedInputStream);){
                ArrayList<Map<String, String>> arrayList2 = new ArrayList<Map<String, String>>();
                iCalReader.readAll().forEach(iCalendar -> iCalendar.getEvents().forEach(vEvent -> {
                    Object object;
                    DateIterator dateIterator = vEvent.getDateIterator(TimeZone.getDefault());
                    dateIterator.advanceTo(Date.from(instant));
                    if (dateIterator.hasNext()) {
                        object = (Date)dateIterator.next();
                        if (a.a(instant, instant2, ((Date)object).toInstant())) {
                            return;
                        }
                    } else {
                        return;
                    }
                    Date date = object;
                    object = a.a(vEvent, date);
                    arrayList2.add((Map<String, String>)object);
                }));
                arrayList = arrayList2;
            }
            return arrayList;
        }
        catch (JsonException | AccessDeniedException | IOException throwable) {
            throw new RuntimeException(CalendarServerPlugin.MSG.getMsg("series.calendar.error", new Object[]{uRL}), throwable);
        }
    }

    static Map<String, String> a(VEvent vEvent, Date date) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("calendar.event.summary", "");
        hashMap.put("calendar.event.description", "");
        hashMap.put("calendar.event.comments", "");
        hashMap.put("calendar.event.creationDate", "");
        hashMap.put("calendar.event.startDate", "");
        hashMap.put("calendar.event.endDate", "");
        hashMap.put("calendar.event.startDatePretty", "");
        hashMap.put("calendar.event.endDatePretty", "");
        hashMap.put("calendar.event.organizerName", "");
        hashMap.put("calendar.event.organizerEmail", "");
        hashMap.put("calendar.event.priority", "");
        hashMap.put("calendar.event.attendee", "");
        a.a(vEvent.getSummary(), (T summary) -> hashMap.put("calendar.event.summary", (String)summary.getValue()));
        a.a(vEvent.getDescription(), (T description) -> hashMap.put("calendar.event.description", (String)description.getValue()));
        a.a(vEvent.getComments(), (T list) -> hashMap.put("calendar.event.comments", a.a("\n\n", (List<? extends TextProperty>)list)));
        a.a(vEvent.getCreated(), (T created) -> hashMap.put("calendar.event.creationDate", ((Date)created.getValue()).toInstant().toString()));
        DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2, ClientLocale.getThreadLocale());
        dateFormat.setTimeZone(ClientTimezone.getTimeZone());
        a.a(vEvent.getDateStart(), (T dateStart) -> hashMap.put("calendar.event.startDatePretty", dateFormat.format(date)));
        a.a(vEvent.getDateEnd(), (T dateEnd) -> hashMap.put("calendar.event.endDatePretty", dateFormat.format((Date)vEvent.getDateEnd().getValue())));
        a.a(vEvent.getDateStart(), (T dateStart) -> hashMap.put("calendar.event.startDate", date.toInstant().toString()));
        a.a(vEvent.getDateEnd(), (T dateEnd) -> hashMap.put("calendar.event.endDate", ((ICalDate)dateEnd.getValue()).toInstant().toString()));
        a.a(vEvent.getOrganizer(), (T organizer) -> {
            hashMap.put("calendar.event.organizerName", organizer.getCommonName());
            hashMap.put("calendar.event.organizerEmail", organizer.getEmail());
        });
        a.a(vEvent.getPriority(), (T priority) -> hashMap.put("calendar.event.priority", ((Integer)priority.getValue()).toString()));
        a.a(vEvent.getAttendees(), (T list) -> hashMap.put("calendar.event.attendee", a.b("; ", (List<? extends Attendee>)list)));
        return hashMap;
    }

    private static boolean a(Instant instant, Instant instant2, @Nonnull Instant instant3) {
        return instant.isAfter(instant3) && instant2.isAfter(instant3) || instant2.isBefore(instant3) && instant.isBefore(instant3);
    }

    private static <T> void a(T t, Consumer<T> consumer) {
        if (t != null) {
            consumer.accept(t);
        }
    }

    private static String a(String string, List<? extends TextProperty> list) {
        if (list == null) {
            return "";
        }
        return String.join((CharSequence)string, list.stream().map(textProperty -> (String)textProperty.getValue()).collect(Collectors.toList()));
    }

    private static String b(String string, List<? extends Attendee> list) {
        if (list == null) {
            return "";
        }
        return String.join((CharSequence)string, list.stream().map(attendee -> attendee.getCommonName()).collect(Collectors.toList()));
    }

    public void cleanUp(boolean previewOnly) throws Exception {
        if (!previewOnly) {
            PersistenceEntry persistenceEntry = Persistence.getInstance().resolve("taskplanner").resolve("calendarseries").resolve("tmp" + this.c.toString());
            PersistenceEntry persistenceEntry2 = Persistence.getInstance().resolve("taskplanner").resolve("calendarseries").resolve(this.c.toString());
            String string = persistenceEntry.getString();
            if (string != null) {
                persistenceEntry2.setString(string);
            }
            persistenceEntry.deleteValue();
        }
    }
}

