/*
 * Decompiled with CFR 0.152.
 */
package biweekly.util.com.google.ical.iter;

import java.util.BitSet;

final class IntSet {
    private final BitSet ints = new BitSet();

    IntSet() {
    }

    void add(int n) {
        this.ints.set(IntSet.encode(n));
    }

    boolean contains(int n) {
        return this.ints.get(IntSet.encode(n));
    }

    int size() {
        return this.ints.cardinality();
    }

    int[] toIntArray() {
        int[] out = new int[this.size()];
        int a = 0;
        int b = out.length;
        int i = -1;
        while ((i = this.ints.nextSetBit(i + 1)) >= 0) {
            int n = IntSet.decode(i);
            if (n < 0) {
                out[a++] = n;
                continue;
            }
            out[--b] = n;
        }
        IntSet.reverse(out, 0, a);
        IntSet.reverse(out, a, out.length);
        return out;
    }

    private static int encode(int n) {
        return n < 0 ? (-n << 1) + 1 : n << 1;
    }

    private static int decode(int i) {
        return (i >>> 1) * (-(i & 1) | 1);
    }

    private static void reverse(int[] array, int start, int end) {
        int j = end;
        for (int i = start; i < --j; ++i) {
            int t = array[i];
            array[i] = array[j];
            array[j] = t;
        }
    }
}

