/*
 * Decompiled with CFR 0.152.
 */
package com.github.mangstadt.vinnie.io;

import com.github.mangstadt.vinnie.SyntaxStyle;
import com.github.mangstadt.vinnie.Utils;
import com.github.mangstadt.vinnie.VObjectProperty;
import com.github.mangstadt.vinnie.codec.DecoderException;
import com.github.mangstadt.vinnie.codec.QuotedPrintableCodec;
import com.github.mangstadt.vinnie.io.Buffer;
import com.github.mangstadt.vinnie.io.Context;
import com.github.mangstadt.vinnie.io.SyntaxRules;
import com.github.mangstadt.vinnie.io.VObjectDataListener;
import com.github.mangstadt.vinnie.io.Warning;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.List;

public class VObjectReader
implements Closeable {
    private final String NEWLINE = System.getProperty("line.separator");
    private final Reader reader;
    private final SyntaxRules syntaxRules;
    private boolean caretDecodingEnabled = true;
    private Charset defaultQuotedPrintableCharset;
    private final ComponentStack stack;
    private final Buffer buffer = new Buffer();
    private final Context context;
    private int leftOver = -1;
    private int lineNumber = 1;
    private boolean eos = false;

    public VObjectReader(Reader reader, SyntaxRules syntaxRules) {
        this.reader = reader;
        this.syntaxRules = syntaxRules;
        this.stack = new ComponentStack(syntaxRules.getDefaultSyntaxStyle());
        this.context = new Context(this.stack.names);
        if (reader instanceof InputStreamReader) {
            InputStreamReader isr = (InputStreamReader)reader;
            this.defaultQuotedPrintableCharset = Charset.forName(isr.getEncoding());
        } else {
            this.defaultQuotedPrintableCharset = Charset.defaultCharset();
        }
    }

    public Charset getDefaultQuotedPrintableCharset() {
        return this.defaultQuotedPrintableCharset;
    }

    public void setDefaultQuotedPrintableCharset(Charset charset) {
        this.defaultQuotedPrintableCharset = charset;
    }

    public boolean isCaretDecodingEnabled() {
        return this.caretDecodingEnabled;
    }

    public void setCaretDecodingEnabled(boolean enable) {
        this.caretDecodingEnabled = enable;
    }

    public void parse(VObjectDataListener listener) throws IOException {
        this.context.stop = false;
        while (!this.eos && !this.context.stop) {
            String parentComponent;
            String componentName;
            this.context.lineNumber = this.lineNumber;
            this.buffer.clear();
            this.context.unfoldedLine.clear();
            VObjectProperty property = this.parseProperty(listener);
            if (this.context.unfoldedLine.size() == 0) {
                return;
            }
            if (property == null) {
                listener.onWarning(Warning.MALFORMED_LINE, null, null, this.context);
                continue;
            }
            if ("BEGIN".equalsIgnoreCase(property.getName().trim())) {
                componentName = property.getValue().trim().toUpperCase();
                if (componentName.length() == 0) {
                    listener.onWarning(Warning.EMPTY_BEGIN, null, null, this.context);
                    continue;
                }
                listener.onComponentBegin(componentName, this.context);
                this.stack.push(componentName);
                continue;
            }
            if ("END".equalsIgnoreCase(property.getName().trim())) {
                componentName = property.getValue().trim().toUpperCase();
                if (componentName.length() == 0) {
                    listener.onWarning(Warning.EMPTY_END, null, null, this.context);
                    continue;
                }
                int popCount = this.stack.popCount(componentName);
                if (popCount == 0) {
                    listener.onWarning(Warning.UNMATCHED_END, null, null, this.context);
                    continue;
                }
                while (popCount > 0) {
                    String poppedName = this.stack.pop();
                    listener.onComponentEnd(poppedName, this.context);
                    --popCount;
                }
                continue;
            }
            if ("VERSION".equalsIgnoreCase(property.getName()) && this.syntaxRules.hasSyntaxRules(parentComponent = this.stack.peekName())) {
                SyntaxStyle style = this.syntaxRules.getSyntaxStyle(parentComponent, property.getValue());
                if (style == null) {
                    listener.onWarning(Warning.UNKNOWN_VERSION, property, null, this.context);
                } else {
                    listener.onVersion(property.getValue(), this.context);
                    this.stack.updateSyntax(style);
                    continue;
                }
            }
            listener.onProperty(property, this.context);
        }
    }

    private VObjectProperty parseProperty(VObjectDataListener listener) throws IOException {
        VObjectProperty property = new VObjectProperty();
        SyntaxStyle syntax = this.stack.peekSyntax();
        String curParamName = null;
        char paramValueEscapeChar = '\u0000';
        boolean inQuotes = false;
        boolean inValue = false;
        boolean foldedQuotedPrintableLine = false;
        boolean inFoldedLineWhitespace = false;
        char ch = '\u0000';
        block17: while (true) {
            char prevChar = ch;
            int read = this.nextChar();
            if (read < 0) {
                this.eos = true;
                break;
            }
            ch = (char)read;
            if (prevChar == '\r' && ch == '\n') continue;
            if (VObjectReader.isNewline(ch)) {
                boolean bl = foldedQuotedPrintableLine = inValue && prevChar == '=' && property.getParameters().isQuotedPrintable();
                if (foldedQuotedPrintableLine) {
                    this.buffer.chop();
                    this.context.unfoldedLine.chop();
                }
                ++this.lineNumber;
                continue;
            }
            if (VObjectReader.isNewline(prevChar)) {
                if (VObjectReader.isWhitespace(ch)) {
                    inFoldedLineWhitespace = true;
                    continue;
                }
                if (!foldedQuotedPrintableLine) {
                    this.leftOver = ch;
                    break;
                }
            }
            if (inFoldedLineWhitespace) {
                if (VObjectReader.isWhitespace(ch) && syntax == SyntaxStyle.OLD) continue;
                inFoldedLineWhitespace = false;
            }
            this.context.unfoldedLine.append(ch);
            if (inValue) {
                this.buffer.append(ch);
                continue;
            }
            if (paramValueEscapeChar != '\u0000') {
                char escapeChar = paramValueEscapeChar;
                paramValueEscapeChar = '\u0000';
                switch (escapeChar) {
                    case '\\': {
                        switch (ch) {
                            case '\\': {
                                this.buffer.append(ch);
                                continue block17;
                            }
                            case ';': {
                                this.buffer.append(ch);
                                continue block17;
                            }
                        }
                        break;
                    }
                    case '^': {
                        switch (ch) {
                            case '^': {
                                this.buffer.append(ch);
                                continue block17;
                            }
                            case 'n': {
                                this.buffer.append(this.NEWLINE);
                                continue block17;
                            }
                            case '\'': {
                                this.buffer.append('\"');
                                continue block17;
                            }
                        }
                    }
                }
                this.buffer.append(escapeChar).append(ch);
                continue;
            }
            if (curParamName != null) {
                switch (syntax) {
                    case OLD: {
                        if (ch != '\\') break;
                        paramValueEscapeChar = ch;
                        continue block17;
                    }
                    case NEW: {
                        if (ch != '^' || !this.caretDecodingEnabled) break;
                        paramValueEscapeChar = ch;
                        continue block17;
                    }
                }
            }
            if (ch == '.' && property.getGroup() == null && property.getName() == null) {
                property.setGroup(this.buffer.getAndClear());
                continue;
            }
            if (!(ch != ';' && ch != ':' || inQuotes)) {
                if (property.getName() == null) {
                    property.setName(this.buffer.getAndClear());
                } else {
                    String paramValue = this.buffer.getAndClear();
                    if (syntax == SyntaxStyle.OLD) {
                        paramValue = Utils.ltrim(paramValue);
                    }
                    property.getParameters().put(curParamName, paramValue);
                    curParamName = null;
                }
                if (ch != 58) continue;
                inValue = true;
                continue;
            }
            if (property.getName() != null) {
                if (ch == ',' && curParamName != null && !inQuotes && syntax != SyntaxStyle.OLD) {
                    String paramValue = this.buffer.getAndClear();
                    property.getParameters().put(curParamName, paramValue);
                    continue;
                }
                if (ch == '=' && curParamName == null) {
                    String paramName = this.buffer.getAndClear().toUpperCase();
                    if (syntax == SyntaxStyle.OLD) {
                        paramName = Utils.rtrim(paramName);
                    }
                    curParamName = paramName;
                    continue;
                }
                if (ch == '\"' && curParamName != null && syntax != SyntaxStyle.OLD) {
                    inQuotes = !inQuotes;
                    continue;
                }
            }
            this.buffer.append(ch);
        }
        if (!inValue) {
            return null;
        }
        property.setValue(this.buffer.getAndClear());
        if (property.getParameters().isQuotedPrintable()) {
            this.decodeQuotedPrintable(property, listener);
        }
        return property;
    }

    private void decodeQuotedPrintable(VObjectProperty property, VObjectDataListener listener) {
        Charset charset = this.getCharset(property, listener);
        if (charset == null) {
            charset = this.defaultQuotedPrintableCharset;
        }
        String value = property.getValue();
        QuotedPrintableCodec codec = new QuotedPrintableCodec(charset.name());
        try {
            value = codec.decode(value);
        }
        catch (DecoderException e) {
            listener.onWarning(Warning.QUOTED_PRINTABLE_ERROR, property, e, this.context);
            return;
        }
        property.setValue(value);
    }

    private Charset getCharset(VObjectProperty property, VObjectDataListener listener) {
        IllegalArgumentException thrown;
        try {
            return property.getParameters().getCharset();
        }
        catch (IllegalCharsetNameException e) {
            thrown = e;
        }
        catch (UnsupportedCharsetException e) {
            thrown = e;
        }
        listener.onWarning(Warning.UNKNOWN_CHARSET, property, thrown, this.context);
        return null;
    }

    private int nextChar() throws IOException {
        if (this.leftOver >= 0) {
            int ch = this.leftOver;
            this.leftOver = -1;
            return ch;
        }
        return this.reader.read();
    }

    private static boolean isNewline(char ch) {
        return ch == '\n' || ch == '\r';
    }

    private static boolean isWhitespace(char ch) {
        return ch == ' ' || ch == '\t';
    }

    public void close() throws IOException {
        this.reader.close();
    }

    private static class ComponentStack {
        private final List<String> names = new ArrayList<String>();
        private final List<SyntaxStyle> syntax = new ArrayList<SyntaxStyle>();

        public ComponentStack(SyntaxStyle defaultSyntax) {
            this.syntax.add(defaultSyntax);
        }

        public void push(String component) {
            this.names.add(component);
            this.syntax.add(this.peekSyntax());
        }

        public String pop() {
            this.syntax.remove(this.syntax.size() - 1);
            return this.names.remove(this.names.size() - 1);
        }

        public int popCount(String name) {
            int index = this.names.lastIndexOf(name);
            return index < 0 ? 0 : this.names.size() - index;
        }

        public String peekName() {
            return this.names.isEmpty() ? null : this.names.get(this.names.size() - 1);
        }

        public SyntaxStyle peekSyntax() {
            return this.syntax.isEmpty() ? null : this.syntax.get(this.syntax.size() - 1);
        }

        public void updateSyntax(SyntaxStyle style) {
            this.syntax.set(this.syntax.size() - 1, style);
        }
    }
}

