/*
 * Decompiled with CFR 0.152.
 */
package com.inet.avatar.server.providers;

import com.inet.avatar.server.AvatarServerPlugin;
import com.inet.avatar.server.AvatarUtils;
import com.inet.avatar.server.providers.AvatarProvider;
import com.inet.http.ClientMessageException;
import com.inet.lib.util.StringFunctions;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;

public class b
implements AvatarProvider {
    @Override
    @Nonnull
    public String getKey() {
        return "gravatar";
    }

    @Override
    @Nonnull
    public String getDisplayName() {
        return AvatarServerPlugin.MSG.getMsg("avatarprovider.displayName.gravatar", new Object[0]);
    }

    @Override
    public byte @Nullable [] requestAvatar(@Nonnull String emailAddress) throws Exception {
        BufferedImage bufferedImage;
        if (StringFunctions.isEmpty((String)emailAddress)) {
            throw new IllegalArgumentException("invalid email address: \"" + emailAddress + "\"");
        }
        emailAddress = emailAddress.trim().toLowerCase();
        String string = AvatarUtils.md5Hash(emailAddress.getBytes(StandardCharsets.UTF_8));
        URL uRL = new URL("https://www.gravatar.com/avatar/" + string + ".png?s=300&d=404");
        try {
            bufferedImage = ImageIO.read(uRL);
        }
        catch (IOException iOException) {
            if (iOException.getCause() instanceof FileNotFoundException) {
                throw new ClientMessageException(AvatarServerPlugin.MSG.getMsg("avatarprovider.error.noimage", new Object[0]));
            }
            throw new ClientMessageException(AvatarServerPlugin.MSG.getMsg("avatarprovider.error.connection", new Object[0]));
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage, "png", byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }
}

