/*
 * Decompiled with CFR 0.152.
 */
package com.inet.avatar.server;

import com.inet.avatar.server.AvatarUtils;
import com.inet.avatar.server.providers.AvatarProvider;
import com.inet.id.GUID;
import com.inet.plugin.image.AvatarMetadata;
import com.inet.plugin.image.UserAvatar;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.ui.fields.EmailAddressHelper;
import com.inet.usersandgroups.api.user.MutableUserData;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAvatarAutomaticUpdater;
import com.inet.usersandgroups.api.user.UserManager;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class b
implements UserAvatarAutomaticUpdater {
    private static final long d = TimeUnit.DAYS.toMillis(1L);
    private final Map<String, AvatarProvider> c;

    public b(@Nonnull Map<String, AvatarProvider> map) {
        if (map == null) {
            throw new IllegalArgumentException("map must not be null");
        }
        this.c = map;
    }

    public void updateAvatarIfNeeded(@Nonnull GUID userAccountID) {
        boolean bl;
        String string;
        byte[] byArray;
        boolean bl2;
        UserManager userManager = UserManager.getRecoveryEnabledInstance();
        UserAccount userAccount = userManager.getUserAccount(userAccountID);
        if (userAccount == null) {
            return;
        }
        String string2 = (String)userAccount.getValue((UserField)UserAvatar.FIELD_AVATAR_PROVIDER);
        if (string2 == null) {
            return;
        }
        AvatarProvider avatarProvider = this.c.get(string2);
        if (avatarProvider == null) {
            return;
        }
        AvatarMetadata avatarMetadata = (AvatarMetadata)userAccount.getValue((UserField)UserAvatar.FIELD_AVATAR_METADATA);
        String string3 = avatarMetadata != null ? avatarMetadata.getChecksum() : "";
        long l = avatarMetadata != null ? avatarMetadata.getLastCheck() : -1L;
        boolean bl3 = bl2 = l < 0L || System.currentTimeMillis() - l > d;
        if (!bl2) {
            return;
        }
        String string4 = (String)userAccount.getValue((UserField)UsersAndGroups.FIELD_EMAIL);
        String string5 = EmailAddressHelper.get().getFirstEmailAddress(string4);
        if (string5 == null) {
            return;
        }
        try {
            byArray = avatarProvider.requestAvatar(string5);
        }
        catch (Exception exception) {
            UsersAndGroups.LOGGER.debug((Object)("Following exception occurred during automatic update of avatar for user account with ID \" " + userAccountID.toString() + "\":"));
            UsersAndGroups.LOGGER.debug((Object)exception);
            this.a(userManager, userAccountID, new AvatarMetadata(string3, System.currentTimeMillis()));
            return;
        }
        if (byArray == null) {
            AvatarUtils.switchToManualAvatarUpdates(userAccountID);
            return;
        }
        try {
            string = AvatarUtils.avatarChecksum(byArray);
            bl = !Objects.equals(string3, string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            string = "";
            bl = true;
        }
        if (bl) {
            userManager.storeBinaryData(userAccountID, UserAvatar.BINARYKEY_USERAVATAR, (InputStream)new ByteArrayInputStream(byArray), byArray.length);
        }
        this.a(userManager, userAccountID, new AvatarMetadata(string, System.currentTimeMillis()));
    }

    private void a(@Nonnull UserManager userManager, @Nonnull GUID gUID, @Nullable AvatarMetadata avatarMetadata) {
        MutableUserData mutableUserData = new MutableUserData();
        mutableUserData.put((UserField)UserAvatar.FIELD_AVATAR_METADATA, (Object)avatarMetadata);
        userManager.updateUserData(gUID, mutableUserData);
    }
}

