/*
 * Decompiled with CFR 0.152.
 */
package com.inet.avatar.server;

import com.inet.annotations.InternalApi;
import com.inet.avatar.server.AvatarServerPlugin;
import com.inet.avatar.server.providers.AvatarProvider;
import com.inet.config.ConfigValue;
import com.inet.id.GUID;
import com.inet.plugin.image.AvatarMetadata;
import com.inet.plugin.image.UserAvatar;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.user.MutableUserData;
import com.inet.usersandgroups.api.user.UserManager;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.SuppressFBWarnings;

@InternalApi
public class AvatarUtils {
    public static final ConfigValue<List<String>> ENABLED_AVATAR_PROVIDERS = new ConfigValue(AvatarServerPlugin.CONFIGKEY_AVATAR_PROVIDERS);
    private static Map<String, AvatarProvider> c;

    @Nonnull
    public static String avatarChecksum(byte @Nonnull [] input) throws NoSuchAlgorithmException {
        return AvatarUtils.md5Hash(input) + "_" + input.length;
    }

    @Nonnull
    @SuppressFBWarnings(value={"WEAK_MESSAGE_DIGEST_MD5"}, justification="MD5 hash is not used for security issues")
    public static String md5Hash(byte @Nonnull [] input) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        byte[] byArray = messageDigest.digest(input);
        StringBuilder stringBuilder = new StringBuilder();
        for (byte by : byArray) {
            stringBuilder.append(String.format("%02x", by));
        }
        return stringBuilder.toString();
    }

    public static void updateUserAvatarAndProviderMetaData(@Nonnull GUID userAccountID, @Nonnull String providerKey, byte @Nonnull [] avatar) {
        String string;
        UserManager userManager = UserManager.getRecoveryEnabledInstance();
        userManager.storeBinaryData(userAccountID, UserAvatar.BINARYKEY_USERAVATAR, (InputStream)new ByteArrayInputStream(avatar), avatar.length);
        try {
            string = AvatarUtils.avatarChecksum(avatar);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            string = "";
        }
        MutableUserData mutableUserData = new MutableUserData();
        mutableUserData.put((UserField)UserAvatar.FIELD_AVATAR_PROVIDER, (Object)providerKey);
        mutableUserData.put((UserField)UserAvatar.FIELD_AVATAR_METADATA, (Object)new AvatarMetadata(string, System.currentTimeMillis()));
        userManager.updateUserData(userAccountID, mutableUserData);
    }

    public static void switchToManualAvatarUpdates(@Nonnull GUID userAccountID) {
        UserManager userManager = UserManager.getRecoveryEnabledInstance();
        MutableUserData mutableUserData = new MutableUserData();
        mutableUserData.put((UserField)UserAvatar.FIELD_AVATAR_PROVIDER, null);
        mutableUserData.put((UserField)UserAvatar.FIELD_AVATAR_METADATA, null);
        userManager.updateUserData(userAccountID, mutableUserData);
    }

    @Nonnull
    public static Map<String, AvatarProvider> getAvailableProviders() {
        return c;
    }

    public static void setRegisteredProviders(@Nonnull Map<String, AvatarProvider> avatarProvidersByKey) {
        c = avatarProvidersByKey;
    }
}

