/*
 * Decompiled with CFR 0.152.
 */
package com.inet.avatar.server.structure;

import com.inet.annotations.JsonData;
import com.inet.avatar.server.AvatarServerPlugin;
import com.inet.avatar.server.providers.AvatarProvider;
import com.inet.avatar.server.structure.a;
import com.inet.config.structure.model.ConfigAction;
import com.inet.config.structure.model.ConfigCondition;
import com.inet.config.structure.model.ConfigRowAction;
import com.inet.config.structure.model.ItemListConfigProperty;
import com.inet.config.structure.provider.ConfigStructureSettings;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonParameterizedType;
import com.inet.lib.util.StringFunctions;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

@JsonData
public class AvatarItemListConfigProperty
extends ItemListConfigProperty {
    public AvatarItemListConfigProperty(int sortid, @Nonnull ConfigStructureSettings settings, @Nonnull a structureProvider) {
        super(sortid, AvatarServerPlugin.CONFIGKEY_AVATAR_PROVIDERS.getKey(), "ItemListAvatarProviders", AvatarItemListConfigProperty.getValue(settings, structureProvider.a()), structureProvider.translate(settings, "avatarprovider.add", new Object[0]), AvatarItemListConfigProperty.createRowActions(settings, structureProvider, structureProvider.a()));
        this.setDuplicatePossible(false);
        this.setManuallySortable(true);
    }

    private static ConfigRowAction[] createRowActions(@Nonnull ConfigStructureSettings settings, @Nonnull a structureProvider, @Nonnull List<AvatarProvider> avatarProviders) {
        ConfigRowAction[] configRowActionArray = new ConfigRowAction[avatarProviders.size()];
        for (int i = 0; i < avatarProviders.size(); ++i) {
            AvatarProvider avatarProvider = avatarProviders.get(i);
            String string = avatarProvider.getDisplayName();
            if (avatarProviders.size() == 1) {
                string = structureProvider.translate(settings, "avatarprovider.add.provider", new Object[]{string});
            }
            ConfigAction configAction = new ConfigAction("avatar-provider-action." + avatarProvider.getKey() + ".add", string);
            ConfigCondition configCondition = new ConfigCondition(ConfigCondition.Operation.Equals, new Object[]{"key", avatarProvider.getKey()});
            ConfigRowAction configRowAction = new ConfigRowAction(configAction, configCondition, null, null, null, null);
            configRowAction.setAddMultipleEntriesAllowed(false);
            configRowActionArray[i] = configRowAction;
        }
        return configRowActionArray;
    }

    static List<HashMap<String, String>> getValue(@Nonnull ConfigStructureSettings settings, @Nonnull List<AvatarProvider> avatarProviders) {
        String string = AvatarServerPlugin.CONFIGKEY_AVATAR_PROVIDERS.getKey();
        String string2 = settings.getChangedValue(string);
        if (string2 != null) {
            JsonParameterizedType jsonParameterizedType = new JsonParameterizedType(ArrayList.class, new Type[]{new JsonParameterizedType(HashMap.class, new Type[]{String.class, String.class})});
            return (List)new Json().fromJson(string2, (Type)jsonParameterizedType);
        }
        String string3 = settings.getValue(string);
        if (StringFunctions.isEmpty((String)string3)) {
            return new ArrayList<HashMap<String, String>>();
        }
        ArrayList arrayList = (ArrayList)new Json().fromJson(string3, (Type)new JsonParameterizedType(ArrayList.class, new Type[]{String.class}), new HashMap());
        if (arrayList == null) {
            return new ArrayList<HashMap<String, String>>();
        }
        return arrayList.stream().map(key -> AvatarItemListConfigProperty.createPropertiesForAvatarProvider(key, avatarProviders)).collect(Collectors.toList());
    }

    static HashMap<String, String> createPropertiesForAvatarProvider(@Nonnull String key, @Nonnull List<AvatarProvider> avatarProviders) {
        String string = avatarProviders.stream().filter(p -> Objects.equals(p.getKey(), key)).findFirst().map(AvatarProvider::getDisplayName).orElse(key);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("key", key);
        hashMap.put("displayName", string);
        return hashMap;
    }
}

