/*
 * Decompiled with CFR 0.152.
 */
package com.inet.authentication.twofactor.server.webauthn;

import com.inet.authentication.LoginProcessor;
import com.inet.authentication.twofactor.TwoFactorAuthenticationServerPlugin;
import com.inet.authentication.twofactor.api.TwoFactorProvider;
import com.inet.authentication.twofactor.client.handler.WebAuthnGetCredentialsResponse;
import com.inet.error.ErrorCode;
import com.inet.http.servlet.SessionStore;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.util.IOFunctions;
import com.inet.plugin.ApplicationDescription;
import com.inet.remote.gui.angular.ReplaceOutputStream;
import com.inet.shared.servlet.ProxyHttpServletRequest;
import com.inet.usersandgroups.api.user.UserAccount;
import com.webauthn4j.WebAuthnManager;
import com.webauthn4j.credential.CredentialRecord;
import com.webauthn4j.credential.CredentialRecordImpl;
import com.webauthn4j.data.AuthenticationData;
import com.webauthn4j.data.AuthenticationParameters;
import com.webauthn4j.data.AuthenticationRequest;
import com.webauthn4j.data.RegistrationData;
import com.webauthn4j.data.RegistrationRequest;
import com.webauthn4j.data.client.Origin;
import com.webauthn4j.data.client.challenge.Challenge;
import com.webauthn4j.server.ServerProperty;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ForkJoinPool;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;

public class a
implements TwoFactorProvider {
    private static WebAuthnManager m;

    public a() {
        ForkJoinPool.commonPool().execute(() -> a.c());
    }

    @Nonnull
    public String getExtensionName() {
        return "webauthn";
    }

    @Override
    public String getDisplayName() {
        return TwoFactorAuthenticationServerPlugin.MSG.getMsg("twofactor.webauthn.displayname", new Object[0]);
    }

    @Override
    public boolean available(@Nonnull UserAccount user) {
        block5: {
            HttpServletRequest httpServletRequest = SessionStore.getHttpServletRequest();
            if (httpServletRequest != null) {
                try {
                    URL uRL = new URL(ProxyHttpServletRequest.getHttpServerPort((HttpServletRequest)httpServletRequest).toString());
                    String string = uRL.getProtocol();
                    String string2 = uRL.getHost();
                    if ("https".equals(string)) {
                        for (int i = 0; i < string2.length(); ++i) {
                            if (!Character.isAlphabetic(string2.charAt(i))) continue;
                            return true;
                        }
                        break block5;
                    }
                    return "localhost".equals(string2);
                }
                catch (MalformedURLException malformedURLException) {
                    ErrorCode.throwAny((Throwable)malformedURLException);
                }
            }
        }
        return false;
    }

    @Override
    @Nullable
    public String createData(GUID accountID) {
        return "";
    }

    @Override
    public String showCurrentSettings(@Nonnull UserAccount user, String data, boolean isNew) {
        String string;
        block8: {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("userID", user.getID().toString());
            hashMap.put("displayName", user.getDisplayName());
            hashMap.put("challenge", GUID.generateNew().toString());
            hashMap.put("app", ApplicationDescription.get().getApplicationName());
            hashMap.put("instructions", TwoFactorAuthenticationServerPlugin.MSG.getMsg("twofactor.webauthn.instructions", new Object[0]));
            InputStream inputStream = this.getClass().getResourceAsStream("showCurrentSettings.html");
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ReplaceOutputStream replaceOutputStream = new ReplaceOutputStream((OutputStream)byteArrayOutputStream, hashMap);
                IOFunctions.copyData((InputStream)inputStream, (OutputStream)replaceOutputStream);
                replaceOutputStream.close();
                string = byteArrayOutputStream.toString(StandardCharsets.UTF_8);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    ErrorCode.throwAny((Throwable)iOException);
                    return null;
                }
            }
            inputStream.close();
        }
        return string;
    }

    @Nonnull
    private static WebAuthnManager c() {
        WebAuthnManager webAuthnManager = m;
        if (webAuthnManager == null) {
            m = webAuthnManager = WebAuthnManager.createNonStrictWebAuthnManager();
        }
        return webAuthnManager;
    }

    private static CredentialRecordImpl a(@Nonnull HashMap<String, Object> hashMap) {
        byte[] byArray = a.a(hashMap, "attestationObject");
        byte[] byArray2 = a.a(hashMap, "clientDataJSON");
        HashSet hashSet = new HashSet((Collection)hashMap.get("transports"));
        RegistrationRequest registrationRequest = new RegistrationRequest(byArray, byArray2, null, hashSet);
        RegistrationData registrationData = a.c().parse(registrationRequest);
        return new CredentialRecordImpl(registrationData.getAttestationObject(), registrationData.getCollectedClientData(), registrationData.getClientExtensions(), registrationData.getTransports());
    }

    @Override
    public boolean validateTwoFactorCode(String code, String data) {
        try {
            @Nonnull HashMap hashMap = (HashMap)new Json().fromJson(data, HashMap.class);
            List<byte[]> list = Collections.singletonList(a.a(hashMap, "rawId"));
            CredentialRecordImpl credentialRecordImpl = a.a(hashMap);
            hashMap = (HashMap)new Json().fromJson(code, HashMap.class);
            byte[] byArray = a.a(hashMap, "rawId");
            byte[] byArray2 = a.a(hashMap, "userHandle");
            byte[] byArray3 = a.a(hashMap, "authenticatorData");
            byte[] byArray4 = a.a(hashMap, "clientDataJSON");
            byte[] byArray5 = a.a(hashMap, "signature");
            AuthenticationRequest authenticationRequest = new AuthenticationRequest(byArray, byArray2, byArray3, byArray4, null, byArray5);
            WebAuthnManager webAuthnManager = a.c();
            AuthenticationData authenticationData = webAuthnManager.parse(authenticationRequest);
            Origin origin = new Origin(ProxyHttpServletRequest.getHttpServerPort((HttpServletRequest)SessionStore.getHttpServletRequest()).toString());
            String string = origin.getHost();
            Challenge challenge = () -> ((String)SessionStore.getHttpSession().getAttribute("webauthn.challenge")).getBytes();
            ServerProperty serverProperty = new ServerProperty(origin, string, challenge, null);
            AuthenticationParameters authenticationParameters = new AuthenticationParameters(serverProperty, (CredentialRecord)credentialRecordImpl, list, false, true);
            webAuthnManager.verify(authenticationData, authenticationParameters);
            return true;
        }
        catch (Throwable throwable) {
            LoginProcessor.LOGGER.error(throwable);
            return false;
        }
    }

    private static byte[] a(@Nonnull HashMap<String, Object> hashMap, @Nonnull String string) {
        String string2 = (String)hashMap.get(string);
        return string2 != null ? Base64.getDecoder().decode(string2) : null;
    }

    @SuppressFBWarnings(value={"TRUST_BOUNDARY_VIOLATION"}, justification="data are save")
    public static WebAuthnGetCredentialsResponse a(@Nonnull String string, @Nonnull HttpServletRequest httpServletRequest) {
        HashMap hashMap = (HashMap)new Json().fromJson(string, HashMap.class);
        String string2 = (String)hashMap.get("rawId");
        HttpSession httpSession = httpServletRequest.getSession();
        String string3 = GUID.generateNew().toString();
        httpSession.setAttribute("webauthn.challenge", (Object)string3);
        return new WebAuthnGetCredentialsResponse(string2, string3);
    }

    @Override
    public boolean supportsMultipleSettings() {
        return true;
    }
}

